/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDMatrix;
import org.apache.pdfbox.pdmodel.graphics.color.ColorSpaceCalRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDGamma;
import org.apache.pdfbox.pdmodel.graphics.color.PDTristimulus;

public class PDCalRGB
extends PDColorSpace {
    public static final String NAME = "CalRGB";
    private COSArray array;
    private COSDictionary dictionary;

    public PDCalRGB() {
        this.array = new COSArray();
        this.dictionary = new COSDictionary();
        this.array.add(COSName.CALRGB);
        this.array.add(this.dictionary);
    }

    public PDCalRGB(COSArray rgb) {
        this.array = rgb;
        this.dictionary = (COSDictionary)this.array.getObject(1);
    }

    public int getNumberOfComponents() throws IOException {
        return 3;
    }

    public String getName() {
        return NAME;
    }

    protected ColorSpace createColorSpace() {
        return new ColorSpaceCalRGB(this.getGamma(), this.getWhitepoint(), this.getBlackPoint(), this.getLinearInterpretation());
    }

    public ColorModel createColorModel(int bpc) throws IOException {
        throw new IOException("Not implemented");
    }

    public COSBase getCOSObject() {
        return this.array;
    }

    public PDTristimulus getWhitepoint() {
        COSArray wp = (COSArray)this.dictionary.getDictionaryObject(COSName.WHITE_POINT);
        if (wp == null) {
            wp = new COSArray();
            wp.add(new COSFloat(1.0f));
            wp.add(new COSFloat(1.0f));
            wp.add(new COSFloat(1.0f));
            this.dictionary.setItem(COSName.WHITE_POINT, (COSBase)wp);
        }
        return new PDTristimulus(wp);
    }

    public void setWhitepoint(PDTristimulus wp) {
        COSBase wpArray = wp.getCOSObject();
        if (wpArray != null) {
            this.dictionary.setItem(COSName.WHITE_POINT, wpArray);
        }
    }

    public PDTristimulus getBlackPoint() {
        COSArray bp = (COSArray)this.dictionary.getDictionaryObject(COSName.BLACK_POINT);
        if (bp == null) {
            bp = new COSArray();
            bp.add(new COSFloat(0.0f));
            bp.add(new COSFloat(0.0f));
            bp.add(new COSFloat(0.0f));
            this.dictionary.setItem(COSName.BLACK_POINT, (COSBase)bp);
        }
        return new PDTristimulus(bp);
    }

    public void setBlackPoint(PDTristimulus bp) {
        COSBase bpArray = null;
        if (bp != null) {
            bpArray = bp.getCOSObject();
        }
        this.dictionary.setItem(COSName.BLACK_POINT, bpArray);
    }

    public PDGamma getGamma() {
        COSArray gamma = (COSArray)this.dictionary.getDictionaryObject(COSName.GAMMA);
        if (gamma == null) {
            gamma = new COSArray();
            gamma.add(new COSFloat(1.0f));
            gamma.add(new COSFloat(1.0f));
            gamma.add(new COSFloat(1.0f));
            this.dictionary.setItem(COSName.GAMMA, (COSBase)gamma);
        }
        return new PDGamma(gamma);
    }

    public void setGamma(PDGamma value) {
        COSArray gamma = null;
        if (value != null) {
            gamma = value.getCOSArray();
        }
        this.dictionary.setItem(COSName.GAMMA, (COSBase)gamma);
    }

    public PDMatrix getLinearInterpretation() {
        PDMatrix retval = null;
        COSArray matrix = (COSArray)this.dictionary.getDictionaryObject(COSName.MATRIX);
        if (matrix == null) {
            retval = new PDMatrix();
            this.setLinearInterpretation(retval);
        } else {
            retval = new PDMatrix(matrix);
        }
        return retval;
    }

    public void setLinearInterpretation(PDMatrix matrix) {
        COSArray matrixArray = null;
        if (matrix != null) {
            matrixArray = matrix.getCOSArray();
        }
        this.dictionary.setItem(COSName.MATRIX, (COSBase)matrixArray);
    }
}

