/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.PDFTextStripper;
import org.apache.pdfbox.util.TextPosition;

public class PDFText2HTML
extends PDFTextStripper {
    private static final int INITIAL_PDF_TO_HTML_BYTES = 8192;
    private boolean onFirstPage = true;

    public PDFText2HTML(String encoding) throws IOException {
        this.outputEncoding = encoding;
        this.lineSeparator = "<br>" + System.getProperty("line.separator");
    }

    protected void writeHeader() throws IOException {
        StringBuffer buf = new StringBuffer(8192);
        buf.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n\"http://www.w3.org/TR/html4/loose.dtd\">\n");
        buf.append("<html><head>");
        buf.append("<title>" + this.getTitle() + "</title>\n");
        if (this.outputEncoding != null) {
            buf.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.outputEncoding + "\">\n");
        }
        buf.append("</head>\n");
        buf.append("<body>\n");
        super.writeString(buf.toString());
    }

    protected void writePage() throws IOException {
        if (this.onFirstPage) {
            this.writeHeader();
            this.onFirstPage = false;
        }
        super.writePage();
    }

    public void endDocument(PDDocument pdf) throws IOException {
        super.writeString("</body></html>");
    }

    protected String getTitle() {
        String titleGuess = this.document.getDocumentInformation().getTitle();
        if (titleGuess != null && titleGuess.length() > 0) {
            return titleGuess;
        }
        Iterator<List<TextPosition>> textIter = this.getCharactersByArticle().iterator();
        float lastFontSize = -1.0f;
        StringBuffer titleText = new StringBuffer();
        while (textIter.hasNext()) {
            for (TextPosition position : textIter.next()) {
                float currentFontSize = position.getFontSize();
                if (currentFontSize != lastFontSize || titleText.length() > 64) {
                    if (titleText.length() > 0) {
                        return titleText.toString();
                    }
                    lastFontSize = currentFontSize;
                }
                if (!(currentFontSize > 13.0f)) continue;
                titleText.append(position.getCharacter());
            }
        }
        return "";
    }

    protected void startArticle(boolean isltr) throws IOException {
        if (isltr) {
            super.writeString("<div>");
        } else {
            super.writeString("<div dir=\"RTL\">");
        }
    }

    protected void endArticle() throws IOException {
        super.writeString("</div>");
    }

    protected void writeString(String chars) throws IOException {
        block6: for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            if (c < ' ' || c > '~') {
                char charAsInt = c;
                super.writeString("&#" + charAsInt + ";");
                continue;
            }
            switch (c) {
                case '\"': {
                    super.writeString("&quot;");
                    continue block6;
                }
                case '&': {
                    super.writeString("&amp;");
                    continue block6;
                }
                case '<': {
                    super.writeString("&lt;");
                    continue block6;
                }
                case '>': {
                    super.writeString("&gt;");
                    continue block6;
                }
                default: {
                    super.writeString(String.valueOf(c));
                }
            }
        }
    }
}

