/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.account.model.hibernate;

import gov.nih.tbi.account.model.hibernate.Account;
import gov.nih.tbi.commons.model.AbstractBricsObject;
import gov.nih.tbi.commons.model.RoleStatus;
import gov.nih.tbi.commons.model.RoleType;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="ACCOUNT_ROLE")
public class AccountRole
extends AbstractBricsObject
implements Serializable {
    private static final long serialVersionUID = -9001636980907801431L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_ROLE_SEQ")
    @SequenceGenerator(name="ACCOUNT_ROLE_SEQ", sequenceName="ACCOUNT_ROLE_SEQ", allocationSize=1)
    private Long id;
    @XmlTransient
    @ManyToOne
    @JoinColumn(name="ACCOUNT_ID")
    private Account account;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="ROLE_TYPE_ID")
    private RoleType roleType;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="ROLE_STATUS_ID")
    private RoleStatus roleStatus;
    @Column(name="EXPIRATION_DATE")
    private Date expirationDate;

    public AccountRole() {
    }

    public AccountRole(Account account, RoleType roleType, RoleStatus roleStatus) {
        this.account = account;
        this.roleType = roleType;
        this.roleStatus = roleStatus;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public RoleType getRoleType() {
        return this.roleType;
    }

    public void setRoleType(RoleType roleType) {
        this.roleType = roleType;
    }

    public RoleStatus getRoleStatus() {
        return this.roleStatus;
    }

    public void setRoleStatus(RoleStatus roleStatus) {
        this.roleStatus = roleStatus;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getExpirationString() {
        if (this.expirationDate == null) {
            return "-";
        }
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        return df.format(this.expirationDate);
    }

    public boolean isExpired() {
        Date now = new Date();
        if (this.expirationDate != null) {
            return now.after(this.expirationDate);
        }
        return false;
    }
}

