/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.account.model.hibernate;

import gov.nih.tbi.account.model.PermissionAuthority;
import gov.nih.tbi.account.model.hibernate.Account;
import gov.nih.tbi.account.model.hibernate.PermissionGroup;
import gov.nih.tbi.commons.model.AbstractBricsObject;
import gov.nih.tbi.commons.model.EntityType;
import gov.nih.tbi.commons.model.PermissionType;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="ENTITY_MAP")
public class EntityMap
extends AbstractBricsObject
implements Serializable {
    private static final long serialVersionUID = -7455669599946145751L;
    public static final String ACCOUNT = "account";
    public static final String PERMISSION_GROUP = "permissionGroup";
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ENTITY_MAP_SEQ")
    @SequenceGenerator(name="ENTITY_MAP_SEQ", sequenceName="ENTITY_MAP_SEQ", allocationSize=1)
    private Long id;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="TYPE_ID")
    private EntityType type;
    @Column(name="ENTITY_ID")
    private Long entityId;
    @ManyToOne
    @JoinColumn(name="ACCOUNT_ID")
    private Account account;
    @ManyToOne
    @JoinColumn(name="PERMISSION_GROUP_ID")
    private PermissionGroup permissionGroup;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="PERMISSION_TYPE_ID")
    private PermissionType permission;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EntityType getType() {
        return this.type;
    }

    public void setType(EntityType type) {
        this.type = type;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public PermissionGroup getPermissionGroup() {
        return this.permissionGroup;
    }

    public void setPermissionGroup(PermissionGroup permissionGroup) {
        this.permissionGroup = permissionGroup;
    }

    public PermissionType getPermission() {
        return this.permission;
    }

    public void setPermission(PermissionType permission) {
        this.permission = permission;
    }

    public PermissionAuthority getAuthority() {
        if (this.account != null) {
            return this.account;
        }
        if (this.permissionGroup != null) {
            return this.permissionGroup;
        }
        return null;
    }

    public String toString() {
        return "EntityMap [entityId=" + this.entityId + ", id=" + this.id + ", permission=" + (Object)((Object)this.permission) + ", typeId=" + (Object)((Object)this.type) + ", accountId=" + this.account + "]";
    }
}

