/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.dictionary.model.hibernate;

import gov.nih.tbi.commons.model.RepeatableType;
import gov.nih.tbi.dictionary.model.AbstractDataStructure;
import gov.nih.tbi.dictionary.model.hibernate.BasicDataStructure;
import gov.nih.tbi.dictionary.model.hibernate.MapElement;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="REPEATABLE_GROUP")
@XmlType(namespace="http://tbi.nih.gov/DictionarySchema")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RepeatableGroup
implements Serializable {
    private static final long serialVersionUID = -8456773662819736917L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="REPEATABLE_GROUP_SEQ")
    @SequenceGenerator(name="REPEATABLE_GROUP_SEQ", sequenceName="REPEATABLE_GROUP_SEQ", allocationSize=1)
    private Long id;
    @Column(name="NAME")
    private String name;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="TYPE_ID")
    private RepeatableType type;
    @Column(name="THRESHOLD")
    private Integer threshold;
    @XmlTransient
    @ManyToOne(targetEntity=BasicDataStructure.class)
    @JoinColumn(name="DATA_STRUCTURE_ID")
    private AbstractDataStructure dataStructure;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="repeatableGroup", targetEntity=MapElement.class, orphanRemoval=true)
    @OrderBy(value="position")
    private Set<MapElement> mapElements;

    public RepeatableGroup(RepeatableGroup oldRepeatableGroup) {
        this.name = oldRepeatableGroup.getName();
        this.type = oldRepeatableGroup.getType();
        this.threshold = oldRepeatableGroup.getThreshold();
        this.dataStructure = oldRepeatableGroup.getDataStructure();
        this.mapElements = oldRepeatableGroup.getMapElements();
    }

    public RepeatableGroup() {
        this.mapElements = new LinkedHashSet<MapElement>();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RepeatableType getType() {
        return this.type;
    }

    public void setType(RepeatableType type) {
        this.type = type;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Integer threshold) {
        this.threshold = threshold;
    }

    public AbstractDataStructure getDataStructure() {
        return this.dataStructure;
    }

    public void setDataStructure(AbstractDataStructure dataStructure) {
        this.dataStructure = dataStructure;
    }

    public Set<MapElement> getDataElements() {
        if (this.mapElements == null) {
            this.mapElements = new LinkedHashSet<MapElement>();
        }
        return this.mapElements;
    }

    public Set<MapElement> getMapElements() {
        if (this.mapElements == null) {
            this.mapElements = new LinkedHashSet<MapElement>();
        }
        return this.mapElements;
    }

    public String toString() {
        String mapElementIds = "";
        for (MapElement me : this.getMapElements()) {
            mapElementIds = mapElementIds + me.getId();
        }
        return "RepeatableGroup [id=" + this.getId() + ", name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", threshold=" + this.getThreshold() + ", dataStructure=" + this.getDataStructure() + ", mapElements=" + mapElementIds + "]";
    }

    public void setMapElements(Set<MapElement> mapElementList) {
        if (this.mapElements == null) {
            this.mapElements = new HashSet<MapElement>();
        }
        this.mapElements.clear();
        if (mapElementList != null) {
            this.mapElements.addAll(mapElementList);
        }
    }

    public Integer getSize() {
        return this.mapElements.size();
    }
}

