/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.repository.model.hibernate;

import gov.nih.tbi.commons.model.DatasetStatus;
import gov.nih.tbi.commons.model.hibernate.User;
import gov.nih.tbi.repository.model.AbstractDataset;
import gov.nih.tbi.repository.model.hibernate.BasicStudy;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="DATASET")
public class BasicDataset
extends AbstractDataset
implements Serializable {
    private static final long serialVersionUID = -2627365259205294466L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DATASET_SEQ")
    @SequenceGenerator(name="DATASET_SEQ", sequenceName="DATASET_SEQ", allocationSize=1)
    private Long id;
    @Column(name="NAME")
    private String name;
    @ManyToOne
    @JoinColumn(name="SUBMITTER_ID")
    private User submitter;
    @Column(name="SUBMIT_DATE")
    private Date submitDate;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="DATASET_STATUS_ID")
    private DatasetStatus datasetStatus;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="DATASET_REQUEST_STATUS_ID")
    private DatasetStatus datasetRequestStatus;
    @Column(name="DATASET_ID")
    private String datasetId;
    @ManyToOne
    @JoinColumn(name="STUDY_ID")
    private BasicStudy study;
    @ManyToOne
    @JoinColumn(name="REVIEWER_ID")
    private User reviewer;
    @ManyToOne
    @JoinColumn(name="VERIFIER_ID")
    private User verifier;
    @Column(name="PUBLICATION_DATE")
    private Date publicationDate;

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public User getSubmitter() {
        return this.submitter;
    }

    public Date getSubmitDate() {
        return this.submitDate;
    }

    public DatasetStatus getDatasetStatus() {
        return this.datasetStatus;
    }

    public BasicStudy getStudy() {
        return this.study;
    }

    public User getReviewer() {
        return this.reviewer;
    }

    public User getVerifier() {
        return this.verifier;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSubmitter(User submitter) {
        this.submitter = submitter;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }

    public void setDatasetStatus(DatasetStatus datasetStatus) {
        this.datasetStatus = datasetStatus;
    }

    public void setStudy(BasicStudy study) {
        this.study = study;
    }

    public void setReviewer(User reviewer) {
        this.reviewer = reviewer;
    }

    public void setVerifier(User verifier) {
        this.verifier = verifier;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public String getReadableDatasetId() {
        return "FITBIRDATA" + this.datasetId;
    }

    public Date getPublicationDate() {
        return this.publicationDate;
    }

    public void setPublicationDate(Date publicationDate) {
        this.publicationDate = publicationDate;
    }

    public DatasetStatus getDatasetRequestStatus() {
        return this.datasetRequestStatus;
    }

    public void setDatasetRequestStatus(DatasetStatus datasetRequestStatus) {
        this.datasetRequestStatus = datasetRequestStatus;
    }
}

