/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.tbi.repository.model.hibernate;

import gov.nih.tbi.commons.model.RecruitmentStatus;
import gov.nih.tbi.commons.model.StudyStatus;
import gov.nih.tbi.repository.model.AbstractStudy;
import gov.nih.tbi.repository.model.hibernate.ClinicalTrial;
import gov.nih.tbi.repository.model.hibernate.Dataset;
import gov.nih.tbi.repository.model.hibernate.Grant;
import gov.nih.tbi.repository.model.hibernate.SupportingDocumentation;
import gov.nih.tbi.repository.model.hibernate.UserFile;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="STUDY")
public class Study
extends AbstractStudy
implements Serializable {
    private static final long serialVersionUID = -3963107794602437604L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STUDY_SEQ")
    @SequenceGenerator(name="STUDY_SEQ", sequenceName="STUDY_SEQ", allocationSize=1)
    private Long id;
    @Column(name="TITLE")
    private String title;
    @Column(name="STUDY_ID")
    private String studyId;
    @Column(name="ABSTRACT")
    private String abstractText;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="RECRUITMENT_STATUS_ID")
    private RecruitmentStatus recruitmentStatus;
    @Column(name="PRINCIPAL_INVESTIGATOR")
    private String principalInvestigator;
    @Column(name="PRINCIPAL_INVESTIGATOR_EMAIL")
    private String principalInvestigatorEmail;
    @Column(name="DATA_MANAGER")
    private String dataManager;
    @Column(name="DATA_MANAGER_EMAIL")
    private String dataManagerEmail;
    @XmlTransient
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="study", targetEntity=ClinicalTrial.class, orphanRemoval=true)
    private Set<ClinicalTrial> clinicalTrialSet = new HashSet<ClinicalTrial>();
    @XmlTransient
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="study", targetEntity=Grant.class, orphanRemoval=true)
    private Set<Grant> grantSet = new HashSet<Grant>();
    @XmlTransient
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="study", targetEntity=SupportingDocumentation.class, orphanRemoval=true)
    private Set<SupportingDocumentation> supportingDocumentationSet = new HashSet<SupportingDocumentation>();
    @XmlTransient
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="study", targetEntity=Dataset.class, orphanRemoval=true)
    private Set<Dataset> datasetSet = new HashSet<Dataset>();
    @Column(name="DATE_CREATED")
    private Date dateCreated;
    @OneToOne
    @JoinColumn(name="DATA_SUBMISSION_DOCUMENT_ID")
    private UserFile dataSubmissionDocument;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="STUDY_STATUS_ID")
    private StudyStatus studyStatus;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getStudyId() {
        return this.studyId;
    }

    public String getReadableStudyId() {
        return "FITBIRSDY" + this.studyId;
    }

    @Override
    public String getAbstractText() {
        return this.abstractText;
    }

    @Override
    public RecruitmentStatus getRecruitmentStatus() {
        return this.recruitmentStatus;
    }

    @Override
    public String getPrincipalInvestigator() {
        return this.principalInvestigator;
    }

    @Override
    public String getDataManager() {
        return this.dataManager;
    }

    public Set<ClinicalTrial> getClinicalTrialSet() {
        return this.clinicalTrialSet;
    }

    public Set<Grant> getGrantSet() {
        return this.grantSet;
    }

    public Set<SupportingDocumentation> getSupportingDocumentationSet() {
        return this.supportingDocumentationSet;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setStudyId(String studyId) {
        this.studyId = studyId;
    }

    @Override
    public void setAbstractText(String abstractText) {
        this.abstractText = abstractText;
    }

    @Override
    public void setRecruitmentStatus(RecruitmentStatus recruitmentStatus) {
        this.recruitmentStatus = recruitmentStatus;
    }

    @Override
    public void setPrincipalInvestigator(String principalInvestigator) {
        this.principalInvestigator = principalInvestigator;
    }

    @Override
    public void setDataManager(String dataManager) {
        this.dataManager = dataManager;
    }

    public void setClinicalTrialSet(Set<ClinicalTrial> clinicalTrialSet) {
        if (this.clinicalTrialSet == null) {
            this.clinicalTrialSet = new HashSet<ClinicalTrial>();
        }
        this.clinicalTrialSet.clear();
        if (clinicalTrialSet != null) {
            this.clinicalTrialSet.addAll(clinicalTrialSet);
        }
    }

    @Override
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Override
    public String getPrincipalInvestigatorEmail() {
        return this.principalInvestigatorEmail;
    }

    @Override
    public String getDataManagerEmail() {
        return this.dataManagerEmail;
    }

    @Override
    public void setPrincipalInvestigatorEmail(String principalInvestigatorEmail) {
        this.principalInvestigatorEmail = principalInvestigatorEmail;
    }

    @Override
    public void setDataManagerEmail(String dataManagerEmail) {
        this.dataManagerEmail = dataManagerEmail;
    }

    public UserFile getDataSubmissionDocument() {
        return this.dataSubmissionDocument;
    }

    public void setDataSubmissionDocument(UserFile dataSubmissionDocument) {
        this.dataSubmissionDocument = dataSubmissionDocument;
    }

    @Override
    public StudyStatus getStudyStatus() {
        return this.studyStatus;
    }

    @Override
    public void setStudyStatus(StudyStatus studyStatus) {
        this.studyStatus = studyStatus;
    }

    public boolean getIsPrivate() {
        return StudyStatus.PRIVATE.equals((Object)this.studyStatus);
    }

    public boolean getIsPublic() {
        return StudyStatus.PUBLIC.equals((Object)this.studyStatus);
    }

    public Set<Dataset> getDatasetSet() {
        return this.datasetSet;
    }

    public void setDatasetSet(Set<Dataset> datasetSet) {
        if (this.datasetSet == null) {
            this.datasetSet = new HashSet<Dataset>();
        }
        this.datasetSet.clear();
        if (datasetSet != null) {
            this.datasetSet.addAll(datasetSet);
        }
    }
}

