/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ndar.model.transfer.dictionary;

import gov.nih.ndar.model.abstraction.dictionary.IDataElement;
import gov.nih.ndar.model.abstraction.dictionary.IDataStructure;
import gov.nih.ndar.model.transfer.dictionary.XmlDataElement;
import gov.nih.ndar.model.transfer.dictionary.XmlDataType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class XmlDataStructure
implements IDataStructure {
    @XmlElement(required=true)
    protected Long id;
    @XmlElement(required=true)
    protected String title;
    @XmlElement(required=true)
    protected String description;
    @XmlElement(required=true, type=XmlDataType.class)
    protected XmlDataType dataType;
    @XmlElement(required=true)
    protected String createdBy;
    @XmlElement(required=true)
    protected String modifiedBy;
    @XmlElement(required=true)
    protected String status;
    @XmlElement(required=true)
    protected Integer publicStatus;
    @XmlElement(required=true)
    @XmlID
    protected String shortName;
    @XmlElement(type=XmlDataStructure.class)
    protected IDataStructure parentDataStructure;
    @XmlElement(type=XmlDataElement.class)
    protected List<IDataElement> dataElements;

    public XmlDataStructure() {
    }

    public XmlDataStructure(String shortName) {
        this.shortName = shortName;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long value) {
        this.id = value;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String value) {
        this.title = value;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String value) {
        this.description = value;
    }

    public XmlDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(XmlDataType value) {
        this.dataType = value;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String value) {
        this.createdBy = value;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String value) {
        this.modifiedBy = value;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String value) {
        this.status = value;
    }

    @Override
    public Integer getPublicStatus() {
        return this.publicStatus;
    }

    @Override
    public void setPublicStatus(Integer publicStatus) {
        this.publicStatus = publicStatus;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public void setShortName(String value) {
        this.shortName = value;
    }

    @Override
    public IDataStructure getParentDataStructure() {
        return this.parentDataStructure;
    }

    public void setParentDataStructure(XmlDataStructure value) {
        this.parentDataStructure = value;
    }

    public List<IDataElement> getDataElements() {
        if (this.dataElements == null) {
            this.dataElements = new ArrayList<IDataElement>();
        }
        return this.dataElements;
    }

    @Override
    public IDataElement getDataElementByName(String value) throws Exception {
        for (IDataElement de : this.dataElements) {
            if (!de.getName().equals(value)) continue;
            return de;
        }
        throw new Exception("No DataElement with the name '" + value + "' exists in this DataStructure");
    }

    public String toString() {
        return "DataStructure [shortName=" + this.shortName + ", createdBy=" + this.createdBy + ", dataElement=" + this.dataElements + ", dataType=" + (Object)((Object)this.dataType) + ", description=" + this.description + ", id=" + this.id + ", modifiedBy=" + this.modifiedBy + ", parentDataStructure=" + this.parentDataStructure + ", status=" + this.status + ", title=" + this.title + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.shortName == null ? 0 : this.shortName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XmlDataStructure other = (XmlDataStructure)obj;
        return !(this.shortName == null ? other.shortName != null : !this.shortName.equals(other.shortName));
    }

    @Override
    public Date getCreatedDate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDispDataType() {
        return this.dataType.value().substring(0, 1);
    }

    @Override
    public String getDispShortName() {
        return this.shortName.substring(0, this.shortName.length() - 2);
    }

    @Override
    public String getDispVersion() {
        return this.shortName.substring(this.shortName.length() - 2);
    }

    @Override
    public Date getModifiedDate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParentDataStructure(IDataStructure value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDataTypeString() {
        return this.dataType.value();
    }

    @Override
    public void setDataTypeString(String value) {
        this.dataType = XmlDataType.fromValue(value);
    }

    @Override
    public String getCreatedByString() {
        return this.createdBy;
    }

    @Override
    public String getModifiedByString() {
        return this.modifiedBy;
    }

    @Override
    public void setCreatedByString(String value) {
        this.createdBy = value;
    }

    @Override
    public void setModifiedByString(String value) {
        this.modifiedBy = value;
    }
}

