/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibApplications.OpenGLApplication;

import WildMagic.LibApplications.OpenGLApplication.Application;
import WildMagic.LibGraphics.Shaders.Program;
import WildMagic.LibGraphics.Shaders.UserConstant;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ApplicationGUI
implements ActionListener,
Serializable {
    private static final long serialVersionUID = -8008786182230979141L;
    private Hashtable<String, Vector<UserConstant>> m_kShaderMap = new Hashtable();
    private boolean ms_bInit = false;
    private Application m_kParent = null;
    private JFrame m_kFrame = null;

    @Override
    public void actionPerformed(ActionEvent kEvent) {
        String kCommand = kEvent.getActionCommand();
        if (kCommand.equals("reload")) {
            if (this.m_kParent != null) {
                this.m_kShaderMap.clear();
                this.m_kParent.reloadShaders();
                this.ms_bInit = false;
                this.m_kFrame.setVisible(false);
                this.m_kFrame.dispose();
            }
        } else {
            Enumeration<Vector<UserConstant>> kE = this.m_kShaderMap.elements();
            while (kE.hasMoreElements()) {
                Vector<UserConstant> kUserVariables = kE.nextElement();
                for (int i = 0; i < kUserVariables.size(); ++i) {
                    UserConstant kUser = kUserVariables.get(i);
                    for (int j = 0; j < kUser.GetDataSize(); ++j) {
                        JTextField kTextField;
                        String kName = new String(kUser.GetName() + j);
                        if (!kCommand.equals(kName) || (kTextField = (JTextField)kEvent.getSource()).getText().length() <= 0) continue;
                        float fValue = Float.parseFloat(kTextField.getText());
                        kUser.SetData(j, fValue);
                    }
                }
            }
        }
    }

    public void AddUserVariables(Program kProgram) {
        for (int i = 0; i < kProgram.GetUCQuantity(); ++i) {
            this.AddUserVariable(kProgram.GetName(), kProgram.GetUC(i));
        }
    }

    public void close() {
        if (this.m_kFrame != null) {
            this.m_kFrame.setVisible(false);
        }
        if (this.m_kShaderMap != null) {
            this.m_kShaderMap.clear();
        }
        this.m_kParent = null;
        this.m_kFrame = null;
        this.ms_bInit = false;
    }

    public void Display() {
        if (this.ms_bInit) {
            if (this.m_kFrame != null) {
                this.m_kFrame.setVisible(true);
            }
            return;
        }
        this.m_kFrame = new JFrame("Shader Parameters");
        JPanel kMainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints kMainGBC = new GridBagConstraints();
        kMainGBC.anchor = 17;
        kMainGBC.gridx = 0;
        kMainGBC.gridy = 0;
        Enumeration<String> kE = this.m_kShaderMap.keys();
        while (kE.hasMoreElements()) {
            String kKey = kE.nextElement();
            Vector<UserConstant> kUserVariables = this.m_kShaderMap.get(kKey);
            JPanel kPanel = new JPanel(new GridBagLayout());
            kPanel.setBorder(new TitledBorder(kKey + " Shader Parameters"));
            Dimension minimumSize = new Dimension(400, 400);
            kPanel.setMinimumSize(minimumSize);
            GridBagConstraints kGBC = new GridBagConstraints();
            kGBC.anchor = 17;
            kGBC.gridx = 0;
            kGBC.gridy = 0;
            for (int i = 0; i < kUserVariables.size(); ++i) {
                kGBC.gridx = 0;
                String kName = kUserVariables.get(i).GetName();
                kPanel.add((Component)new JLabel(kName), kGBC);
                ++kGBC.gridx;
                for (int j = 0; j < kUserVariables.get(i).GetDataSize(); ++j) {
                    JTextField kTextField = new JTextField(String.valueOf(kUserVariables.get(i).GetData(j)), 5);
                    kTextField.setEditable(true);
                    kTextField.setAlignmentX(0.0f);
                    kTextField.addActionListener(this);
                    kTextField.setActionCommand(new String(kName + j));
                    kTextField.setEnabled(true);
                    kPanel.add((Component)kTextField, kGBC);
                    ++kGBC.gridx;
                }
                ++kGBC.gridy;
            }
            kMainPanel.add((Component)kPanel, kMainGBC);
            ++kMainGBC.gridy;
        }
        JButton kReloadShaderButton = new JButton("Reload Shader Program");
        kReloadShaderButton.addActionListener(this);
        kReloadShaderButton.setActionCommand("reload");
        kMainGBC.gridx = 0;
        ++kMainGBC.gridy;
        kMainPanel.add((Component)kReloadShaderButton, kMainGBC);
        this.m_kFrame.add(kMainPanel);
        this.m_kFrame.pack();
        this.m_kFrame.setVisible(true);
        this.ms_bInit = true;
    }

    public void dispose() {
        this.close();
        this.m_kShaderMap = null;
    }

    public void setParent(Application kParent) {
        this.m_kParent = kParent;
    }

    private void AddUserVariable(String kShaderName, UserConstant kVar) {
        Vector<UserConstant> kUserVariables = this.m_kShaderMap.get(kShaderName);
        if (kUserVariables == null) {
            kUserVariables = new Vector();
            kUserVariables.add(kVar);
            this.m_kShaderMap.put(kShaderName, kUserVariables);
        } else {
            kUserVariables.add(kVar);
        }
    }
}

