/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibApplications.OpenGLApplication;

import WildMagic.LibApplications.OpenGLApplication.JavaApplication;
import WildMagic.LibFoundation.Mathematics.ColorRGB;
import WildMagic.LibFoundation.Mathematics.ColorRGBA;
import java.io.Serializable;

public abstract class JavaApplication2D
extends JavaApplication
implements Serializable {
    private static final long serialVersionUID = 570122699783203487L;
    protected int m_iScrWidth = 0;
    protected int m_iScrHeight = 0;
    protected byte[] m_akScreen = null;
    protected boolean m_bClampToWindow = true;
    protected boolean m_bFlipScreen = false;
    protected byte[] m_akFlipScreen = null;

    public JavaApplication2D(String acWindowTitle, int iXPosition, int iYPosition, int iWidth, int iHeight, ColorRGBA rkBackgroundColor) {
        super(acWindowTitle, iXPosition, iYPosition, iWidth - iWidth % 4, iHeight, rkBackgroundColor);
    }

    public boolean ClampToWindow() {
        return this.m_bClampToWindow;
    }

    public void ClearScreen() {
        for (int i = 0; i < this.m_iWidth * this.m_iHeight; ++i) {
            this.m_akScreen[i * 3 + 0] = (byte)(255.0f * this.m_kBackgroundColor.R);
            this.m_akScreen[i * 3 + 1] = (byte)(255.0f * this.m_kBackgroundColor.G);
            this.m_akScreen[i * 3 + 2] = (byte)(255.0f * this.m_kBackgroundColor.B);
            this.m_akFlipScreen[i * 3 + 0] = (byte)(255.0f * this.m_kBackgroundColor.R);
            this.m_akFlipScreen[i * 3 + 1] = (byte)(255.0f * this.m_kBackgroundColor.G);
            this.m_akFlipScreen[i * 3 + 2] = (byte)(255.0f * this.m_kBackgroundColor.B);
        }
    }

    @Override
    public void dispose() {
        this.m_akScreen = null;
        this.m_akFlipScreen = null;
        super.dispose();
    }

    public void DoFlip(boolean bDoFlip) {
        this.m_bFlipScreen = bDoFlip;
    }

    public void DrawCircle(int iXCenter, int iYCenter, int iRadius, ColorRGB kColor, boolean bSolid) {
        if (bSolid) {
            int iY = iRadius;
            int iDec = 3 - 2 * iRadius;
            for (int iX = 0; iX <= iY; ++iX) {
                int i;
                int iXValue = iXCenter + iX;
                int iYMin = iYCenter - iY;
                int iYMax = iYCenter + iY;
                for (i = iYMin; i <= iYMax; ++i) {
                    this.SetPixel(iXValue, i, kColor);
                }
                iXValue = iXCenter - iX;
                for (i = iYMin; i <= iYMax; ++i) {
                    this.SetPixel(iXValue, i, kColor);
                }
                iXValue = iXCenter + iY;
                iYMin = iYCenter - iX;
                iYMax = iYCenter + iX;
                for (i = iYMin; i <= iYMax; ++i) {
                    this.SetPixel(iXValue, i, kColor);
                }
                iXValue = iXCenter - iY;
                for (i = iYMin; i <= iYMax; ++i) {
                    this.SetPixel(iXValue, i, kColor);
                }
                if (iDec >= 0) {
                    iDec += -4 * iY-- + 4;
                }
                iDec += 4 * iX + 6;
            }
        } else {
            int iY = iRadius;
            int iDec = 3 - 2 * iRadius;
            for (int iX = 0; iX <= iY; ++iX) {
                this.SetPixel(iXCenter + iX, iYCenter + iY, kColor);
                this.SetPixel(iXCenter + iX, iYCenter - iY, kColor);
                this.SetPixel(iXCenter - iX, iYCenter + iY, kColor);
                this.SetPixel(iXCenter - iX, iYCenter - iY, kColor);
                this.SetPixel(iXCenter + iY, iYCenter + iX, kColor);
                this.SetPixel(iXCenter + iY, iYCenter - iX, kColor);
                this.SetPixel(iXCenter - iY, iYCenter + iX, kColor);
                this.SetPixel(iXCenter - iY, iYCenter - iX, kColor);
                if (iDec >= 0) {
                    iDec += -4 * iY-- + 4;
                }
                iDec += 4 * iX + 6;
            }
        }
    }

    public void DrawLine(int iX0, int iY0, int iX1, int iY1, ColorRGB kColor) {
        int iSy;
        int iSx;
        int iX = iX0;
        int iY = iY0;
        int iDx = iX1 - iX0;
        int iDy = iY1 - iY0;
        int n = iDx > 0 ? 1 : (iSx = iDx < 0 ? -1 : 0);
        int n2 = iDy > 0 ? 1 : (iSy = iDy < 0 ? -1 : 0);
        if (iDx < 0) {
            iDx = -iDx;
        }
        if (iDy < 0) {
            iDy = -iDy;
        }
        int iAx = 2 * iDx;
        int iAy = 2 * iDy;
        int iMax = iDx;
        int iVar = 0;
        if (iDy > iMax) {
            iVar = 1;
        }
        block0 : switch (iVar) {
            case 0: {
                int iDecY = iAy - iDx;
                while (true) {
                    this.SetPixel(iX, iY, kColor);
                    if (iX == iX1) break block0;
                    if (iDecY >= 0) {
                        iDecY -= iAx;
                        iY += iSy;
                    }
                    iX += iSx;
                    iDecY += iAy;
                }
            }
            case 1: {
                int iDecX = iAx - iDy;
                while (true) {
                    this.SetPixel(iX, iY, kColor);
                    if (iY == iY1) break block0;
                    if (iDecX >= 0) {
                        iDecX -= iAy;
                        iX += iSx;
                    }
                    iY += iSy;
                    iDecX += iAx;
                }
            }
        }
    }

    public void DrawRectangle(int iXMin, int iYMin, int iXMax, int iYMax, ColorRGB kColor, boolean bSolid) {
        if (iXMin >= this.m_iWidth || iXMax < 0 || iYMin >= this.m_iHeight || iYMax < 0) {
            return;
        }
        if (bSolid) {
            for (int iY = iYMin; iY <= iYMax; ++iY) {
                for (int iX = iXMin; iX <= iXMax; ++iX) {
                    this.SetPixel(iX, iY, kColor);
                }
            }
        } else {
            for (int iX = iXMin; iX <= iXMax; ++iX) {
                this.SetPixel(iX, iYMin, kColor);
                this.SetPixel(iX, iYMax, kColor);
            }
            for (int iY = iYMin + 1; iY <= iYMax - 1; ++iY) {
                this.SetPixel(iXMin, iY, kColor);
                this.SetPixel(iXMax, iY, kColor);
            }
        }
    }

    public void Fill(int iX, int iY, ColorRGB kFColor, ColorRGB kBColor) {
        int iXMax = this.m_iWidth;
        int iYMax = this.m_iHeight;
        int iQuantity = iXMax * iYMax;
        int[] aiXStack = new int[iQuantity];
        int[] aiYStack = new int[iQuantity];
        int iTop = 0;
        aiXStack[iTop] = iX;
        aiYStack[iTop] = iY;
        while (iTop >= 0) {
            iX = aiXStack[iTop];
            iY = aiYStack[iTop];
            this.SetPixel(iX, iY, kFColor);
            int iXp1 = iX + 1;
            if (iXp1 < iXMax && this.GetPixel(iXp1, iY) == kBColor) {
                aiXStack[++iTop] = iXp1;
                aiYStack[iTop] = iY;
                continue;
            }
            int iXm1 = iX - 1;
            if (0 <= iXm1 && this.GetPixel(iXm1, iY) == kBColor) {
                aiXStack[++iTop] = iXm1;
                aiYStack[iTop] = iY;
                continue;
            }
            int iYp1 = iY + 1;
            if (iYp1 < iYMax && this.GetPixel(iX, iYp1) == kBColor) {
                aiXStack[++iTop] = iX;
                aiYStack[iTop] = iYp1;
                continue;
            }
            int iYm1 = iY - 1;
            if (0 <= iYm1 && this.GetPixel(iX, iYm1) == kBColor) {
                aiXStack[++iTop] = iX;
                aiYStack[iTop] = iYm1;
                continue;
            }
            --iTop;
        }
        aiXStack = null;
        aiYStack = null;
    }

    public ColorRGB GetPixel(int iX, int iY) {
        if (this.m_bClampToWindow) {
            if (0 <= iX && iX < this.m_iWidth && 0 <= iY && iY < this.m_iHeight) {
                int iIndex = this.Index(iX, iY);
                return new ColorRGB((float)this.m_akScreen[iIndex * 3 + 0] / 255.0f, (float)this.m_akScreen[iIndex * 3 + 1] / 255.0f, (float)this.m_akScreen[iIndex * 3 + 2] / 255.0f);
            }
            return new ColorRGB();
        }
        int iIndex = this.Index(iX, iY);
        return new ColorRGB((float)this.m_akScreen[iIndex * 3 + 0] / 255.0f, (float)this.m_akScreen[iIndex * 3 + 1] / 255.0f, (float)this.m_akScreen[iIndex * 3 + 2] / 255.0f);
    }

    @Override
    public void OnDisplay() {
        this.m_pkRenderer.ClearBuffers();
        if (this.m_pkRenderer.BeginScene()) {
            if (this.m_akFlipScreen == null) {
                this.m_pkRenderer.Draw(this.m_akScreen);
            } else {
                this.m_pkRenderer.Draw(this.m_akFlipScreen);
            }
            this.ScreenOverlay();
            this.m_pkRenderer.EndScene();
        }
        this.m_pkRenderer.DisplayBackBuffer();
    }

    @Override
    public boolean OnInitialize() {
        if (!super.OnInitialize()) {
            return false;
        }
        this.m_iScrWidth = this.GetWidth();
        this.m_iScrHeight = this.GetHeight();
        this.m_akScreen = new byte[this.m_iScrWidth * this.m_iScrHeight * 3];
        this.m_akFlipScreen = new byte[this.m_iScrWidth * this.m_iScrHeight * 3];
        this.ClearScreen();
        return true;
    }

    @Override
    public void OnResize(int iWidth, int iHeight) {
        iWidth -= iWidth % 4;
        super.OnResize(iWidth, iHeight);
        if (iWidth * iHeight <= 0) {
            return;
        }
        if (iWidth != this.m_iScrWidth || iHeight != this.m_iScrHeight) {
            this.m_akScreen = null;
            this.m_iScrWidth = iWidth;
            this.m_iScrHeight = iHeight;
            this.m_akScreen = new byte[this.m_iScrWidth * this.m_iScrHeight * 3];
            this.m_akFlipScreen = null;
            this.m_akFlipScreen = new byte[this.m_iScrWidth * this.m_iScrHeight * 3];
            this.ClearScreen();
        }
    }

    @Override
    public void OnTerminate() {
        this.m_akScreen = null;
        this.m_akFlipScreen = null;
        super.OnTerminate();
    }

    public void ScreenOverlay() {
    }

    public void SetPixel(int iX, int iY, ColorRGB kColor) {
        if (this.m_bClampToWindow) {
            if (0 <= iX && iX < this.m_iWidth && 0 <= iY && iY < this.m_iHeight) {
                int iIndex = this.Index(iX, iY);
                this.m_akScreen[iIndex * 3 + 0] = (byte)(255.0f * kColor.R);
                this.m_akScreen[iIndex * 3 + 1] = (byte)(255.0f * kColor.G);
                this.m_akScreen[iIndex * 3 + 2] = (byte)(255.0f * kColor.B);
                int iIndexFlip = this.IndexFlip(iX, iY);
                this.m_akFlipScreen[iIndexFlip * 3 + 0] = (byte)(255.0f * kColor.R);
                this.m_akFlipScreen[iIndexFlip * 3 + 1] = (byte)(255.0f * kColor.G);
                this.m_akFlipScreen[iIndexFlip * 3 + 2] = (byte)(255.0f * kColor.B);
            }
        } else {
            int iIndex = this.Index(iX, iY);
            this.m_akScreen[iIndex * 3 + 0] = (byte)(255.0f * kColor.R);
            this.m_akScreen[iIndex * 3 + 1] = (byte)(255.0f * kColor.G);
            this.m_akScreen[iIndex * 3 + 2] = (byte)(255.0f * kColor.B);
            int iIndexFlip = this.IndexFlip(iX, iY);
            this.m_akFlipScreen[iIndexFlip * 3 + 0] = (byte)(255.0f * kColor.R);
            this.m_akFlipScreen[iIndexFlip * 3 + 1] = (byte)(255.0f * kColor.G);
            this.m_akFlipScreen[iIndexFlip * 3 + 2] = (byte)(255.0f * kColor.B);
        }
    }

    public void SetThickPixel(int iX, int iY, int iThick, ColorRGB kColor) {
        for (int iDY = -iThick; iDY <= iThick; ++iDY) {
            for (int iDX = -iThick; iDX <= iThick; ++iDX) {
                this.SetPixel(iX + iDX, iY + iDY, kColor);
            }
        }
    }

    protected int Index(int iX, int iY) {
        return iX + this.m_iWidth * iY;
    }

    protected int IndexFlip(int iX, int iY) {
        return iY + this.m_iHeight * iX;
    }
}

