/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Approximation;

import WildMagic.LibFoundation.Mathematics.Box3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibFoundation.NumericalAnalysis.Eigenf;
import java.io.Serializable;
import java.util.Vector;

public class ApprGaussPointsFit3f
implements Serializable {
    private static final long serialVersionUID = -35431114992983409L;

    public static Box3f GaussPointsFit3f(int iQuantity, Vector<Vector3f> kMeshVertices) {
        int i;
        Box3f kBox = new Box3f(Vector3f.ZERO, Vector3f.UNIT_X, Vector3f.UNIT_Y, Vector3f.UNIT_Z, 1.0f, 1.0f, 1.0f);
        kBox.Center.Copy(kMeshVertices.get(0));
        for (i = 1; i < iQuantity; ++i) {
            kBox.Center.Add(kMeshVertices.get(i));
        }
        float fInvQuantity = 1.0f / (float)iQuantity;
        kBox.Center.Scale(fInvQuantity);
        float fSumXX = 0.0f;
        float fSumXY = 0.0f;
        float fSumXZ = 0.0f;
        float fSumYY = 0.0f;
        float fSumYZ = 0.0f;
        float fSumZZ = 0.0f;
        for (i = 0; i < iQuantity; ++i) {
            Vector3f kDiff = new Vector3f();
            kDiff.Sub(kMeshVertices.get(i), kBox.Center);
            fSumXX += kDiff.X * kDiff.X;
            fSumXY += kDiff.X * kDiff.Y;
            fSumXZ += kDiff.X * kDiff.Z;
            fSumYY += kDiff.Y * kDiff.Y;
            fSumYZ += kDiff.Y * kDiff.Z;
            fSumZZ += kDiff.Z * kDiff.Z;
        }
        fSumXX *= fInvQuantity;
        fSumXY *= fInvQuantity;
        fSumXZ *= fInvQuantity;
        fSumYY *= fInvQuantity;
        fSumYZ *= fInvQuantity;
        fSumZZ *= fInvQuantity;
        Eigenf kES = new Eigenf(3);
        kES.SetData(0, 0, fSumXX);
        kES.SetData(0, 1, fSumXY);
        kES.SetData(0, 2, fSumXZ);
        kES.SetData(1, 0, fSumXY);
        kES.SetData(1, 1, fSumYY);
        kES.SetData(1, 2, fSumYZ);
        kES.SetData(2, 0, fSumXZ);
        kES.SetData(2, 1, fSumYZ);
        kES.SetData(2, 2, fSumZZ);
        kES.IncrSortEigenStuff();
        for (i = 0; i < 3; ++i) {
            kBox.Extent[i] = kES.GetEigenvalue(i);
            kES.GetEigenvector(i, kBox.Axis[i]);
        }
        return kBox;
    }
}

