/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Curves;

import WildMagic.LibFoundation.Curves.BSplineBasisf;
import java.io.Serializable;

public class BSplineBasisDiscretef
extends BSplineBasisf
implements Serializable {
    private static final long serialVersionUID = 1635300914236394723L;
    protected float[][] m_aafSampleD0;
    protected float[][] m_aafSampleD1;
    protected float[][] m_aafSampleD2;
    protected int[] m_aiControlPointSampleIndexMax;
    protected int[] m_aiControlPointSampleIndexMin;
    protected int m_iNumSamples;

    public BSplineBasisDiscretef(int iNumCtrlPoints, int iDegree, int iNumSamples) {
        super(iNumCtrlPoints, iDegree, true);
        int i;
        if (iNumSamples <= iNumCtrlPoints) {
            throw new IllegalArgumentException("BSplineBasisDiscretef: Number of samples must be more than number of control points.");
        }
        this.m_iNumSamples = iNumSamples;
        this.m_aafSampleD0 = new float[iNumSamples][iNumCtrlPoints];
        this.m_aafSampleD1 = new float[iNumSamples][iNumCtrlPoints];
        this.m_aafSampleD2 = new float[iNumSamples][iNumCtrlPoints];
        this.m_aiControlPointSampleIndexMin = new int[iNumSamples];
        this.m_aiControlPointSampleIndexMax = new int[iNumSamples];
        for (i = 0; i < iNumCtrlPoints; ++i) {
            this.m_aiControlPointSampleIndexMin[i] = iNumSamples - 1;
            this.m_aiControlPointSampleIndexMax[i] = 0;
        }
        for (i = 0; i < iNumSamples; ++i) {
            int iMinU;
            float fU = (float)i / (float)(iNumSamples - 1);
            int iMaxU = this.Compute(fU, this.m_aafSampleD0[i], this.m_aafSampleD1[i], this.m_aafSampleD2[i]);
            for (int iControl = iMinU = iMaxU - this.m_iDegree; iControl <= iMaxU; ++iControl) {
                if (i < this.m_aiControlPointSampleIndexMin[iControl]) {
                    this.m_aiControlPointSampleIndexMin[iControl] = i;
                }
                if (i <= this.m_aiControlPointSampleIndexMax[iControl]) continue;
                this.m_aiControlPointSampleIndexMax[iControl] = i;
            }
        }
    }

    public void finalize() throws Throwable {
        this.m_aafSampleD0 = null;
        this.m_aafSampleD1 = null;
        this.m_aafSampleD2 = null;
        this.m_aiControlPointSampleIndexMin = null;
        this.m_aiControlPointSampleIndexMax = null;
        super.finalize();
    }

    public int GetControlPointSampleIndexMax(int iControl) {
        return this.m_aiControlPointSampleIndexMax[iControl];
    }

    public int GetControlPointSampleIndexMin(int iControl) {
        return this.m_aiControlPointSampleIndexMin[iControl];
    }

    public float GetD0(int iControl, int iSample) {
        return this.m_aafSampleD0[iSample][iControl];
    }

    public float GetD1(int iControl, int iSample) {
        return this.m_aafSampleD1[iSample][iControl];
    }

    public float GetD2(int iControl, int iSample) {
        return this.m_aafSampleD2[iSample][iControl];
    }

    public int GetNumSamples() {
        return this.m_iNumSamples;
    }
}

