/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Curves;

import java.io.Serializable;

public class BSplineBasisf
implements Serializable {
    private static final long serialVersionUID = 7105129273635508030L;
    protected int m_iNumCtrlPoints;
    protected int m_iDegree;
    protected float[] m_afKnot;
    protected int m_iNumKnots;
    protected boolean m_bOpen;
    protected boolean m_bUniform;
    protected float[][] m_aafBD0;
    protected float[][] m_aafBD1;
    protected float[][] m_aafBD2;
    protected float[][] m_aafBD3;

    public BSplineBasisf() {
    }

    public BSplineBasisf(int iNumCtrlPoints, int iDegree) {
        this.Create(iNumCtrlPoints, iDegree, true);
    }

    public BSplineBasisf(int iNumCtrlPoints, int iDegree, boolean bOpen) {
        this.Create(iNumCtrlPoints, iDegree, bOpen);
    }

    public BSplineBasisf(int iNumCtrlPoints, int iDegree, float[] afKnot) {
        this.Create(iNumCtrlPoints, iDegree, afKnot);
    }

    public static int GetMinNumControlPoints(int iDegree) {
        int iMinNumControlPoints = iDegree + 1;
        if (iMinNumControlPoints < 2) {
            iMinNumControlPoints = 2;
        }
        return iMinNumControlPoints;
    }

    public int Compute(float fU, float[] afBD0, float[] afBD1, float[] afBD2) {
        int j;
        int iIndex;
        if (fU <= 0.0f) {
            fU = 0.0f;
        } else if (fU >= 1.0f) {
            fU = 1.0f;
        }
        int i = this.GetKnotIndex(fU);
        float fN0 = fU - this.m_afKnot[i];
        float fN1 = this.m_afKnot[i + 1] - fU;
        int iOrder = 0;
        if (null == afBD0) {
            throw new IllegalArgumentException("BSplineBasisf::compute: afBD0 array is null.");
        }
        for (iIndex = 0; iIndex < afBD0.length; ++iIndex) {
            afBD0[iIndex] = 0.0f;
        }
        this.m_aafBD0[this.m_iDegree] = afBD0;
        this.m_aafBD0[0][i] = 1.0f;
        if (null != afBD1) {
            iOrder = 1;
            for (iIndex = 0; iIndex < afBD1.length; ++iIndex) {
                afBD1[iIndex] = 0.0f;
            }
            this.m_aafBD1[this.m_iDegree] = afBD1;
            this.m_aafBD1[0][i] = 0.0f;
            if (null != afBD2) {
                iOrder = 2;
                for (iIndex = 0; iIndex < afBD2.length; ++iIndex) {
                    afBD2[iIndex] = 0.0f;
                }
                this.m_aafBD2[this.m_iDegree] = afBD2;
            }
        }
        for (j = 1; j <= this.m_iDegree; ++j) {
            float fInvD0 = 1.0f / (this.m_afKnot[i + j] - this.m_afKnot[i]);
            float fInvD1 = 1.0f / (this.m_afKnot[i + 1] - this.m_afKnot[i - j + 1]);
            this.m_aafBD0[j][i] = fN0 * this.m_aafBD0[j - 1][i] * fInvD0;
            this.m_aafBD0[j][i - j] = fN1 * this.m_aafBD0[j - 1][i - j + 1] * fInvD1;
            if (iOrder < 1) continue;
            this.m_aafBD1[j][i] = (fN0 * this.m_aafBD1[j - 1][i] + this.m_aafBD0[j - 1][i]) * fInvD0;
            this.m_aafBD1[j][i - j] = (fN1 * this.m_aafBD1[j - 1][i - j + 1] - this.m_aafBD0[j - 1][i - j + 1]) * fInvD1;
            if (iOrder < 2) continue;
            this.m_aafBD2[j][i] = (fN0 * this.m_aafBD2[j - 1][i] + 2.0f * this.m_aafBD1[j - 1][i]) * fInvD0;
            this.m_aafBD2[j][i - j] = (fN1 * this.m_aafBD2[j - 1][i - j + 1] - 2.0f * this.m_aafBD1[j - 1][i - j + 1]) * fInvD1;
        }
        for (j = 2; j <= this.m_iDegree; ++j) {
            for (int k = i - j + 1; k < i; ++k) {
                fN0 = fU - this.m_afKnot[k];
                fN1 = this.m_afKnot[k + j + 1] - fU;
                float fInvD0 = 1.0f / (this.m_afKnot[k + j] - this.m_afKnot[k]);
                float fInvD1 = 1.0f / (this.m_afKnot[k + j + 1] - this.m_afKnot[k + 1]);
                this.m_aafBD0[j][k] = fN0 * this.m_aafBD0[j - 1][k] * fInvD0 + fN1 * this.m_aafBD0[j - 1][k + 1] * fInvD1;
                if (iOrder < 1) continue;
                this.m_aafBD1[j][k] = (fN0 * this.m_aafBD1[j - 1][k] + this.m_aafBD0[j - 1][k]) * fInvD0 + (fN1 * this.m_aafBD1[j - 1][k + 1] - this.m_aafBD0[j - 1][k + 1]) * fInvD1;
                if (iOrder < 2) continue;
                this.m_aafBD2[j][k] = (fN0 * this.m_aafBD2[j - 1][k] + 2.0f * this.m_aafBD1[j - 1][k]) * fInvD0 + (fN1 * this.m_aafBD2[j - 1][k + 1] - 2.0f * this.m_aafBD1[j - 1][k + 1]) * fInvD1;
            }
        }
        return i;
    }

    public void Compute(float fTime, int uiOrder, int[] riMinIndex, int[] riMaxIndex) {
        float fInvD1;
        float fInvD0;
        int j;
        assert (uiOrder <= 3);
        if (uiOrder >= 1) {
            if (this.m_aafBD1 == null) {
                this.m_aafBD1 = this.Allocate();
            }
            if (uiOrder >= 2) {
                if (this.m_aafBD2 == null) {
                    this.m_aafBD2 = this.Allocate();
                }
                if (uiOrder >= 3 && this.m_aafBD3 == null) {
                    this.m_aafBD3 = this.Allocate();
                }
            }
        }
        float[] time = new float[]{fTime};
        int i = this.GetKey(time);
        fTime = time[0];
        this.m_aafBD0[0][i] = 1.0f;
        if (uiOrder >= 1) {
            this.m_aafBD1[0][i] = 0.0f;
            if (uiOrder >= 2) {
                this.m_aafBD2[0][i] = 0.0f;
                if (uiOrder >= 3) {
                    this.m_aafBD3[0][i] = 0.0f;
                }
            }
        }
        float fN0 = fTime - this.m_afKnot[i];
        float fN1 = this.m_afKnot[i + 1] - fTime;
        for (j = 1; j <= this.m_iDegree; ++j) {
            fInvD0 = 1.0f / (this.m_afKnot[i + j] - this.m_afKnot[i]);
            fInvD1 = 1.0f / (this.m_afKnot[i + 1] - this.m_afKnot[i - j + 1]);
            this.m_aafBD0[j][i] = fN0 * this.m_aafBD0[j - 1][i] * fInvD0;
            this.m_aafBD0[j][i - j] = fN1 * this.m_aafBD0[j - 1][i - j + 1] * fInvD1;
            if (uiOrder < 1) continue;
            this.m_aafBD1[j][i] = (fN0 * this.m_aafBD1[j - 1][i] + this.m_aafBD0[j - 1][i]) * fInvD0;
            this.m_aafBD1[j][i - j] = (fN1 * this.m_aafBD1[j - 1][i - j + 1] - this.m_aafBD0[j - 1][i - j + 1]) * fInvD1;
            if (uiOrder < 2) continue;
            this.m_aafBD2[j][i] = (fN0 * this.m_aafBD2[j - 1][i] + 2.0f * this.m_aafBD1[j - 1][i]) * fInvD0;
            this.m_aafBD2[j][i - j] = (fN1 * this.m_aafBD2[j - 1][i - j + 1] - 2.0f * this.m_aafBD1[j - 1][i - j + 1]) * fInvD1;
            if (uiOrder < 3) continue;
            this.m_aafBD3[j][i] = (fN0 * this.m_aafBD3[j - 1][i] + 3.0f * this.m_aafBD2[j - 1][i]) * fInvD0;
            this.m_aafBD3[j][i - j] = (fN1 * this.m_aafBD3[j - 1][i - j + 1] - 3.0f * this.m_aafBD2[j - 1][i - j + 1]) * fInvD1;
        }
        for (j = 2; j <= this.m_iDegree; ++j) {
            for (int k = i - j + 1; k < i; ++k) {
                fN0 = fTime - this.m_afKnot[k];
                fN1 = this.m_afKnot[k + j + 1] - fTime;
                fInvD0 = 1.0f / (this.m_afKnot[k + j] - this.m_afKnot[k]);
                fInvD1 = 1.0f / (this.m_afKnot[k + j + 1] - this.m_afKnot[k + 1]);
                this.m_aafBD0[j][k] = fN0 * this.m_aafBD0[j - 1][k] * fInvD0 + fN1 * this.m_aafBD0[j - 1][k + 1] * fInvD1;
                if (uiOrder < 1) continue;
                this.m_aafBD1[j][k] = (fN0 * this.m_aafBD1[j - 1][k] + this.m_aafBD0[j - 1][k]) * fInvD0 + (fN1 * this.m_aafBD1[j - 1][k + 1] - this.m_aafBD0[j - 1][k + 1]) * fInvD1;
                if (uiOrder < 2) continue;
                this.m_aafBD2[j][k] = (fN0 * this.m_aafBD2[j - 1][k] + 2.0f * this.m_aafBD1[j - 1][k]) * fInvD0 + (fN1 * this.m_aafBD2[j - 1][k + 1] - 2.0f * this.m_aafBD1[j - 1][k + 1]) * fInvD1;
                if (uiOrder < 3) continue;
                this.m_aafBD3[j][k] = (fN0 * this.m_aafBD3[j - 1][k] + 3.0f * this.m_aafBD2[j - 1][k]) * fInvD0 + (fN1 * this.m_aafBD3[j - 1][k + 1] - 3.0f * this.m_aafBD2[j - 1][k + 1]) * fInvD1;
            }
        }
        riMinIndex[0] = i - this.m_iDegree;
        riMaxIndex[0] = i;
    }

    public void Create(int iNumCtrlPoints, int iDegree, boolean bOpen) {
        this.m_bUniform = true;
        this.m_iNumKnots = this.Initialize(iNumCtrlPoints, iDegree, bOpen);
        float fFactor = 1.0f / (float)(this.m_iNumCtrlPoints - this.m_iDegree);
        if (this.m_bOpen) {
            int i;
            for (i = 0; i <= this.m_iDegree; ++i) {
                this.m_afKnot[i] = 0.0f;
            }
            while (i < this.m_iNumCtrlPoints) {
                this.m_afKnot[i] = (float)(i - this.m_iDegree) * fFactor;
                ++i;
            }
            while (i < this.m_iNumKnots) {
                this.m_afKnot[i] = 1.0f;
                ++i;
            }
        } else {
            for (int i = 0; i < this.m_iNumKnots; ++i) {
                this.m_afKnot[i] = (float)(i - this.m_iDegree) * fFactor;
            }
        }
    }

    public void Create(int iNumCtrlPoints, int iDegree, float[] afKnot) {
        int i;
        this.m_bUniform = false;
        this.m_iNumKnots = this.Initialize(iNumCtrlPoints, iDegree, true);
        for (i = 0; i <= this.m_iDegree; ++i) {
            this.m_afKnot[i] = 0.0f;
        }
        int j = 0;
        while (i < this.m_iNumCtrlPoints) {
            this.m_afKnot[i] = afKnot[j];
            ++i;
            ++j;
        }
        while (i < this.m_iNumKnots) {
            this.m_afKnot[i] = 1.0f;
            ++i;
        }
    }

    public void dispose() {
        this.m_afKnot = null;
        this.m_aafBD0 = null;
        this.m_aafBD1 = null;
        this.m_aafBD2 = null;
        this.m_aafBD3 = null;
    }

    public float GetD0(int i) {
        return this.m_aafBD0[this.m_iDegree][i];
    }

    public float GetD1(int i) {
        return this.m_aafBD1[this.m_iDegree][i];
    }

    public float GetD2(int i) {
        return this.m_aafBD2[this.m_iDegree][i];
    }

    public float GetD3(int i) {
        return this.m_aafBD3[this.m_iDegree][i];
    }

    public int GetDegree() {
        return this.m_iDegree;
    }

    public int GetKey(float[] rfTime) {
        int i;
        if (this.m_bOpen) {
            if (rfTime[0] <= 0.0f) {
                rfTime[0] = 0.0f;
                return this.m_iDegree;
            }
            if (rfTime[0] >= 1.0f) {
                rfTime[0] = 1.0f;
                return this.m_iNumCtrlPoints - 1;
            }
        } else if (rfTime[0] < 0.0f || rfTime[0] > 1.0f) {
            rfTime[0] = (float)((double)rfTime[0] - Math.floor(rfTime[0]));
        }
        if (this.m_bUniform) {
            i = this.m_iDegree + (int)((float)(this.m_iNumCtrlPoints - this.m_iDegree) * rfTime[0]);
        } else {
            for (i = this.m_iDegree + 1; i <= this.m_iNumCtrlPoints && !(rfTime[0] < this.m_afKnot[i]); ++i) {
            }
            --i;
        }
        return i;
    }

    public float GetKnot(int i) {
        int j;
        if (!this.m_bUniform && this.m_iDegree + 1 <= (j = i + this.m_iDegree + 1) && j <= this.m_iNumCtrlPoints - 1) {
            return this.m_afKnot[j];
        }
        return Float.MAX_VALUE;
    }

    public int GetKnotIndex(float fU) {
        int iKnot;
        if (fU <= 0.0f) {
            return this.m_iDegree;
        }
        if (fU >= 1.0f) {
            return this.m_iNumCtrlPoints - 1;
        }
        for (iKnot = this.m_iDegree + 1; iKnot <= this.m_iNumCtrlPoints && fU >= this.m_afKnot[iKnot]; ++iKnot) {
        }
        return iKnot - 1;
    }

    public int GetNumCtrlPoints() {
        return this.m_iNumCtrlPoints;
    }

    public boolean IsOpen() {
        return this.m_bOpen;
    }

    public boolean IsSameAs(BSplineBasisf that) {
        return this.m_iDegree == that.m_iDegree && this.m_iNumCtrlPoints == that.m_iNumCtrlPoints;
    }

    public boolean IsUniform() {
        return this.m_bUniform;
    }

    public void SetKnot(int i, float fKnot) {
        int j;
        if (!this.m_bUniform && this.m_iDegree + 1 <= (j = i + this.m_iDegree + 1) && j <= this.m_iNumCtrlPoints - 1) {
            this.m_afKnot[j] = fKnot;
        }
    }

    private float[][] Allocate() {
        int iRows = this.m_iDegree + 1;
        int iCols = this.m_iNumCtrlPoints + this.m_iDegree;
        float[][] aafArray = new float[iRows][iCols];
        return aafArray;
    }

    private int Initialize(int iNumCtrlPoints, int iDegree, boolean bOpen) {
        assert (iNumCtrlPoints >= 2);
        assert (1 <= iDegree && iDegree <= iNumCtrlPoints - 1);
        this.m_iNumCtrlPoints = iNumCtrlPoints;
        this.m_iDegree = iDegree;
        this.m_bOpen = bOpen;
        int iNumKnots = this.m_iNumCtrlPoints + this.m_iDegree + 1;
        this.m_afKnot = new float[iNumKnots];
        this.m_aafBD0 = this.Allocate();
        this.m_aafBD1 = this.Allocate();
        this.m_aafBD2 = this.Allocate();
        this.m_aafBD3 = this.Allocate();
        return iNumKnots;
    }
}

