/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Curves;

import WildMagic.LibFoundation.Curves.Curve3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibFoundation.NumericalAnalysis.IntegrateInterface;
import java.io.Serializable;

public abstract class MultipleCurve3
extends Curve3f
implements IntegrateInterface,
Serializable {
    private static final long serialVersionUID = 1588298231763073285L;
    protected int m_iSegments;
    protected final float[] m_afTime;
    protected float[] m_afLength;
    protected float[] m_afAccumLength;

    protected MultipleCurve3(int iSegments, float[] afTime) {
        super(afTime[0], afTime[iSegments]);
        this.m_iSegments = iSegments;
        this.m_afTime = afTime;
        this.m_afLength = null;
        this.m_afAccumLength = null;
    }

    @Override
    public float GetLength(float fT0, float fT1) {
        float fLength;
        assert (this.m_fTMin <= fT0 && fT0 <= this.m_fTMax);
        assert (this.m_fTMin <= fT1 && fT1 <= this.m_fTMax);
        assert (fT0 <= fT1);
        if (this.m_afLength == null) {
            this.InitializeLength();
        }
        int[] iKey0 = new int[1];
        int[] iKey1 = new int[1];
        float[] fDt0 = new float[1];
        float[] fDt1 = new float[1];
        this.GetKeyInfo(fT0, iKey0, fDt0);
        this.GetKeyInfo(fT1, iKey1, fDt1);
        if (iKey0[0] < iKey1[0]) {
            fLength = 0.0f;
            for (int i = iKey0[0] + 1; i < iKey1[0]; ++i) {
                fLength += this.m_afLength[i];
            }
            fLength += this.GetLengthKey(iKey0[0], fDt0[0], this.m_afTime[iKey0[0] + 1] - this.m_afTime[iKey0[0]]);
            fLength += this.GetLengthKey(iKey1[0], 0.0f, fDt1[0]);
        } else {
            fLength = this.GetLengthKey(iKey0[0], fDt0[0], fDt1[0]);
        }
        return fLength;
    }

    public int GetSegments() {
        return this.m_iSegments;
    }

    @Override
    public float GetTime(float fLength, int iIterations, float fTolerance) {
        float fL1;
        float fL0;
        int iKey;
        if (this.m_afLength == null) {
            this.InitializeLength();
        }
        if (fLength <= 0.0f) {
            return this.m_fTMin;
        }
        if (fLength >= this.m_afAccumLength[this.m_iSegments - 1]) {
            return this.m_fTMax;
        }
        for (iKey = 0; iKey < this.m_iSegments && !(fLength < this.m_afAccumLength[iKey]); ++iKey) {
        }
        if (iKey >= this.m_iSegments) {
            return this.m_afTime[this.m_iSegments];
        }
        if (iKey == 0) {
            fL0 = fLength;
            fL1 = this.m_afAccumLength[0];
        } else {
            fL0 = fLength - this.m_afAccumLength[iKey - 1];
            fL1 = this.m_afAccumLength[iKey] - this.m_afAccumLength[iKey - 1];
        }
        float fDt1 = this.m_afTime[iKey + 1] - this.m_afTime[iKey];
        float fDt0 = fDt1 * fL0 / fL1;
        for (int i = 0; i < iIterations; ++i) {
            float fDifference = this.GetLengthKey(iKey, 0.0f, fDt0) - fL0;
            if (Math.abs(fDifference) <= fTolerance) {
                return this.m_afTime[iKey] + fDt0;
            }
            fDt0 -= fDifference / this.GetSpeedKey(iKey, fDt0);
        }
        return this.m_afTime[iKey] + fDt0;
    }

    public float[] GetTimes() {
        return this.m_afTime;
    }

    @Override
    public float GetVariation(float fT0, float fT1, Vector3f pkP0, Vector3f pkP1) {
        float fVariation;
        assert (this.m_fTMin <= fT0 && fT0 <= this.m_fTMax);
        assert (this.m_fTMin <= fT1 && fT1 <= this.m_fTMax);
        assert (fT0 <= fT1);
        Vector3f kP0 = this.GetPosition(fT0);
        pkP0.Copy(kP0);
        Vector3f kP1 = this.GetPosition(fT1);
        pkP1.Copy(kP1);
        float fInvDT = 1.0f / (fT1 - fT0);
        Vector3f kA = new Vector3f();
        Vector3f kB = new Vector3f();
        kB.Sub(pkP1, pkP0);
        kB.Scale(fInvDT);
        int[] iKey0 = new int[1];
        int[] iKey1 = new int[1];
        float[] fDt0 = new float[1];
        float[] fDt1 = new float[1];
        this.GetKeyInfo(fT0, iKey0, fDt0);
        this.GetKeyInfo(fT1, iKey1, fDt1);
        if (iKey0[0] < iKey1[0]) {
            fVariation = 0.0f;
            for (int i = iKey0[0] + 1; i < iKey1[0]; ++i) {
                kA.X = pkP0.X + (this.m_afTime[i] - fT0) * kB.X;
                kA.Y = pkP0.Y + (this.m_afTime[i] - fT0) * kB.Y;
                kA.Z = pkP0.Z + (this.m_afTime[i] - fT0) * kB.Z;
                fVariation += this.GetVariationKey(i, 0.0f, this.m_afTime[i + 1] - this.m_afTime[i], kA, kB);
            }
            kA.X = pkP0.X + (this.m_afTime[iKey0[0]] - fT0) * kB.X;
            kA.Y = pkP0.Y + (this.m_afTime[iKey0[0]] - fT0) * kB.Y;
            kA.Z = pkP0.Z + (this.m_afTime[iKey0[0]] - fT0) * kB.Z;
            fVariation += this.GetVariationKey(iKey0[0], fDt0[0], this.m_afTime[iKey0[0] + 1] - this.m_afTime[iKey0[0]], kA, kB);
            kA.X = pkP0.X + (this.m_afTime[iKey1[0]] - fT0) * kB.X;
            kA.Y = pkP0.Y + (this.m_afTime[iKey1[0]] - fT0) * kB.Y;
            kA.Z = pkP0.Z + (this.m_afTime[iKey1[0]] - fT0) * kB.Z;
            fVariation += this.GetVariationKey(iKey1[0], 0.0f, fDt1[0], kA, kB);
        } else {
            kA.X = pkP0.X + (this.m_afTime[iKey0[0]] - fT0) * kB.X;
            kA.Y = pkP0.Y + (this.m_afTime[iKey0[0]] - fT0) * kB.Y;
            kA.Z = pkP0.Z + (this.m_afTime[iKey0[0]] - fT0) * kB.Z;
            fVariation = this.GetVariationKey(iKey0[0], fDt0[0], fDt1[0], kA, kB);
        }
        return fVariation;
    }

    @Override
    public float Integrate(float fTime) {
        return this.GetSpeedWithData(fTime, this);
    }

    protected void GetKeyInfo(float fTime, int[] riKey, float[] rfDt) {
        if (fTime <= this.m_afTime[0]) {
            riKey[0] = 0;
            rfDt[0] = 0.0f;
        } else if (fTime >= this.m_afTime[this.m_iSegments]) {
            riKey[0] = this.m_iSegments - 1;
            rfDt[0] = this.m_afTime[this.m_iSegments] - this.m_afTime[this.m_iSegments - 1];
        } else {
            for (int i = 0; i < this.m_iSegments; ++i) {
                if (!(fTime < this.m_afTime[i + 1])) continue;
                riKey[0] = i;
                rfDt[0] = fTime - this.m_afTime[i];
                break;
            }
        }
    }

    protected abstract float GetLengthKey(int var1, float var2, float var3);

    protected abstract float GetSpeedKey(int var1, float var2);

    protected float GetSpeedWithData(float fTime, Curve3f pvData) {
        int iKey = this.getClass().hashCode();
        return this.GetSpeedKey(iKey, fTime);
    }

    protected abstract float GetVariationKey(int var1, float var2, float var3, Vector3f var4, Vector3f var5);

    protected void InitializeLength() {
        int iKey;
        this.m_afLength = new float[this.m_iSegments];
        this.m_afAccumLength = new float[this.m_iSegments];
        for (iKey = 0; iKey < this.m_iSegments; ++iKey) {
            this.m_afLength[iKey] = this.GetLengthKey(iKey, 0.0f, this.m_afTime[iKey + 1] - this.m_afTime[iKey]);
        }
        this.m_afAccumLength[0] = this.m_afLength[0];
        for (iKey = 1; iKey < this.m_iSegments; ++iKey) {
            this.m_afAccumLength[iKey] = this.m_afAccumLength[iKey - 1] + this.m_afLength[iKey];
        }
    }
}

