/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Curves;

import WildMagic.LibFoundation.Curves.Curve3f;
import WildMagic.LibFoundation.NumericalAnalysis.Integrate1;
import WildMagic.LibFoundation.NumericalAnalysis.IntegrateInterface;
import java.io.Serializable;

public abstract class SingleCurve3f
extends Curve3f
implements IntegrateInterface,
Serializable {
    private static final long serialVersionUID = -1802717780897782385L;

    public SingleCurve3f(float fTMin, float fTMax) {
        super(fTMin, fTMax);
    }

    @Override
    public float GetLength(float fT0, float fT1) {
        assert (this.m_fTMin <= fT0 && fT0 <= this.m_fTMax);
        assert (this.m_fTMin <= fT1 && fT1 <= this.m_fTMax);
        assert (fT0 <= fT1);
        return Integrate1.RombergIntegral(8, fT0, fT1, this);
    }

    @Override
    public float GetTime(float fLength, int iIterations, float fTolerance) {
        if (fLength <= 0.0f) {
            return this.m_fTMin;
        }
        if (fLength >= this.GetTotalLength()) {
            return this.m_fTMax;
        }
        float fRatio = fLength / this.GetTotalLength();
        float fOmRatio = 1.0f - fRatio;
        float fTime = fOmRatio * this.m_fTMin + fRatio * this.m_fTMax;
        for (int i = 0; i < iIterations; ++i) {
            float fDifference = this.GetLength(this.m_fTMin, fTime) - fLength;
            if (Math.abs(fDifference) < fTolerance) {
                return fTime;
            }
            fTime -= fDifference / this.GetSpeed(fTime);
        }
        return fTime;
    }

    @Override
    public float Integrate(float fTime) {
        return this.GetSpeed(fTime);
    }
}

