/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Intersection;

import WildMagic.LibFoundation.Intersection.Intersector;
import WildMagic.LibFoundation.Mathematics.Box3f;
import WildMagic.LibFoundation.Mathematics.Line3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class IntrLine3Box3f
extends Intersector
implements Serializable {
    private static final long serialVersionUID = 3500615932797785382L;
    private Line3f m_rkLine;
    private Box3f m_rkBox;
    private int m_iQuantity;
    private Vector3f[] m_akPoint = new Vector3f[2];

    public IntrLine3Box3f(Line3f rkLine, Box3f rkBox) {
        this.m_rkLine = rkLine;
        this.m_rkBox = rkBox;
    }

    public static boolean DoClipping(float[] fT0, float[] fT1, Vector3f rkOrigin, Vector3f rkDirection, Box3f rkBox, boolean bSolid, int[] riQuantity, Vector3f[] akPoint, Intersector.IntersectionInfo[] riIntrType) {
        boolean bNotAllClipped;
        assert (fT0[0] < fT1[0]);
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(rkOrigin, rkBox.Center);
        Vector3f kBOrigin = new Vector3f(kDiff.Dot(rkBox.Axis[0]), kDiff.Dot(rkBox.Axis[1]), kDiff.Dot(rkBox.Axis[2]));
        Vector3f kBDirection = new Vector3f(rkDirection.Dot(rkBox.Axis[0]), rkDirection.Dot(rkBox.Axis[1]), rkDirection.Dot(rkBox.Axis[2]));
        float fSaveT0 = fT0[0];
        float fSaveT1 = fT1[0];
        boolean bl = bNotAllClipped = IntrLine3Box3f.Clip(kBDirection.X, -kBOrigin.X - rkBox.Extent[0], fT0, fT1) && IntrLine3Box3f.Clip(-kBDirection.X, kBOrigin.X - rkBox.Extent[0], fT0, fT1) && IntrLine3Box3f.Clip(kBDirection.Y, -kBOrigin.Y - rkBox.Extent[1], fT0, fT1) && IntrLine3Box3f.Clip(-kBDirection.Y, kBOrigin.Y - rkBox.Extent[1], fT0, fT1) && IntrLine3Box3f.Clip(kBDirection.Z, -kBOrigin.Z - rkBox.Extent[2], fT0, fT1) && IntrLine3Box3f.Clip(-kBDirection.Z, kBOrigin.Z - rkBox.Extent[2], fT0, fT1);
        if (bNotAllClipped && (bSolid || fT0[0] != fSaveT0 || fT1[0] != fSaveT1)) {
            if (fT1[0] > fT0[0]) {
                riIntrType[0] = Intersector.IntersectionInfo.IT_SEGMENT;
                riQuantity[0] = 2;
                akPoint[0].Copy(rkDirection);
                akPoint[0].Scale(fT0[0]);
                akPoint[0].Add(rkOrigin);
                akPoint[1].Copy(rkDirection);
                akPoint[1].Scale(fT1[0]);
                akPoint[1].Add(rkOrigin);
            } else {
                riIntrType[0] = Intersector.IntersectionInfo.IT_POINT;
                riQuantity[0] = 1;
                akPoint[0].Copy(rkDirection);
                akPoint[0].Scale(fT0[0]);
                akPoint[0].Add(rkOrigin);
            }
        } else {
            riQuantity[0] = 0;
            riIntrType[0] = Intersector.IntersectionInfo.IT_EMPTY;
        }
        return riIntrType[0] != Intersector.IntersectionInfo.IT_EMPTY;
    }

    private static boolean Clip(float fDenom, float fNumer, float[] rfT0, float[] rfT1) {
        if (fDenom > 0.0f) {
            if (fNumer > fDenom * rfT1[0]) {
                return false;
            }
            if (fNumer > fDenom * rfT0[0]) {
                rfT0[0] = fNumer / fDenom;
            }
            return true;
        }
        if (fDenom < 0.0f) {
            if (fNumer > fDenom * rfT0[0]) {
                return false;
            }
            if (fNumer > fDenom * rfT1[0]) {
                rfT1[0] = fNumer / fDenom;
            }
            return true;
        }
        return fNumer <= 0.0f;
    }

    @Override
    public boolean Find() {
        float[] fT0 = new float[]{-3.4028235E38f};
        float[] fT1 = new float[]{Float.MAX_VALUE};
        int[] aiQuantity = new int[]{this.m_iQuantity};
        Intersector.IntersectionInfo[] iIntersectionType = new Intersector.IntersectionInfo[]{this.m_iIntersectionType};
        boolean bResult = IntrLine3Box3f.DoClipping(fT0, fT1, this.m_rkLine.Origin, this.m_rkLine.Direction, this.m_rkBox, true, aiQuantity, this.m_akPoint, iIntersectionType);
        this.m_iQuantity = aiQuantity[0];
        this.m_iIntersectionType = iIntersectionType[0];
        return bResult;
    }

    public final Box3f GetBox() {
        return this.m_rkBox;
    }

    public final Line3f GetLine() {
        return this.m_rkLine;
    }

    public final Vector3f GetPoint(int i) {
        assert (0 <= i && i < this.m_iQuantity);
        return this.m_akPoint[i];
    }

    public int GetQuantity() {
        return this.m_iQuantity;
    }

    @Override
    public boolean Test() {
        float[] afAWdU = new float[3];
        float[] afAWxDdU = new float[3];
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(this.m_rkLine.Origin, this.m_rkBox.Center);
        Vector3f kWxD = new Vector3f();
        kWxD.Cross(this.m_rkLine.Direction, kDiff);
        afAWdU[1] = Math.abs(this.m_rkLine.Direction.Dot(this.m_rkBox.Axis[1]));
        afAWdU[2] = Math.abs(this.m_rkLine.Direction.Dot(this.m_rkBox.Axis[2]));
        afAWxDdU[0] = Math.abs(kWxD.Dot(this.m_rkBox.Axis[0]));
        float fRhs = this.m_rkBox.Extent[1] * afAWdU[2] + this.m_rkBox.Extent[2] * afAWdU[1];
        if (afAWxDdU[0] > fRhs) {
            return false;
        }
        afAWdU[0] = Math.abs(this.m_rkLine.Direction.Dot(this.m_rkBox.Axis[0]));
        afAWxDdU[1] = Math.abs(kWxD.Dot(this.m_rkBox.Axis[1]));
        fRhs = this.m_rkBox.Extent[0] * afAWdU[2] + this.m_rkBox.Extent[2] * afAWdU[0];
        if (afAWxDdU[1] > fRhs) {
            return false;
        }
        afAWxDdU[2] = Math.abs(kWxD.Dot(this.m_rkBox.Axis[2]));
        fRhs = this.m_rkBox.Extent[0] * afAWdU[1] + this.m_rkBox.Extent[1] * afAWdU[0];
        return !(afAWxDdU[2] > fRhs);
    }
}

