/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Intersection;

import WildMagic.LibFoundation.Intersection.Intersector;
import WildMagic.LibFoundation.Mathematics.Line3f;
import WildMagic.LibFoundation.Mathematics.Plane3f;
import java.io.Serializable;

public class IntrLine3Plane3f
extends Intersector
implements Serializable {
    private static final long serialVersionUID = 2122835024252535630L;
    public Intersector.IntersectionInfo m_kIntersectionType;
    private Line3f m_kLine;
    private Plane3f m_kPlane;
    private float m_fLineParameter;

    public IntrLine3Plane3f(Line3f kLine, Plane3f kPlane) {
        this.m_kLine = new Line3f(kLine);
        this.m_kPlane = new Plane3f(kPlane);
    }

    public Line3f GetLine() {
        return this.m_kLine;
    }

    public Plane3f GetPlane() {
        return this.m_kPlane;
    }

    @Override
    public boolean Test() {
        float DdN = this.m_kLine.Direction.Dot(this.m_kPlane.Normal);
        if (Math.abs(DdN) > 1.0E-6f) {
            this.m_kIntersectionType = Intersector.IntersectionInfo.IT_POINT;
            return true;
        }
        float signedDistance = this.m_kPlane.DistanceTo(this.m_kLine.Origin);
        if (Math.abs(signedDistance) <= 1.0E-6f) {
            this.m_kIntersectionType = Intersector.IntersectionInfo.IT_LINE;
            return true;
        }
        this.m_kIntersectionType = Intersector.IntersectionInfo.IT_EMPTY;
        return false;
    }

    @Override
    public boolean Find() {
        float DdN = this.m_kLine.Direction.Dot(this.m_kPlane.Normal);
        float signedDistance = this.m_kPlane.DistanceTo(this.m_kLine.Origin);
        if (Math.abs(DdN) > 1.0E-6f) {
            this.m_fLineParameter = -signedDistance / DdN;
            this.m_kIntersectionType = Intersector.IntersectionInfo.IT_POINT;
            return true;
        }
        if (Math.abs(signedDistance) <= 1.0E-6f) {
            this.m_fLineParameter = 0.0f;
            this.m_kIntersectionType = Intersector.IntersectionInfo.IT_LINE;
            return true;
        }
        this.m_kIntersectionType = Intersector.IntersectionInfo.IT_EMPTY;
        return false;
    }

    public float GetLineParameter() {
        return this.m_fLineParameter;
    }
}

