/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Intersection;

import WildMagic.LibFoundation.Intersection.Intersector;
import WildMagic.LibFoundation.Mathematics.Line3f;
import WildMagic.LibFoundation.Mathematics.Sphere3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class IntrLine3Sphere3f
extends Intersector
implements Serializable {
    private static final long serialVersionUID = 1097380556589112641L;
    private Line3f m_rkLine;
    private Sphere3f m_rkSphere;
    private int m_iQuantity;
    private Vector3f[] m_akPoint = new Vector3f[]{new Vector3f(), new Vector3f()};
    private float[] m_afLineT = new float[2];

    public IntrLine3Sphere3f(Line3f rkLine, Sphere3f rkSphere) {
        this.m_rkLine = new Line3f(rkLine);
        this.m_rkSphere = new Sphere3f(rkSphere);
        this.m_iQuantity = 0;
    }

    public void dispose() {
        if (this.m_rkLine != null) {
            this.m_rkLine.dispose();
            this.m_rkLine = null;
        }
        this.m_rkLine = null;
        this.m_rkSphere.dispose();
        if (this.m_rkLine != null) {
            this.m_rkSphere.dispose();
            this.m_rkSphere = null;
        }
        for (int i = 0; i < 2; ++i) {
            this.m_akPoint[i] = null;
        }
        this.m_akPoint = null;
        this.m_afLineT = null;
    }

    @Override
    public boolean Find() {
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(this.m_rkLine.Origin, this.m_rkSphere.Center);
        float fA0 = kDiff.Dot(kDiff) - this.m_rkSphere.Radius * this.m_rkSphere.Radius;
        float fA1 = this.m_rkLine.Direction.Dot(kDiff);
        float fDiscr = fA1 * fA1 - fA0;
        kDiff = null;
        if (fDiscr < 0.0f) {
            this.m_iQuantity = 0;
        } else if (fDiscr >= 1.0E-6f) {
            float fRoot = (float)Math.sqrt(fDiscr);
            this.m_afLineT[0] = -fA1 - fRoot;
            this.m_afLineT[1] = -fA1 + fRoot;
            Vector3f kScale = new Vector3f(this.m_rkLine.Direction);
            kScale.Scale(this.m_afLineT[0]);
            this.m_akPoint[0].Add(this.m_rkLine.Origin, kScale);
            kScale.Scale(this.m_afLineT[1]);
            kScale.Copy(this.m_rkLine.Direction);
            this.m_akPoint[1].Add(this.m_rkLine.Origin, kScale);
            this.m_iQuantity = 2;
            kScale = null;
        } else {
            this.m_afLineT[0] = -fA1;
            Vector3f kScale = new Vector3f(this.m_rkLine.Direction);
            kScale.Scale(this.m_afLineT[0]);
            this.m_akPoint[0].Add(this.m_rkLine.Origin, kScale);
            this.m_iQuantity = 1;
            kScale = null;
        }
        return this.m_iQuantity > 0;
    }

    public final Line3f GetLine() {
        return this.m_rkLine;
    }

    public final float GetLineT(int i) {
        assert (0 <= i && i < this.m_iQuantity);
        return this.m_afLineT[i];
    }

    public final Vector3f GetPoint(int i) {
        assert (0 <= i && i < this.m_iQuantity);
        return this.m_akPoint[i];
    }

    public final int GetQuantity() {
        return this.m_iQuantity;
    }

    public final Sphere3f GetSphere() {
        return this.m_rkSphere;
    }

    @Override
    public boolean Test() {
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(this.m_rkLine.Origin, this.m_rkSphere.Center);
        float fA0 = kDiff.Dot(kDiff) - this.m_rkSphere.Radius * this.m_rkSphere.Radius;
        float fA1 = this.m_rkLine.Direction.Dot(kDiff);
        float fDiscr = fA1 * fA1 - fA0;
        kDiff = null;
        return fDiscr >= 0.0f;
    }
}

