/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Intersection;

import WildMagic.LibFoundation.Intersection.Intersector;
import WildMagic.LibFoundation.Mathematics.Line3f;
import WildMagic.LibFoundation.Mathematics.Triangle3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class IntrLine3Triangle3f
extends Intersector
implements Serializable {
    private static final long serialVersionUID = 2017917025331845751L;
    private final Line3f m_rkLine;
    private final Triangle3f m_rkTriangle;
    private float m_fLineT;
    private float m_fTriB0;
    private float m_fTriB1;
    private float m_fTriB2;

    public IntrLine3Triangle3f(Line3f rkLine, Triangle3f rkTriangle) {
        this.m_rkLine = new Line3f(rkLine);
        this.m_rkTriangle = new Triangle3f(rkTriangle);
    }

    @Override
    public boolean Find() {
        float fSign;
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(this.m_rkLine.Origin, this.m_rkTriangle.V[0]);
        Vector3f kEdge1 = new Vector3f();
        kEdge1.Sub(this.m_rkTriangle.V[1], this.m_rkTriangle.V[0]);
        Vector3f kEdge2 = new Vector3f();
        kEdge2.Sub(this.m_rkTriangle.V[2], this.m_rkTriangle.V[0]);
        Vector3f kNormal = new Vector3f();
        kNormal.Cross(kEdge1, kEdge2);
        float fDdN = this.m_rkLine.Direction.Dot(kNormal);
        if (fDdN > 1.0E-6f) {
            fSign = 1.0f;
        } else if (fDdN < -1.0E-6f) {
            fSign = -1.0f;
            fDdN = -fDdN;
        } else {
            return false;
        }
        Vector3f kDxE2 = new Vector3f();
        kDxE2.Cross(kDiff, kEdge2);
        float fDdQxE2 = fSign * this.m_rkLine.Direction.Dot(kDxE2);
        if ((double)fDdQxE2 >= 0.0) {
            Vector3f kE1xD = new Vector3f();
            kE1xD.Cross(kEdge1, kDiff);
            float fDdE1xQ = fSign * this.m_rkLine.Direction.Dot(kE1xD);
            if ((double)fDdE1xQ >= 0.0 && fDdQxE2 + fDdE1xQ <= fDdN) {
                float fQdN = -fSign * kDiff.Dot(kNormal);
                float fInv = 1.0f / fDdN;
                this.m_fLineT = fQdN * fInv;
                this.m_fTriB1 = fDdQxE2 * fInv;
                this.m_fTriB2 = fDdE1xQ * fInv;
                this.m_fTriB0 = 1.0f - this.m_fTriB1 - this.m_fTriB2;
                return true;
            }
        }
        return false;
    }

    public final Line3f GetLine() {
        return this.m_rkLine;
    }

    public float GetLineT() {
        return this.m_fLineT;
    }

    public final Triangle3f GetTriangle() {
        return this.m_rkTriangle;
    }

    public float GetTriB0() {
        return this.m_fTriB0;
    }

    public float GetTriB1() {
        return this.m_fTriB1;
    }

    public float GetTriB2() {
        return this.m_fTriB2;
    }

    @Override
    public boolean Test() {
        float fSign;
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(this.m_rkLine.Origin, this.m_rkTriangle.V[0]);
        Vector3f kEdge1 = new Vector3f();
        kEdge1.Sub(this.m_rkTriangle.V[1], this.m_rkTriangle.V[0]);
        Vector3f kEdge2 = new Vector3f();
        kEdge2.Sub(this.m_rkTriangle.V[2], this.m_rkTriangle.V[0]);
        Vector3f kNormal = new Vector3f();
        kNormal.Cross(kEdge1, kEdge2);
        float fDdN = this.m_rkLine.Direction.Dot(kNormal);
        if (fDdN > 1.0E-6f) {
            fSign = 1.0f;
        } else if (fDdN < -1.0E-6f) {
            fSign = -1.0f;
            fDdN = -fDdN;
        } else {
            return false;
        }
        Vector3f kDxE2 = new Vector3f();
        kDxE2.Cross(kDiff, kEdge2);
        float fDdQxE2 = fSign * this.m_rkLine.Direction.Dot(kDxE2);
        if ((double)fDdQxE2 >= 0.0) {
            Vector3f kE1xD = new Vector3f();
            kE1xD.Cross(kEdge1, kDiff);
            float fDdE1xQ = fSign * this.m_rkLine.Direction.Dot(kE1xD);
            if ((double)fDdE1xQ >= 0.0 && fDdQxE2 + fDdE1xQ <= fDdN) {
                return true;
            }
        }
        return false;
    }
}

