/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Intersection;

import WildMagic.LibFoundation.Intersection.Intersector;
import WildMagic.LibFoundation.Intersection.IntrLine3Box3f;
import WildMagic.LibFoundation.Mathematics.Box3f;
import WildMagic.LibFoundation.Mathematics.Ray3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class IntrRay3Box3f
extends Intersector
implements Serializable {
    private static final long serialVersionUID = -2742437974401678656L;
    private Ray3f m_rkRay;
    private Box3f m_rkBox;
    private int m_iQuantity;
    private Vector3f[] m_akPoint = new Vector3f[2];

    public IntrRay3Box3f(Ray3f rkRay, Box3f rkBox) {
        this.m_rkRay = rkRay;
        this.m_rkBox = rkBox;
    }

    @Override
    public boolean Find() {
        float[] fT0 = new float[]{0.0f};
        float[] fT1 = new float[]{Float.MAX_VALUE};
        int[] aiQuantity = new int[]{this.m_iQuantity};
        Intersector.IntersectionInfo[] iIntersectionType = new Intersector.IntersectionInfo[]{this.m_iIntersectionType};
        boolean bResult = IntrLine3Box3f.DoClipping(fT0, fT1, this.m_rkRay.Origin, this.m_rkRay.Direction, this.m_rkBox, true, aiQuantity, this.m_akPoint, iIntersectionType);
        this.m_iQuantity = aiQuantity[0];
        this.m_iIntersectionType = iIntersectionType[0];
        return bResult;
    }

    public final Box3f GetBox() {
        return this.m_rkBox;
    }

    public final Vector3f GetPoint(int i) {
        assert (0 <= i && i < this.m_iQuantity);
        return this.m_akPoint[i];
    }

    public int GetQuantity() {
        return this.m_iQuantity;
    }

    public final Ray3f GetRay() {
        return this.m_rkRay;
    }

    @Override
    public boolean Test() {
        float[] afWdU = new float[3];
        float[] afAWdU = new float[3];
        float[] afDdU = new float[3];
        float[] afADdU = new float[3];
        float[] afAWxDdU = new float[3];
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(this.m_rkRay.Origin, this.m_rkBox.Center);
        afWdU[0] = this.m_rkRay.Direction.Dot(this.m_rkBox.Axis[0]);
        afAWdU[0] = Math.abs(afWdU[0]);
        afDdU[0] = kDiff.Dot(this.m_rkBox.Axis[0]);
        afADdU[0] = Math.abs(afDdU[0]);
        if (afADdU[0] > this.m_rkBox.Extent[0] && (double)(afDdU[0] * afWdU[0]) >= 0.0) {
            return false;
        }
        afWdU[1] = this.m_rkRay.Direction.Dot(this.m_rkBox.Axis[1]);
        afAWdU[1] = Math.abs(afWdU[1]);
        afDdU[1] = kDiff.Dot(this.m_rkBox.Axis[1]);
        afADdU[1] = Math.abs(afDdU[1]);
        if (afADdU[1] > this.m_rkBox.Extent[1] && (double)(afDdU[1] * afWdU[1]) >= 0.0) {
            return false;
        }
        afWdU[2] = this.m_rkRay.Direction.Dot(this.m_rkBox.Axis[2]);
        afAWdU[2] = Math.abs(afWdU[2]);
        afDdU[2] = kDiff.Dot(this.m_rkBox.Axis[2]);
        afADdU[2] = Math.abs(afDdU[2]);
        if (afADdU[2] > this.m_rkBox.Extent[2] && (double)(afDdU[2] * afWdU[2]) >= 0.0) {
            return false;
        }
        Vector3f kWxD = new Vector3f();
        kWxD.Cross(this.m_rkRay.Direction, kDiff);
        afAWxDdU[0] = Math.abs(kWxD.Dot(this.m_rkBox.Axis[0]));
        float fRhs = this.m_rkBox.Extent[1] * afAWdU[2] + this.m_rkBox.Extent[2] * afAWdU[1];
        if (afAWxDdU[0] > fRhs) {
            return false;
        }
        afAWxDdU[1] = Math.abs(kWxD.Dot(this.m_rkBox.Axis[1]));
        fRhs = this.m_rkBox.Extent[0] * afAWdU[2] + this.m_rkBox.Extent[2] * afAWdU[0];
        if (afAWxDdU[1] > fRhs) {
            return false;
        }
        afAWxDdU[2] = Math.abs(kWxD.Dot(this.m_rkBox.Axis[2]));
        fRhs = this.m_rkBox.Extent[0] * afAWdU[1] + this.m_rkBox.Extent[1] * afAWdU[0];
        return !(afAWxDdU[2] > fRhs);
    }
}

