/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Intersection;

import WildMagic.LibFoundation.Intersection.Intersector;
import WildMagic.LibFoundation.Mathematics.Ray3f;
import WildMagic.LibFoundation.Mathematics.Sphere3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class IntrRay3Sphere3f
extends Intersector
implements Serializable {
    private static final long serialVersionUID = -4093407641415284839L;
    private Ray3f m_rkRay;
    private Sphere3f m_rkSphere;
    private int m_iQuantity;
    private Vector3f[] m_akPoint = new Vector3f[]{new Vector3f(), new Vector3f()};
    private float[] m_afRayT = new float[2];

    public IntrRay3Sphere3f(Ray3f rkRay, Sphere3f rkSphere) {
        this.m_rkRay = new Ray3f(rkRay);
        this.m_rkSphere = new Sphere3f(rkSphere);
        this.m_iQuantity = 0;
    }

    public void dispose() {
        if (this.m_rkRay != null) {
            this.m_rkRay.dispose();
            this.m_rkRay = null;
        }
        this.m_rkRay = null;
        this.m_rkSphere.dispose();
        if (this.m_rkRay != null) {
            this.m_rkSphere.dispose();
            this.m_rkSphere = null;
        }
        for (int i = 0; i < 2; ++i) {
            this.m_akPoint[i] = null;
        }
        this.m_akPoint = null;
        this.m_afRayT = null;
    }

    @Override
    public boolean Find() {
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(this.m_rkRay.Origin, this.m_rkSphere.Center);
        float fA0 = kDiff.Dot(kDiff) - this.m_rkSphere.Radius * this.m_rkSphere.Radius;
        if (fA0 <= 0.0f) {
            this.m_iQuantity = 1;
            float fA1 = this.m_rkRay.Direction.Dot(kDiff);
            float fDiscr = fA1 * fA1 - fA0;
            float fRoot = (float)Math.sqrt(fDiscr);
            this.m_afRayT[0] = -fA1 + fRoot;
            Vector3f kScale = new Vector3f(this.m_rkRay.Direction);
            kScale.Scale(this.m_afRayT[0]);
            this.m_akPoint[0].Add(this.m_rkRay.Origin, kScale);
            kScale = null;
            kDiff = null;
            return true;
        }
        float fA1 = this.m_rkRay.Direction.Dot(kDiff);
        if (fA1 >= 0.0f) {
            this.m_iQuantity = 0;
            kDiff = null;
            return false;
        }
        float fDiscr = fA1 * fA1 - fA0;
        if (fDiscr < 0.0f) {
            this.m_iQuantity = 0;
        } else if (fDiscr >= 1.0E-6f) {
            float fRoot = (float)Math.sqrt(fDiscr);
            this.m_afRayT[0] = -fA1 - fRoot;
            this.m_afRayT[1] = -fA1 + fRoot;
            Vector3f kScale = new Vector3f(this.m_rkRay.Direction);
            kScale.Scale(this.m_afRayT[0]);
            this.m_akPoint[0].Add(this.m_rkRay.Origin, kScale);
            kScale.Copy(this.m_rkRay.Direction);
            kScale.Scale(this.m_afRayT[1]);
            this.m_akPoint[1].Add(this.m_rkRay.Origin, kScale);
            this.m_iQuantity = 2;
            kScale = null;
        } else {
            this.m_afRayT[0] = -fA1;
            Vector3f kScale = new Vector3f(this.m_rkRay.Direction);
            kScale.Scale(this.m_afRayT[0]);
            this.m_akPoint[0].Add(this.m_rkRay.Origin, kScale);
            this.m_iQuantity = 1;
            kScale = null;
        }
        kDiff = null;
        return this.m_iQuantity > 0;
    }

    public final Vector3f GetPoint(int i) {
        assert (0 <= i && i < this.m_iQuantity);
        return this.m_akPoint[i];
    }

    public final int GetQuantity() {
        return this.m_iQuantity;
    }

    public final Ray3f GetRay() {
        return this.m_rkRay;
    }

    public final float GetRayT(int i) {
        assert (0 <= i && i < this.m_iQuantity);
        return this.m_afRayT[i];
    }

    public final Sphere3f GetSphere() {
        return this.m_rkSphere;
    }

    @Override
    public boolean Test() {
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(this.m_rkRay.Origin, this.m_rkSphere.Center);
        float fA0 = kDiff.Dot(kDiff) - this.m_rkSphere.Radius * this.m_rkSphere.Radius;
        if (fA0 <= 0.0f) {
            kDiff = null;
            return true;
        }
        float fA1 = this.m_rkRay.Direction.Dot(kDiff);
        if (fA1 >= 0.0f) {
            kDiff = null;
            return false;
        }
        kDiff = null;
        return fA1 * fA1 >= fA0;
    }
}

