/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Intersection;

import WildMagic.LibFoundation.Mathematics.Circle2f;
import WildMagic.LibFoundation.Mathematics.Segment2f;
import WildMagic.LibFoundation.Mathematics.Vector2f;
import java.io.Serializable;

public class IntrSegment2Circle2f
implements Serializable {
    private static final long serialVersionUID = 1252596150994500095L;

    public static int FindIntersection(Segment2f kSegment, Circle2f kCircle, Vector2f[] akPoint) {
        float[] afT = new float[2];
        int iQuantity = IntrSegment2Circle2f.Find(kSegment.Origin, kSegment.Direction, kCircle.Center, kCircle.Radius, afT);
        if (0 != iQuantity) {
            if (iQuantity == 1) {
                if (afT[0] < 0.0f || afT[0] > 1.0f) {
                    iQuantity = 0;
                }
            } else if (afT[1] < 0.0f || afT[0] > 1.0f) {
                iQuantity = 0;
            } else if (afT[1] <= 1.0f) {
                if (afT[0] < 0.0f) {
                    iQuantity = 1;
                    afT[0] = afT[1];
                }
            } else {
                iQuantity = afT[0] >= 0.0f ? 1 : 0;
            }
            for (int i = 0; i < iQuantity; ++i) {
                akPoint[i].ScaleAdd(afT[i], kSegment.Direction, kSegment.Origin);
            }
        }
        return iQuantity;
    }

    private static int Find(Vector2f kP, Vector2f kD, Vector2f kC, float fR, float[] afT) {
        int iRootCount;
        Vector2f kDiff = new Vector2f();
        kDiff.Sub(kP, kC);
        float fA0 = kDiff.SquaredLength() - fR * fR;
        float fA1 = kD.Dot(kDiff);
        float fA2 = kD.SquaredLength();
        float fDiscr = fA1 * fA1 - fA0 * fA2;
        if (fDiscr > 0.0f) {
            iRootCount = 2;
            float fInvA2 = 1.0f / fA2;
            fDiscr = (float)Math.sqrt(fDiscr);
            afT[0] = (-fA1 - fDiscr) * fInvA2;
            afT[1] = (-fA1 + fDiscr) * fInvA2;
        } else if (fDiscr < 0.0f) {
            iRootCount = 0;
        } else {
            iRootCount = 1;
            afT[0] = -fA1 / fA2;
        }
        return iRootCount;
    }
}

