/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Intersection;

import WildMagic.LibFoundation.Intersection.Intersector;
import WildMagic.LibFoundation.Mathematics.Segment3f;
import WildMagic.LibFoundation.Mathematics.Triangle3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class IntrSegment3Triangle3f
extends Intersector
implements Serializable {
    private Segment3f Segment;
    private Triangle3f Triangle;
    private float m_fSegmentParameter;
    private float mTriBary0;
    private float mTriBary1;
    private float mTriBary2;
    private int m_iQuantity;
    private Vector3f[] m_kPoint = new Vector3f[2];

    public IntrSegment3Triangle3f(Segment3f segment, Triangle3f triangle) {
        this.Segment = segment;
        this.Triangle = triangle;
        this.m_iQuantity = 0;
    }

    public Segment3f GetSegment() {
        return this.Segment;
    }

    public Triangle3f GetTriangle() {
        return this.Triangle;
    }

    @Override
    public boolean Test() {
        float sign;
        Vector3f diff = new Vector3f();
        diff.Sub(this.Segment.Center, this.Triangle.V[0]);
        Vector3f edge1 = new Vector3f();
        edge1.Sub(this.Triangle.V[1], this.Triangle.V[0]);
        Vector3f edge2 = new Vector3f();
        edge2.Sub(this.Triangle.V[2], this.Triangle.V[0]);
        Vector3f normal = new Vector3f();
        normal.Cross(edge1, edge2);
        float DdN = this.Segment.Direction.Dot(normal);
        if (DdN > 1.0E-6f) {
            sign = 1.0f;
        } else if (DdN < -1.0E-6f) {
            sign = -1.0f;
            DdN = -DdN;
        } else {
            this.m_iIntersectionType = Intersector.IntersectionInfo.IT_EMPTY;
            return false;
        }
        Vector3f temp = new Vector3f();
        temp.Cross(diff, edge2);
        float DdQxE2 = sign * this.Segment.Direction.Dot(temp);
        if (DdQxE2 >= 0.0f) {
            float QdN;
            float extDdN;
            temp.Cross(edge1, diff);
            float DdE1xQ = sign * this.Segment.Direction.Dot(temp);
            if (DdE1xQ >= 0.0f && DdQxE2 + DdE1xQ <= DdN && -(extDdN = this.Segment.Extent * DdN) <= (QdN = -sign * diff.Dot(normal)) && QdN <= extDdN) {
                this.m_iIntersectionType = Intersector.IntersectionInfo.IT_POINT;
                return true;
            }
        }
        this.m_iIntersectionType = Intersector.IntersectionInfo.IT_EMPTY;
        return false;
    }

    @Override
    public boolean Find() {
        float sign;
        Vector3f diff = new Vector3f();
        diff.Sub(this.Segment.Center, this.Triangle.V[0]);
        Vector3f edge1 = new Vector3f();
        edge1.Sub(this.Triangle.V[1], this.Triangle.V[0]);
        Vector3f edge2 = new Vector3f();
        edge2.Sub(this.Triangle.V[2], this.Triangle.V[0]);
        Vector3f normal = new Vector3f();
        normal.Cross(edge1, edge2);
        float DdN = this.Segment.Direction.Dot(normal);
        if (DdN > 1.0E-6f) {
            sign = 1.0f;
        } else if (DdN < -1.0E-6f) {
            sign = -1.0f;
            DdN = -DdN;
        } else {
            this.m_iIntersectionType = Intersector.IntersectionInfo.IT_EMPTY;
            return false;
        }
        Vector3f temp = new Vector3f();
        temp.Cross(diff, edge2);
        float DdQxE2 = sign * this.Segment.Direction.Dot(temp);
        if (DdQxE2 >= 0.0f) {
            float QdN;
            float extDdN;
            temp.Cross(edge1, diff);
            float DdE1xQ = sign * this.Segment.Direction.Dot(temp);
            if (DdE1xQ >= 0.0f && DdQxE2 + DdE1xQ <= DdN && -(extDdN = this.Segment.Extent * DdN) <= (QdN = -sign * diff.Dot(normal)) && QdN <= extDdN) {
                float inv = 1.0f / DdN;
                this.m_fSegmentParameter = QdN * inv;
                this.mTriBary1 = DdQxE2 * inv;
                this.mTriBary2 = DdE1xQ * inv;
                this.mTriBary0 = 1.0f - this.mTriBary1 - this.mTriBary2;
                return true;
            }
        }
        this.m_iIntersectionType = Intersector.IntersectionInfo.IT_EMPTY;
        return false;
    }

    public float GetSegmentParameter() {
        return this.m_fSegmentParameter;
    }

    public float GetTriBary0() {
        return this.mTriBary0;
    }

    public float GetTriBary1() {
        return this.mTriBary1;
    }

    public float GetTriBary2() {
        return this.mTriBary2;
    }

    public int GetQuantity() {
        return this.m_iQuantity;
    }

    public Vector3f GetPoint(int i) {
        return this.m_kPoint[i];
    }
}

