/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Intersection;

import WildMagic.LibFoundation.Intersection.Intersector;
import WildMagic.LibFoundation.Mathematics.Sphere3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class IntrSphere3Sphere3f
extends Intersector
implements Serializable {
    private static final long serialVersionUID = -4843031084318145545L;
    private Sphere3f m_rkSphere0;
    private Sphere3f m_rkSphere1;
    private Vector3f m_kCenter = new Vector3f();
    private Vector3f m_kUAxis = new Vector3f();
    private Vector3f m_kVAxis = new Vector3f();
    private Vector3f m_kNormal = new Vector3f();
    private float m_fRadius;
    private Vector3f m_kContactPoint = new Vector3f();

    public IntrSphere3Sphere3f(Sphere3f rkSphere0, Sphere3f rkSphere1) {
        this.m_rkSphere0 = new Sphere3f(rkSphere0);
        this.m_rkSphere1 = new Sphere3f(rkSphere1);
    }

    public void dispose() {
        if (this.m_rkSphere0 != null) {
            this.m_rkSphere0.dispose();
            this.m_rkSphere0 = null;
        }
        if (this.m_rkSphere1 != null) {
            this.m_rkSphere1.dispose();
            this.m_rkSphere1 = null;
        }
        this.m_kCenter = null;
        this.m_kUAxis = null;
        this.m_kVAxis = null;
        this.m_kNormal = null;
        this.m_kContactPoint = null;
    }

    @Override
    public boolean Find() {
        this.m_kNormal.Sub(this.m_rkSphere1.Center, this.m_rkSphere0.Center);
        float fNSqrLen = this.m_kNormal.SquaredLength();
        float fRSum = this.m_rkSphere0.Radius + this.m_rkSphere1.Radius;
        if (fNSqrLen > fRSum * fRSum) {
            return false;
        }
        float fR0Sqr = this.m_rkSphere0.Radius * this.m_rkSphere0.Radius;
        float fR1Sqr = this.m_rkSphere1.Radius * this.m_rkSphere1.Radius;
        float fInvNSqrLen = 1.0f / fNSqrLen;
        float fT = 0.5f * (1.0f + (fR0Sqr - fR1Sqr) * fInvNSqrLen);
        if (fT < 0.0f || fT > 1.0f) {
            return false;
        }
        float fRSqr = fR0Sqr - fT * fT * fNSqrLen;
        if (fRSqr < 0.0f) {
            return false;
        }
        Vector3f kScale = new Vector3f();
        kScale.Scale(fT, this.m_kNormal);
        this.m_kCenter.Add(this.m_rkSphere0.Center, kScale);
        this.m_fRadius = (float)Math.sqrt(fRSqr);
        kScale = null;
        this.m_kNormal.Scale((float)Math.sqrt(fInvNSqrLen));
        Vector3f.GenerateComplementBasis(this.m_kUAxis, this.m_kVAxis, this.m_kNormal);
        return true;
    }

    public boolean Find(float fTMax, Vector3f rkVelocity0, Vector3f rkVelocity1) {
        float fB;
        Vector3f kVDiff = new Vector3f();
        kVDiff.Sub(rkVelocity1, rkVelocity0);
        float fA = kVDiff.SquaredLength();
        Vector3f kCDiff = new Vector3f();
        kCDiff.Sub(this.m_rkSphere1.Center, this.m_rkSphere0.Center);
        float fC = kCDiff.SquaredLength();
        float fRSum = this.m_rkSphere0.Radius + this.m_rkSphere1.Radius;
        float fRSumSqr = fRSum * fRSum;
        if (fA > 0.0f && (fB = kCDiff.Dot(kVDiff)) <= 0.0f) {
            float fCDiff;
            float fDiscr;
            if ((-fTMax * fA <= fB || fTMax * (fTMax * fA + 2.0f * fB) + fC <= fRSumSqr) && (fDiscr = fB * fB - fA * (fCDiff = fC - fRSumSqr)) >= 0.0f) {
                if (fCDiff <= 0.0f) {
                    this.m_fContactTime = 0.0f;
                    this.m_kContactPoint.Add(this.m_rkSphere0.Center, this.m_rkSphere1.Center);
                    this.m_kContactPoint.Scale(0.5f);
                } else {
                    this.m_fContactTime = -(fB + (float)Math.sqrt(fDiscr)) / fA;
                    if (this.m_fContactTime < 0.0f) {
                        this.m_fContactTime = 0.0f;
                    } else if (this.m_fContactTime > fTMax) {
                        this.m_fContactTime = fTMax;
                    }
                    Vector3f kNewCDiff = new Vector3f(kVDiff);
                    kNewCDiff.Scale(this.m_fContactTime);
                    kNewCDiff.Add(kCDiff);
                    kNewCDiff.Scale(this.m_rkSphere0.Radius / fRSum);
                    Vector3f kScale = new Vector3f();
                    kScale.Scale(this.m_fContactTime, rkVelocity0);
                    kNewCDiff.Add(kScale);
                    kScale = null;
                    this.m_kContactPoint.Add(this.m_rkSphere0.Center, kNewCDiff);
                    kNewCDiff = null;
                }
                kVDiff = null;
                kCDiff = null;
                return true;
            }
            kVDiff = null;
            kCDiff = null;
            return false;
        }
        kVDiff = null;
        kCDiff = null;
        if (fC <= fRSumSqr) {
            this.m_fContactTime = 0.0f;
            this.m_kContactPoint.Add(this.m_rkSphere0.Center, this.m_rkSphere1.Center);
            this.m_kContactPoint.Scale(0.5f);
            return true;
        }
        return false;
    }

    public final Vector3f GetCenter() {
        return this.m_kCenter;
    }

    public final Vector3f GetContactPoint() {
        return this.m_kContactPoint;
    }

    public final Vector3f GetNormal() {
        return this.m_kNormal;
    }

    public final float GetRadius() {
        return this.m_fRadius;
    }

    public final Sphere3f GetSphere0() {
        return this.m_rkSphere0;
    }

    public final Sphere3f GetSphere1() {
        return this.m_rkSphere1;
    }

    public final Vector3f GetUAxis() {
        return this.m_kUAxis;
    }

    public final Vector3f GetVAxis() {
        return this.m_kVAxis;
    }

    @Override
    public boolean Test() {
        Vector3f kDiff = new Vector3f();
        kDiff.Sub(this.m_rkSphere1.Center, this.m_rkSphere0.Center);
        float fRSum = this.m_rkSphere0.Radius + this.m_rkSphere1.Radius;
        boolean bResult = kDiff.SquaredLength() <= fRSum * fRSum;
        kDiff = null;
        return bResult;
    }

    public boolean Test(float fTMax, Vector3f rkVelocity0, Vector3f rkVelocity1) {
        float fB;
        Vector3f kVDiff = new Vector3f();
        kVDiff.Sub(rkVelocity1, rkVelocity0);
        float fA = kVDiff.SquaredLength();
        Vector3f kCDiff = new Vector3f();
        kCDiff.Sub(this.m_rkSphere1.Center, this.m_rkSphere0.Center);
        float fC = kCDiff.SquaredLength();
        float fRSum = this.m_rkSphere0.Radius + this.m_rkSphere1.Radius;
        float fRSumSqr = fRSum * fRSum;
        if (fA > 0.0f && (fB = kCDiff.Dot(kVDiff)) <= 0.0f) {
            if (-fTMax * fA <= fB) {
                return fA * fC - fB * fB <= fA * fRSumSqr;
            }
            return fTMax * (fTMax * fA + 2.0f * fB) + fC <= fRSumSqr;
        }
        kVDiff = null;
        kCDiff = null;
        return fC <= fRSumSqr;
    }
}

