/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class Box3f
implements Serializable {
    private static final long serialVersionUID = 8811062530972135156L;
    public Vector3f Center;
    public Vector3f[] Axis = new Vector3f[3];
    public float[] Extent = new float[3];

    public Box3f() {
    }

    public Box3f(Vector3f rkCenter, Vector3f rkAxis0, Vector3f rkAxis1, Vector3f rkAxis2, float fExtent0, float fExtent1, float fExtent2) {
        this.Center = new Vector3f(rkCenter);
        this.Axis[0] = new Vector3f(rkAxis0);
        this.Axis[1] = new Vector3f(rkAxis1);
        this.Axis[2] = new Vector3f(rkAxis2);
        this.Extent[0] = fExtent0;
        this.Extent[1] = fExtent1;
        this.Extent[2] = fExtent2;
    }

    public Box3f(Vector3f rkCenter, Vector3f[] akAxis, float[] afExtent) {
        this.Center = new Vector3f(rkCenter);
        for (int i = 0; i < 3; ++i) {
            this.Axis[i] = new Vector3f(akAxis[i]);
            this.Extent[i] = afExtent[i];
        }
    }

    public void ComputeVertices(Vector3f[] akVertex) {
        int i;
        Vector3f[] akEAxis = new Vector3f[3];
        for (i = 0; i < 3; ++i) {
            akEAxis[i] = new Vector3f();
            akEAxis[i].Scale(this.Extent[i], this.Axis[i]);
        }
        for (i = 0; i < akVertex.length; ++i) {
            akVertex[i] = new Vector3f();
        }
        akVertex[0].Sub(this.Center, akEAxis[0]);
        akVertex[0].Sub(akEAxis[1]);
        akVertex[0].Sub(akEAxis[2]);
        akVertex[1].Add(this.Center, akEAxis[0]);
        akVertex[1].Sub(akEAxis[1]);
        akVertex[1].Sub(akEAxis[2]);
        akVertex[2].Add(this.Center, akEAxis[0]);
        akVertex[2].Add(akEAxis[1]);
        akVertex[2].Sub(akEAxis[2]);
        akVertex[3].Sub(this.Center, akEAxis[0]);
        akVertex[3].Add(akEAxis[1]);
        akVertex[3].Sub(akEAxis[2]);
        akVertex[4].Sub(this.Center, akEAxis[0]);
        akVertex[4].Sub(akEAxis[1]);
        akVertex[4].Add(akEAxis[2]);
        akVertex[5].Add(this.Center, akEAxis[0]);
        akVertex[5].Sub(akEAxis[1]);
        akVertex[5].Add(akEAxis[2]);
        akVertex[6].Add(this.Center, akEAxis[0]);
        akVertex[6].Add(akEAxis[1]);
        akVertex[6].Add(akEAxis[2]);
        akVertex[7].Sub(this.Center, akEAxis[0]);
        akVertex[7].Add(akEAxis[1]);
        akVertex[7].Add(akEAxis[2]);
    }

    public void dispose() {
        this.Center = null;
        this.Axis[0] = null;
        this.Axis[1] = null;
        this.Axis[2] = null;
        this.Extent = null;
    }
}

