/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import java.io.Serializable;

public class ColorRGBA
implements Serializable {
    private static final long serialVersionUID = -8079612858626573047L;
    public static final ColorRGBA BLACK = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    public static final ColorRGBA WHITE = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    public static final ColorRGBA INVALID = new ColorRGBA(-1.0f, -1.0f, -1.0f, 1.0f);
    public float R = 0.0f;
    public float G = 0.0f;
    public float B = 0.0f;
    public float A = 1.0f;

    public ColorRGBA() {
    }

    public ColorRGBA(ColorRGBA rkC) {
        this.R = rkC.R;
        this.G = rkC.G;
        this.B = rkC.B;
        this.A = rkC.A;
    }

    public ColorRGBA(float fR, float fG, float fB, float fA) {
        this.R = fR;
        this.G = fG;
        this.B = fB;
        this.A = fA;
    }

    public void Clamp() {
        if (this.R > 1.0f) {
            this.R = 1.0f;
        } else if (this.R < 0.0f) {
            this.R = 0.0f;
        }
        if (this.G > 1.0f) {
            this.G = 1.0f;
        } else if (this.G < 0.0f) {
            this.G = 0.0f;
        }
        if (this.B > 1.0f) {
            this.B = 1.0f;
        } else if (this.B < 0.0f) {
            this.B = 0.0f;
        }
        if (this.A > 1.0f) {
            this.A = 1.0f;
        } else if (this.A < 0.0f) {
            this.A = 0.0f;
        }
    }

    public void Copy(ColorRGBA rkC) {
        this.R = rkC.R;
        this.G = rkC.G;
        this.A = rkC.A;
        this.B = rkC.B;
    }

    public boolean equals(Object kObject) {
        ColorRGBA kV = (ColorRGBA)kObject;
        return this.R == kV.R && this.G == kV.G && this.B == kV.B && this.A == kV.A;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.R) + Float.floatToIntBits(this.G) + Float.floatToIntBits(this.B) + Float.floatToIntBits(this.A);
    }

    public void ScaleByMax() {
        float fMax = this.R;
        if (this.G > fMax) {
            fMax = this.G;
        }
        if (this.B > fMax) {
            fMax = this.B;
        }
        if (fMax > 1.0f) {
            float fInvMax = 1.0f / fMax;
            this.R *= fInvMax;
            this.G *= fInvMax;
            this.B *= fInvMax;
        }
    }

    public void Set(float fR, float fG, float fB, float fA) {
        this.R = fR;
        this.G = fG;
        this.B = fB;
        this.A = fA;
    }
}

