/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import java.io.Serializable;
import java.util.Random;

public final class Mathf
implements Serializable {
    private static final long serialVersionUID = -8318278131022236645L;
    public static final float ZERO_TOLERANCE = 1.0E-6f;
    public static final float TWO_PI = (float)Math.PI * 2;
    public static final float HALF_PI = 1.5707964f;
    public static final float INV_PI = 0.31830987f;
    public static final float DEG_TO_RAD = (float)Math.PI / 180;
    public static final float SQRT2 = (float)Math.sqrt(2.0);
    public static final float EPSILON = 1.1920929E-7f;
    public static final float RAD_TO_DEG = 57.295776f;
    public static final float LN_2 = (float)Math.log(2.0);
    public static final float LN_10 = (float)Math.log(10.0);
    public static final float INV_LN_2 = 1.0f / LN_2;
    public static final float INV_LN_10 = 1.0f / LN_10;

    public static float InvSqrt(float fValue) {
        return (float)(1.0 / Math.sqrt(fValue));
    }

    public static float Log2(float fValue) {
        return (float)((double)INV_LN_2 * Math.log(fValue));
    }

    public static float SymmetricRandom() {
        Random kRand = new Random();
        double dRatio = kRand.nextDouble();
        return (float)(2.0 * dRatio - 1.0);
    }

    public static float UnitRandom() {
        Random kRand = new Random();
        double dRatio = kRand.nextDouble();
        return (float)dRatio;
    }
}

