/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import WildMagic.LibFoundation.Mathematics.Mathf;
import WildMagic.LibFoundation.Mathematics.Vector2f;
import java.io.Serializable;

public class Matrix2f
implements Serializable {
    private static final long serialVersionUID = -997568309332765950L;
    public static final Matrix2f ZERO = new Matrix2f(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Matrix2f IDENTITY = new Matrix2f(1.0f, 0.0f, 0.0f, 1.0f);
    public float M00 = 0.0f;
    public float M01 = 0.0f;
    public float M10 = 0.0f;
    public float M11 = 0.0f;

    public Matrix2f() {
        this.MakeZero();
    }

    public Matrix2f(boolean bZero) {
        if (bZero) {
            this.MakeZero();
        } else {
            this.MakeIdentity();
        }
    }

    public Matrix2f(float fAngle) {
        this.FromAngle(fAngle);
    }

    public Matrix2f(float fM00, float fM11) {
        this.MakeDiagonal(fM00, fM11);
    }

    public Matrix2f(float fM00, float fM01, float fM10, float fM11) {
        this.M00 = fM00;
        this.M01 = fM01;
        this.M10 = fM10;
        this.M11 = fM11;
    }

    public Matrix2f(float[] afEntry, boolean bRowMajor) {
        if (bRowMajor) {
            this.M00 = afEntry[0];
            this.M01 = afEntry[1];
            this.M10 = afEntry[2];
            this.M11 = afEntry[3];
        } else {
            this.M00 = afEntry[0];
            this.M01 = afEntry[2];
            this.M10 = afEntry[1];
            this.M11 = afEntry[3];
        }
    }

    public Matrix2f(Matrix2f rkM) {
        this.M00 = rkM.M00;
        this.M01 = rkM.M01;
        this.M10 = rkM.M10;
        this.M11 = rkM.M11;
    }

    public Matrix2f(Vector2f rkU, Vector2f rkV) {
        this.MakeTensorProduct(rkU, rkV);
    }

    public Matrix2f(Vector2f rkU, Vector2f rkV, boolean bColumns) {
        if (bColumns) {
            this.M00 = rkU.X;
            this.M01 = rkV.X;
            this.M10 = rkU.Y;
            this.M11 = rkV.Y;
        } else {
            this.M00 = rkU.X;
            this.M01 = rkU.Y;
            this.M10 = rkV.X;
            this.M11 = rkV.Y;
        }
    }

    public Matrix2f(Vector2f[] akV, boolean bColumns) {
        if (bColumns) {
            this.M00 = akV[0].X;
            this.M01 = akV[1].X;
            this.M10 = akV[0].Y;
            this.M11 = akV[1].Y;
        } else {
            this.M00 = akV[0].X;
            this.M01 = akV[0].Y;
            this.M10 = akV[1].X;
            this.M11 = akV[1].Y;
        }
    }

    public final void Add(float fM00, float fM01, float fM10, float fM11) {
        this.M00 += fM00;
        this.M01 += fM01;
        this.M10 += fM10;
        this.M11 += fM11;
    }

    public void Adjoint() {
        this.Set(this.M11, -this.M01, -this.M10, this.M00);
    }

    public void Copy(Matrix2f rkM) {
        this.M00 = rkM.M00;
        this.M01 = rkM.M01;
        this.M10 = rkM.M10;
        this.M11 = rkM.M11;
    }

    public float Determinant() {
        return this.M00 * this.M11 - this.M01 * this.M10;
    }

    public void EigenDecomposition(Matrix2f rkRot, Matrix2f rkDiag) {
        float fSin;
        float fCos;
        float fTrace = this.M00 + this.M11;
        float fDiff = this.M00 - this.M11;
        float fDiscr = (float)Math.sqrt(fDiff * fDiff + 4.0f * this.M01 * this.M01);
        float fEVal0 = 0.5f * (fTrace - fDiscr);
        float fEVal1 = 0.5f * (fTrace + fDiscr);
        rkDiag.MakeDiagonal(fEVal0, fEVal1);
        if (fDiff >= 0.0f) {
            fCos = this.M01;
            fSin = fEVal0 - this.M00;
        } else {
            fCos = fEVal0 - this.M11;
            fSin = this.M01;
        }
        float fTmp = Mathf.InvSqrt(fCos * fCos + fSin * fSin);
        rkRot.M00 = fCos *= fTmp;
        rkRot.M01 = -(fSin *= fTmp);
        rkRot.M10 = fSin;
        rkRot.M11 = fCos;
    }

    public void FromAngle(float fAngle) {
        this.M00 = (float)Math.cos(fAngle);
        this.M10 = (float)Math.sin(fAngle);
        this.M01 = -this.M10;
        this.M11 = this.M00;
    }

    public final float Get(int iIndex) {
        switch (iIndex) {
            case 0: {
                return this.M00;
            }
            case 1: {
                return this.M01;
            }
            case 2: {
                return this.M10;
            }
            case 3: {
                return this.M11;
            }
        }
        return -1.0f;
    }

    public final float Get(int iRow, int iCol) {
        switch (iRow) {
            case 0: {
                switch (iCol) {
                    case 0: {
                        return this.M00;
                    }
                    case 1: {
                        return this.M01;
                    }
                }
                break;
            }
            case 1: {
                switch (iCol) {
                    case 0: {
                        return this.M10;
                    }
                    case 1: {
                        return this.M11;
                    }
                }
            }
        }
        return -1.0f;
    }

    public void GetColumn(int iCol, Vector2f kResult) {
        switch (iCol) {
            case 0: {
                kResult.Set(this.M00, this.M10);
                break;
            }
            case 1: {
                kResult.Set(this.M01, this.M11);
            }
        }
    }

    public void GetColumnMajor(float[] afCMajor) {
        afCMajor[0] = this.M00;
        afCMajor[1] = this.M10;
        afCMajor[2] = this.M01;
        afCMajor[3] = this.M11;
    }

    public void GetData(float[] afData) {
        afData[0] = this.M00;
        afData[1] = this.M01;
        afData[2] = this.M10;
        afData[3] = this.M11;
    }

    public void Inverse() {
        float fDet = this.M00 * this.M11 - this.M01 * this.M10;
        if (Math.abs(fDet) <= 1.0E-6f) {
            this.Copy(ZERO);
            return;
        }
        float fInvDet = 1.0f / fDet;
        this.Set(this.M11 * fInvDet, -this.M01 * fInvDet, -this.M10 * fInvDet, this.M00 * fInvDet);
    }

    public void Inverse(Matrix2f kM) {
        this.Copy(kM);
        this.Inverse();
    }

    public void MakeDiagonal(float fM00, float fM11) {
        this.M00 = fM00;
        this.M01 = 0.0f;
        this.M10 = 0.0f;
        this.M11 = fM11;
    }

    public void MakeIdentity() {
        this.M00 = 1.0f;
        this.M01 = 0.0f;
        this.M10 = 0.0f;
        this.M11 = 1.0f;
    }

    public void MakeTensorProduct(Vector2f rkU, Vector2f rkV) {
        this.M00 = rkU.X * rkV.X;
        this.M01 = rkU.X * rkV.Y;
        this.M10 = rkU.Y * rkV.X;
        this.M11 = rkU.Y * rkV.Y;
    }

    public void MakeZero() {
        this.M00 = 0.0f;
        this.M01 = 0.0f;
        this.M10 = 0.0f;
        this.M11 = 0.0f;
    }

    public void Mult(Matrix2f kM) {
        this.Set(this.M00 * kM.M00 + this.M01 * kM.M10, this.M00 * kM.M01 + this.M01 * kM.M11, this.M10 * kM.M00 + this.M11 * kM.M10, this.M10 * kM.M01 + this.M11 * kM.M11);
    }

    public void Mult(Matrix2f kM1, Matrix2f kM2) {
        this.Set(kM1.M00 * kM2.M00 + kM1.M01 * kM2.M10, kM1.M00 * kM2.M01 + kM1.M01 * kM2.M11, kM1.M10 * kM2.M00 + kM1.M11 * kM2.M10, kM1.M10 * kM2.M01 + kM1.M11 * kM2.M11);
    }

    public void Mult(Vector2f kV, Vector2f kResult) {
        float fX = this.M00 * kV.X + this.M01 * kV.Y;
        float fY = this.M10 * kV.X + this.M11 * kV.Y;
        kResult.Set(fX, fY);
    }

    public void MultLeft(Matrix2f kM) {
        this.Set(kM.M00 * this.M00 + kM.M01 * this.M10, kM.M00 * this.M01 + kM.M01 * this.M11, kM.M10 * this.M00 + kM.M11 * this.M10, kM.M10 * this.M01 + kM.M11 * this.M11);
    }

    public void MultLeft(Vector2f kV, Vector2f kResult) {
        kResult.Set(kV.X * this.M00 + kV.Y * this.M10, kV.X * this.M01 + kV.Y * this.M11);
    }

    public void MultRight(Vector2f kV, Vector2f kResult) {
        float fX = this.M00 * kV.X + this.M01 * kV.Y;
        float fY = this.M10 * kV.X + this.M11 * kV.Y;
        kResult.Set(fX, fY);
    }

    public void Orthonormalize() {
        float fInvLength = Mathf.InvSqrt(this.M00 * this.M00 + this.M10 * this.M10);
        this.M00 *= fInvLength;
        this.M10 *= fInvLength;
        float fDot0 = this.M00 * this.M01 + this.M10 * this.M11;
        this.M01 -= fDot0 * this.M00;
        this.M11 -= fDot0 * this.M10;
        fInvLength = Mathf.InvSqrt(this.M01 * this.M01 + this.M11 * this.M11);
        this.M01 *= fInvLength;
        this.M11 *= fInvLength;
    }

    public float QForm(Vector2f rkU, Vector2f rkV) {
        Vector2f kResult = new Vector2f();
        this.Mult(rkV, kResult);
        return rkU.Dot(kResult);
    }

    public void Scale(float fScalar) {
        this.Set(fScalar * this.M00, fScalar * this.M01, fScalar * this.M10, fScalar * this.M11);
    }

    public final void Set(float fM00, float fM01, float fM10, float fM11) {
        this.M00 = fM00;
        this.M01 = fM01;
        this.M10 = fM10;
        this.M11 = fM11;
    }

    public void Set(int iIndex, float fValue) {
        switch (iIndex) {
            case 0: {
                this.M00 = fValue;
                break;
            }
            case 1: {
                this.M01 = fValue;
                break;
            }
            case 2: {
                this.M10 = fValue;
                break;
            }
            case 3: {
                this.M11 = fValue;
            }
        }
    }

    public final void Set(int iRow, int iCol, float fValue) {
        block0 : switch (iRow) {
            case 0: {
                switch (iCol) {
                    case 0: {
                        this.M00 = fValue;
                        break;
                    }
                    case 1: {
                        this.M01 = fValue;
                    }
                }
                break;
            }
            case 1: {
                switch (iCol) {
                    case 0: {
                        this.M10 = fValue;
                        break block0;
                    }
                    case 1: {
                        this.M11 = fValue;
                    }
                }
            }
        }
    }

    public void SetColumn(int iCol, Vector2f kV) {
        switch (iCol) {
            case 0: {
                this.M00 = kV.X;
                this.M10 = kV.Y;
                break;
            }
            case 1: {
                this.M01 = kV.X;
                this.M11 = kV.Y;
            }
        }
    }

    public void TimesTranspose(Matrix2f kM) {
        this.Set(this.M00 * kM.M00 + this.M01 * kM.M01, this.M00 * kM.M10 + this.M01 * kM.M11, this.M10 * kM.M00 + this.M11 * kM.M01, this.M10 * kM.M10 + this.M11 * kM.M11);
    }

    public float ToAngle() {
        float rfAngle = (float)Math.atan2(this.M11, this.M00);
        return rfAngle;
    }

    public String toString() {
        return new String(this.M00 + " " + this.M01 + " " + this.M10 + " " + this.M11);
    }

    public void Transpose() {
        this.Set(this.M00, this.M10, this.M01, this.M11);
    }

    public void TransposeTimes(Matrix2f kM) {
        this.Set(this.M00 * kM.M00 + this.M10 * kM.M10, this.M00 * kM.M01 + this.M10 * kM.M11, this.M01 * kM.M00 + this.M11 * kM.M10, this.M01 * kM.M01 + this.M11 * kM.M11);
    }
}

