/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import WildMagic.LibFoundation.Mathematics.Mathf;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class Matrix3f
implements Serializable {
    private static final long serialVersionUID = 5434866135349279793L;
    public static final Matrix3f ZERO = new Matrix3f(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public static final Matrix3f IDENTITY = new Matrix3f(1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    public float M00 = 0.0f;
    public float M01 = 0.0f;
    public float M02 = 0.0f;
    public float M10 = 0.0f;
    public float M11 = 0.0f;
    public float M12 = 0.0f;
    public float M20 = 0.0f;
    public float M21 = 0.0f;
    public float M22 = 0.0f;

    public Matrix3f() {
        this.MakeZero();
    }

    public Matrix3f(boolean bZero) {
        if (bZero) {
            this.MakeZero();
        } else {
            this.MakeIdentity();
        }
    }

    public Matrix3f(float fM00, float fM11, float fM22) {
        this.MakeDiagonal(fM00, fM11, fM22);
    }

    public Matrix3f(float fM00, float fM01, float fM02, float fM10, float fM11, float fM12, float fM20, float fM21, float fM22) {
        this.M00 = fM00;
        this.M01 = fM01;
        this.M02 = fM02;
        this.M10 = fM10;
        this.M11 = fM11;
        this.M12 = fM12;
        this.M20 = fM20;
        this.M21 = fM21;
        this.M22 = fM22;
    }

    public Matrix3f(float[] afEntry, boolean bRowMajor) {
        if (bRowMajor) {
            this.M00 = afEntry[0];
            this.M01 = afEntry[1];
            this.M02 = afEntry[2];
            this.M10 = afEntry[3];
            this.M11 = afEntry[4];
            this.M12 = afEntry[5];
            this.M20 = afEntry[6];
            this.M21 = afEntry[7];
            this.M22 = afEntry[8];
        } else {
            this.M00 = afEntry[0];
            this.M01 = afEntry[3];
            this.M02 = afEntry[6];
            this.M10 = afEntry[1];
            this.M11 = afEntry[4];
            this.M12 = afEntry[7];
            this.M20 = afEntry[2];
            this.M21 = afEntry[5];
            this.M22 = afEntry[8];
        }
    }

    public Matrix3f(Matrix3f rkM) {
        this.M00 = rkM.M00;
        this.M01 = rkM.M01;
        this.M02 = rkM.M02;
        this.M10 = rkM.M10;
        this.M11 = rkM.M11;
        this.M12 = rkM.M12;
        this.M20 = rkM.M20;
        this.M21 = rkM.M21;
        this.M22 = rkM.M22;
    }

    public Matrix3f(Vector3f rkAxis, float fAngle) {
        this.FromAxisAngle(rkAxis, fAngle);
    }

    public Matrix3f(Vector3f rkU, Vector3f rkV) {
        this.MakeTensorProduct(rkU, rkV);
    }

    public Matrix3f(Vector3f rkU, Vector3f rkV, Vector3f rkW, boolean bColumns) {
        if (bColumns) {
            this.M00 = rkU.X;
            this.M01 = rkV.X;
            this.M02 = rkW.X;
            this.M10 = rkU.Y;
            this.M11 = rkV.Y;
            this.M12 = rkW.Y;
            this.M20 = rkU.Z;
            this.M21 = rkV.Z;
            this.M22 = rkW.Z;
        } else {
            this.M00 = rkU.X;
            this.M01 = rkU.Y;
            this.M02 = rkU.Z;
            this.M10 = rkV.X;
            this.M11 = rkV.Y;
            this.M12 = rkV.Z;
            this.M20 = rkW.X;
            this.M21 = rkW.Y;
            this.M22 = rkW.Z;
        }
    }

    public Matrix3f(Vector3f[] akV, boolean bColumns) {
        if (bColumns) {
            this.M00 = akV[0].X;
            this.M01 = akV[1].X;
            this.M02 = akV[2].X;
            this.M10 = akV[0].Y;
            this.M11 = akV[1].Y;
            this.M12 = akV[2].Y;
            this.M20 = akV[0].Z;
            this.M21 = akV[1].Z;
            this.M22 = akV[2].Z;
        } else {
            this.M00 = akV[0].X;
            this.M01 = akV[0].Y;
            this.M02 = akV[0].Z;
            this.M10 = akV[1].X;
            this.M11 = akV[1].Y;
            this.M12 = akV[1].Z;
            this.M20 = akV[2].X;
            this.M21 = akV[2].Y;
            this.M22 = akV[2].Z;
        }
    }

    public static boolean EigenDecomposition(Matrix3f rkRot, Matrix3f rkDiag) {
        int i;
        float fSave;
        float[] afDiag = new float[3];
        float[] afSubd = new float[2];
        boolean bReflection = Matrix3f.Tridiagonalize(rkRot, afDiag, afSubd);
        boolean bConverged = Matrix3f.QLAlgorithm(rkRot, afDiag, afSubd);
        if (!bConverged) {
            return false;
        }
        if (afDiag[1] < afDiag[0]) {
            fSave = afDiag[0];
            afDiag[0] = afDiag[1];
            afDiag[1] = fSave;
            for (i = 0; i < 3; ++i) {
                fSave = rkRot.Get(i, 0);
                rkRot.Set(i, 0, rkRot.Get(i, 1));
                rkRot.Set(i, 1, fSave);
            }
            boolean bl = bReflection = !bReflection;
        }
        if (afDiag[2] < afDiag[1]) {
            fSave = afDiag[1];
            afDiag[1] = afDiag[2];
            afDiag[2] = fSave;
            for (i = 0; i < 3; ++i) {
                fSave = rkRot.Get(i, 1);
                rkRot.Set(i, 1, rkRot.Get(i, 2));
                rkRot.Set(i, 2, fSave);
            }
            boolean bl = bReflection = !bReflection;
        }
        if (afDiag[1] < afDiag[0]) {
            fSave = afDiag[0];
            afDiag[0] = afDiag[1];
            afDiag[1] = fSave;
            for (i = 0; i < 3; ++i) {
                fSave = rkRot.Get(i, 0);
                rkRot.Set(i, 0, rkRot.Get(i, 1));
                rkRot.Set(i, 1, fSave);
            }
            bReflection = !bReflection;
        }
        rkDiag.MakeDiagonal(afDiag[0], afDiag[1], afDiag[2]);
        if (bReflection) {
            rkRot.Set(0, 2, -rkRot.Get(0, 2));
            rkRot.Set(1, 2, -rkRot.Get(1, 2));
            rkRot.Set(2, 2, -rkRot.Get(2, 2));
        }
        afDiag = null;
        afSubd = null;
        return true;
    }

    private static boolean QLAlgorithm(Matrix3f rkRot, float[] afDiag, float[] afSubd) {
        int iMax = 32;
        for (int i = 0; i < 32; ++i) {
            float fTmp;
            float fSin;
            float fCos;
            float fSum = Math.abs(afDiag[0]) + Math.abs(afDiag[1]);
            if (Math.abs(afSubd[0]) + fSum == fSum) {
                fSum = afDiag[1] + afDiag[2];
                float fDiff = afDiag[1] - afDiag[2];
                float fDiscr = (float)Math.sqrt(fDiff * fDiff + 4.0f * afSubd[1] * afSubd[1]);
                float fEValue0 = 0.5f * (fSum - fDiscr);
                float fEValue1 = 0.5f * (fSum + fDiscr);
                if (fDiff >= 0.0f) {
                    fCos = afSubd[1];
                    fSin = afDiag[1] - fEValue0;
                } else {
                    fCos = afDiag[2] - fEValue0;
                    fSin = afSubd[1];
                }
                fTmp = Mathf.InvSqrt(fCos * fCos + fSin * fSin);
                fCos *= fTmp;
                fSin *= fTmp;
                fTmp = rkRot.M02;
                rkRot.M02 = fSin * rkRot.M01 + fCos * fTmp;
                rkRot.M01 = fCos * rkRot.M01 - fSin * fTmp;
                fTmp = rkRot.M12;
                rkRot.M12 = fSin * rkRot.M11 + fCos * fTmp;
                rkRot.M11 = fCos * rkRot.M11 - fSin * fTmp;
                fTmp = rkRot.M22;
                rkRot.M22 = fSin * rkRot.M21 + fCos * fTmp;
                rkRot.M21 = fCos * rkRot.M21 - fSin * fTmp;
                afDiag[1] = fEValue0;
                afDiag[2] = fEValue1;
                afSubd[0] = 0.0f;
                afSubd[1] = 0.0f;
                return true;
            }
            fSum = Math.abs(afDiag[1]) + Math.abs(afDiag[2]);
            if (Math.abs(afSubd[1]) + fSum == fSum) {
                fSum = afDiag[0] + afDiag[1];
                float fDiff = afDiag[0] - afDiag[1];
                float fDiscr = (float)Math.sqrt(fDiff * fDiff + 4.0f * afSubd[0] * afSubd[0]);
                float fEValue0 = 0.5f * (fSum - fDiscr);
                float fEValue1 = 0.5f * (fSum + fDiscr);
                if (fDiff >= 0.0f) {
                    fCos = afSubd[0];
                    fSin = afDiag[0] - fEValue0;
                } else {
                    fCos = afDiag[1] - fEValue0;
                    fSin = afSubd[0];
                }
                fTmp = Mathf.InvSqrt(fCos * fCos + fSin * fSin);
                fCos *= fTmp;
                fSin *= fTmp;
                fTmp = rkRot.M01;
                rkRot.M01 = fSin * rkRot.M00 + fCos * fTmp;
                rkRot.M00 = fCos * rkRot.M00 - fSin * fTmp;
                fTmp = rkRot.M11;
                rkRot.M11 = fSin * rkRot.M10 + fCos * fTmp;
                rkRot.M10 = fCos * rkRot.M10 - fSin * fTmp;
                fTmp = rkRot.M21;
                rkRot.M21 = fSin * rkRot.M20 + fCos * fTmp;
                rkRot.M20 = fCos * rkRot.M20 - fSin * fTmp;
                afDiag[0] = fEValue0;
                afDiag[1] = fEValue1;
                afSubd[0] = 0.0f;
                afSubd[1] = 0.0f;
                return true;
            }
            float fRatio = (afDiag[1] - afDiag[0]) / (2.0f * afSubd[0]);
            float fRoot = (float)Math.sqrt(1.0f + fRatio * fRatio);
            float fB = afSubd[1];
            float fA = afDiag[2] - afDiag[0];
            fA = (double)fRatio >= 0.0 ? (fA += afSubd[0] / (fRatio + fRoot)) : (fA += afSubd[0] / (fRatio - fRoot));
            if (Math.abs(fB) >= Math.abs(fA)) {
                fRatio = fA / fB;
                fSin = Mathf.InvSqrt(1.0f + fRatio * fRatio);
                fCos = fRatio * fSin;
            } else {
                fRatio = fB / fA;
                fCos = Mathf.InvSqrt(1.0f + fRatio * fRatio);
                fSin = fRatio * fCos;
            }
            fTmp = rkRot.M02;
            rkRot.M02 = fSin * rkRot.M01 + fCos * fTmp;
            rkRot.M01 = fCos * rkRot.M01 - fSin * fTmp;
            fTmp = rkRot.M12;
            rkRot.M12 = fSin * rkRot.M11 + fCos * fTmp;
            rkRot.M11 = fCos * rkRot.M11 - fSin * fTmp;
            fTmp = rkRot.M22;
            rkRot.M22 = fSin * rkRot.M21 + fCos * fTmp;
            rkRot.M21 = fCos * rkRot.M21 - fSin * fTmp;
            float fTmp0 = (afDiag[1] - afDiag[2]) * fSin + 2.0f * afSubd[1] * fCos;
            float fTmp1 = fCos * afSubd[0];
            fB = fSin * afSubd[0];
            fA = fCos * fTmp0 - afSubd[1];
            fTmp0 *= fSin;
            if (Math.abs(fB) >= Math.abs(fA)) {
                fRatio = fA / fB;
                fRoot = (float)Math.sqrt(1.0f + fRatio * fRatio);
                afSubd[1] = fB * fRoot;
                fSin = 1.0f / fRoot;
                fCos = fRatio * fSin;
            } else {
                fRatio = fB / fA;
                fRoot = (float)Math.sqrt(1.0f + fRatio * fRatio);
                afSubd[1] = fA * fRoot;
                fCos = 1.0f / fRoot;
                fSin = fRatio * fCos;
            }
            fTmp = rkRot.M01;
            rkRot.M01 = fSin * rkRot.M00 + fCos * fTmp;
            rkRot.M00 = fCos * rkRot.M00 - fSin * fTmp;
            fTmp = rkRot.M11;
            rkRot.M11 = fSin * rkRot.M10 + fCos * fTmp;
            rkRot.M10 = fCos * rkRot.M10 - fSin * fTmp;
            fTmp = rkRot.M21;
            rkRot.M21 = fSin * rkRot.M20 + fCos * fTmp;
            rkRot.M20 = fCos * rkRot.M20 - fSin * fTmp;
            float fTmp2 = afDiag[1] - fTmp0;
            afDiag[2] = afDiag[2] + fTmp0;
            fTmp0 = (afDiag[0] - fTmp2) * fSin + 2.0f * fTmp1 * fCos;
            afSubd[0] = fCos * fTmp0 - fTmp1;
            afDiag[1] = fTmp2 + (fTmp0 *= fSin);
            afDiag[0] = afDiag[0] - fTmp0;
        }
        return false;
    }

    private static boolean Tridiagonalize(Matrix3f rkRot, float[] afDiag, float[] afSubd) {
        float fM00 = rkRot.M00;
        float fM01 = rkRot.M01;
        float fM02 = rkRot.M02;
        float fM11 = rkRot.M11;
        float fM12 = rkRot.M12;
        float fM22 = rkRot.M22;
        afDiag[0] = fM00;
        if (Math.abs(fM02) >= 1.0E-6f) {
            afSubd[0] = (float)Math.sqrt(fM01 * fM01 + fM02 * fM02);
            float fInvLength = 1.0f / afSubd[0];
            float fTmp = 2.0f * (fM01 *= fInvLength) * fM12 + (fM02 *= fInvLength) * (fM22 - fM11);
            afDiag[1] = fM11 + fM02 * fTmp;
            afDiag[2] = fM22 - fM02 * fTmp;
            afSubd[1] = fM12 - fM01 * fTmp;
            rkRot.M00 = 1.0f;
            rkRot.M01 = 0.0f;
            rkRot.M02 = 0.0f;
            rkRot.M10 = 0.0f;
            rkRot.M11 = fM01;
            rkRot.M12 = fM02;
            rkRot.M20 = 0.0f;
            rkRot.M21 = fM02;
            rkRot.M22 = -fM01;
            return true;
        }
        afDiag[1] = fM11;
        afDiag[2] = fM22;
        afSubd[0] = fM01;
        afSubd[1] = fM12;
        rkRot.M00 = 1.0f;
        rkRot.M01 = 0.0f;
        rkRot.M02 = 0.0f;
        rkRot.M10 = 0.0f;
        rkRot.M11 = 1.0f;
        rkRot.M12 = 0.0f;
        rkRot.M20 = 0.0f;
        rkRot.M21 = 0.0f;
        rkRot.M22 = 1.0f;
        return false;
    }

    public final void Add(float fM00, float fM01, float fM02, float fM10, float fM11, float fM12, float fM20, float fM21, float fM22) {
        this.M00 += fM00;
        this.M01 += fM01;
        this.M02 += fM02;
        this.M10 += fM10;
        this.M11 += fM11;
        this.M12 += fM12;
        this.M20 += fM20;
        this.M21 += fM21;
        this.M22 += fM22;
    }

    public final void Add(Matrix3f kMat) {
        this.M00 += kMat.M00;
        this.M01 += kMat.M01;
        this.M02 += kMat.M02;
        this.M10 += kMat.M10;
        this.M11 += kMat.M11;
        this.M12 += kMat.M12;
        this.M20 += kMat.M20;
        this.M21 += kMat.M21;
        this.M22 += kMat.M22;
    }

    public final void Add(Matrix3f kMat1, Matrix3f kMat2) {
        this.M00 = kMat1.M00 + kMat2.M00;
        this.M01 = kMat1.M01 + kMat2.M01;
        this.M02 = kMat1.M02 + kMat2.M02;
        this.M10 = kMat1.M10 + kMat2.M10;
        this.M11 = kMat1.M11 + kMat2.M11;
        this.M12 = kMat1.M12 + kMat2.M12;
        this.M20 = kMat1.M20 + kMat2.M20;
        this.M21 = kMat1.M21 + kMat2.M21;
        this.M22 = kMat1.M22 + kMat2.M22;
    }

    public void Adjoint() {
        this.Set(this.M11 * this.M22 - this.M12 * this.M21, this.M02 * this.M21 - this.M01 * this.M22, this.M01 * this.M12 - this.M02 * this.M11, this.M12 * this.M20 - this.M10 * this.M22, this.M00 * this.M22 - this.M02 * this.M20, this.M02 * this.M10 - this.M00 * this.M12, this.M10 * this.M21 - this.M11 * this.M20, this.M01 * this.M20 - this.M00 * this.M21, this.M00 * this.M11 - this.M01 * this.M10);
    }

    public void Copy(Matrix3f rkM) {
        this.M00 = rkM.M00;
        this.M01 = rkM.M01;
        this.M02 = rkM.M02;
        this.M10 = rkM.M10;
        this.M11 = rkM.M11;
        this.M12 = rkM.M12;
        this.M20 = rkM.M20;
        this.M21 = rkM.M21;
        this.M22 = rkM.M22;
    }

    public float Determinant() {
        float fCo00 = this.M11 * this.M22 - this.M12 * this.M21;
        float fCo10 = this.M12 * this.M20 - this.M10 * this.M22;
        float fCo20 = this.M10 * this.M21 - this.M11 * this.M20;
        float fDet = this.M00 * fCo00 + this.M01 * fCo10 + this.M02 * fCo20;
        return fDet;
    }

    public void DiagonalTimes(Vector3f kDiag) {
        this.Set(kDiag.X * this.M00, kDiag.X * this.M01, kDiag.X * this.M02, kDiag.Y * this.M10, kDiag.Y * this.M11, kDiag.Y * this.M12, kDiag.Z * this.M20, kDiag.Z * this.M21, kDiag.Z * this.M22);
    }

    public void FromAxisAngle(Vector3f rkAxis, float fAngle) {
        float fCos = (float)Math.cos(fAngle);
        float fSin = (float)Math.sin(fAngle);
        float fOneMinusCos = 1.0f - fCos;
        float fX2 = rkAxis.X * rkAxis.X;
        float fY2 = rkAxis.Y * rkAxis.Y;
        float fZ2 = rkAxis.Z * rkAxis.Z;
        float fXYM = rkAxis.X * rkAxis.Y * fOneMinusCos;
        float fXZM = rkAxis.X * rkAxis.Z * fOneMinusCos;
        float fYZM = rkAxis.Y * rkAxis.Z * fOneMinusCos;
        float fXSin = rkAxis.X * fSin;
        float fYSin = rkAxis.Y * fSin;
        float fZSin = rkAxis.Z * fSin;
        this.M00 = fX2 * fOneMinusCos + fCos;
        this.M01 = fXYM - fZSin;
        this.M02 = fXZM + fYSin;
        this.M10 = fXYM + fZSin;
        this.M11 = fY2 * fOneMinusCos + fCos;
        this.M12 = fYZM - fXSin;
        this.M20 = fXZM - fYSin;
        this.M21 = fYZM + fXSin;
        this.M22 = fZ2 * fOneMinusCos + fCos;
    }

    public final float Get(int iIndex) {
        switch (iIndex) {
            case 0: {
                return this.M00;
            }
            case 1: {
                return this.M01;
            }
            case 2: {
                return this.M02;
            }
            case 3: {
                return this.M10;
            }
            case 4: {
                return this.M11;
            }
            case 5: {
                return this.M12;
            }
            case 6: {
                return this.M20;
            }
            case 7: {
                return this.M21;
            }
            case 8: {
                return this.M22;
            }
        }
        return -1.0f;
    }

    public final float Get(int iRow, int iCol) {
        switch (iRow) {
            case 0: {
                switch (iCol) {
                    case 0: {
                        return this.M00;
                    }
                    case 1: {
                        return this.M01;
                    }
                    case 2: {
                        return this.M02;
                    }
                }
                break;
            }
            case 1: {
                switch (iCol) {
                    case 0: {
                        return this.M10;
                    }
                    case 1: {
                        return this.M11;
                    }
                    case 2: {
                        return this.M12;
                    }
                }
                break;
            }
            case 2: {
                switch (iCol) {
                    case 0: {
                        return this.M20;
                    }
                    case 1: {
                        return this.M21;
                    }
                    case 2: {
                        return this.M22;
                    }
                }
            }
        }
        return -1.0f;
    }

    public void GetColumn(int iCol, Vector3f kResult) {
        switch (iCol) {
            case 0: {
                kResult.Set(this.M00, this.M10, this.M20);
                break;
            }
            case 1: {
                kResult.Set(this.M01, this.M11, this.M21);
                break;
            }
            case 2: {
                kResult.Set(this.M02, this.M12, this.M22);
            }
        }
    }

    public void GetColumnMajor(float[] afCMajor) {
        afCMajor[0] = this.M00;
        afCMajor[1] = this.M10;
        afCMajor[2] = this.M20;
        afCMajor[3] = this.M01;
        afCMajor[4] = this.M11;
        afCMajor[5] = this.M21;
        afCMajor[6] = this.M02;
        afCMajor[7] = this.M12;
        afCMajor[8] = this.M22;
    }

    public void GetData(float[] afData) {
        for (int i = 0; i < afData.length; ++i) {
            afData[i] = 0.0f;
        }
        afData[0] = this.M00;
        afData[1] = this.M01;
        afData[2] = this.M02;
        afData[3] = this.M10;
        afData[4] = this.M11;
        afData[5] = this.M12;
        afData[6] = this.M20;
        afData[7] = this.M21;
        afData[8] = this.M22;
    }

    public void Inverse() {
        double inverse_M00 = this.M11 * this.M22 - this.M12 * this.M21;
        double inverse_M01 = this.M02 * this.M21 - this.M01 * this.M22;
        double inverse_M02 = this.M01 * this.M12 - this.M02 * this.M11;
        double inverse_M10 = this.M12 * this.M20 - this.M10 * this.M22;
        double inverse_M11 = this.M00 * this.M22 - this.M02 * this.M20;
        double inverse_M12 = this.M02 * this.M10 - this.M00 * this.M12;
        double inverse_M20 = this.M10 * this.M21 - this.M11 * this.M20;
        double inverse_M21 = this.M01 * this.M20 - this.M00 * this.M21;
        double inverse_M22 = this.M00 * this.M11 - this.M01 * this.M10;
        double fDet = (double)this.M00 * inverse_M00 + (double)this.M01 * inverse_M10 + (double)this.M02 * inverse_M20;
        if (Math.abs(fDet) <= (double)1.0E-6f) {
            this.Copy(ZERO);
        }
        double fInvDet = 1.0 / fDet;
        this.Set((float)(inverse_M00 *= fInvDet), (float)(inverse_M01 *= fInvDet), (float)(inverse_M02 *= fInvDet), (float)(inverse_M10 *= fInvDet), (float)(inverse_M11 *= fInvDet), (float)(inverse_M12 *= fInvDet), (float)(inverse_M20 *= fInvDet), (float)(inverse_M21 *= fInvDet), (float)(inverse_M22 *= fInvDet));
    }

    public void Inverse(Matrix3f kM) {
        this.Copy(kM);
        this.Inverse();
    }

    public void MakeDiagonal(float fM00, float fM11, float fM22) {
        this.M00 = fM00;
        this.M01 = 0.0f;
        this.M02 = 0.0f;
        this.M10 = 0.0f;
        this.M11 = fM11;
        this.M12 = 0.0f;
        this.M20 = 0.0f;
        this.M21 = 0.0f;
        this.M22 = fM22;
    }

    public void MakeIdentity() {
        this.M00 = 1.0f;
        this.M01 = 0.0f;
        this.M02 = 0.0f;
        this.M10 = 0.0f;
        this.M11 = 1.0f;
        this.M12 = 0.0f;
        this.M20 = 0.0f;
        this.M21 = 0.0f;
        this.M22 = 1.0f;
    }

    public void MakeTensorProduct(Vector3f rkU, Vector3f rkV) {
        this.M00 = rkU.X * rkV.X;
        this.M01 = rkU.X * rkV.Y;
        this.M02 = rkU.X * rkV.Z;
        this.M10 = rkU.Y * rkV.X;
        this.M11 = rkU.Y * rkV.Y;
        this.M12 = rkU.Y * rkV.Z;
        this.M20 = rkU.Z * rkV.X;
        this.M21 = rkU.Z * rkV.Y;
        this.M22 = rkU.Z * rkV.Z;
    }

    public void MakeZero() {
        this.M00 = 0.0f;
        this.M01 = 0.0f;
        this.M02 = 0.0f;
        this.M10 = 0.0f;
        this.M11 = 0.0f;
        this.M12 = 0.0f;
        this.M20 = 0.0f;
        this.M21 = 0.0f;
        this.M22 = 0.0f;
    }

    public void Mult(Matrix3f kM) {
        this.Set(this.M00 * kM.M00 + this.M01 * kM.M10 + this.M02 * kM.M20, this.M00 * kM.M01 + this.M01 * kM.M11 + this.M02 * kM.M21, this.M00 * kM.M02 + this.M01 * kM.M12 + this.M02 * kM.M22, this.M10 * kM.M00 + this.M11 * kM.M10 + this.M12 * kM.M20, this.M10 * kM.M01 + this.M11 * kM.M11 + this.M12 * kM.M21, this.M10 * kM.M02 + this.M11 * kM.M12 + this.M12 * kM.M22, this.M20 * kM.M00 + this.M21 * kM.M10 + this.M22 * kM.M20, this.M20 * kM.M01 + this.M21 * kM.M11 + this.M22 * kM.M21, this.M20 * kM.M02 + this.M21 * kM.M12 + this.M22 * kM.M22);
    }

    public void Mult(Matrix3f kM1, Matrix3f kM2) {
        this.Set(kM1.M00 * kM2.M00 + kM1.M01 * kM2.M10 + kM1.M02 * kM2.M20, kM1.M00 * kM2.M01 + kM1.M01 * kM2.M11 + kM1.M02 * kM2.M21, kM1.M00 * kM2.M02 + kM1.M01 * kM2.M12 + kM1.M02 * kM2.M22, kM1.M10 * kM2.M00 + kM1.M11 * kM2.M10 + kM1.M12 * kM2.M20, kM1.M10 * kM2.M01 + kM1.M11 * kM2.M11 + kM1.M12 * kM2.M21, kM1.M10 * kM2.M02 + kM1.M11 * kM2.M12 + kM1.M12 * kM2.M22, kM1.M20 * kM2.M00 + kM1.M21 * kM2.M10 + kM1.M22 * kM2.M20, kM1.M20 * kM2.M01 + kM1.M21 * kM2.M11 + kM1.M22 * kM2.M21, kM1.M20 * kM2.M02 + kM1.M21 * kM2.M12 + kM1.M22 * kM2.M22);
    }

    public void Mult(Vector3f kV, Vector3f kResult) {
        float fX = this.M00 * kV.X + this.M01 * kV.Y + this.M02 * kV.Z;
        float fY = this.M10 * kV.X + this.M11 * kV.Y + this.M12 * kV.Z;
        float fZ = this.M20 * kV.X + this.M21 * kV.Y + this.M22 * kV.Z;
        kResult.Set(fX, fY, fZ);
    }

    public void MultLeft(Matrix3f kM) {
        this.Set(kM.M00 * this.M00 + kM.M01 * this.M10 + kM.M02 * this.M20, kM.M00 * this.M01 + kM.M01 * this.M11 + kM.M02 * this.M21, kM.M00 * this.M02 + kM.M01 * this.M12 + kM.M02 * this.M22, kM.M10 * this.M00 + kM.M11 * this.M10 + kM.M12 * this.M20, kM.M10 * this.M01 + kM.M11 * this.M11 + kM.M12 * this.M21, kM.M10 * this.M02 + kM.M11 * this.M12 + kM.M12 * this.M22, kM.M20 * this.M00 + kM.M21 * this.M10 + kM.M22 * this.M20, kM.M20 * this.M01 + kM.M21 * this.M11 + kM.M22 * this.M21, kM.M20 * this.M02 + kM.M21 * this.M12 + kM.M22 * this.M22);
    }

    public void MultLeft(Vector3f kV, Vector3f kResult) {
        kResult.Set(kV.X * this.M00 + kV.Y * this.M10 + kV.Z * this.M20, kV.X * this.M01 + kV.Y * this.M11 + kV.Z * this.M21, kV.X * this.M02 + kV.Y * this.M12 + kV.Z * this.M22);
    }

    public void MultRight(Vector3f kV, Vector3f kResult) {
        float fX = this.M00 * kV.X + this.M01 * kV.Y + this.M02 * kV.Z;
        float fY = this.M10 * kV.X + this.M11 * kV.Y + this.M12 * kV.Z;
        float fZ = this.M20 * kV.X + this.M21 * kV.Y + this.M22 * kV.Z;
        kResult.Set(fX, fY, fZ);
    }

    public void Orthonormalize() {
        float fInvLength = Mathf.InvSqrt(this.M00 * this.M00 + this.M10 * this.M10 + this.M20 * this.M20);
        this.M00 *= fInvLength;
        this.M10 *= fInvLength;
        this.M20 *= fInvLength;
        float fDot0 = this.M00 * this.M01 + this.M10 * this.M11 + this.M20 * this.M21;
        this.M01 -= fDot0 * this.M00;
        this.M11 -= fDot0 * this.M10;
        this.M21 -= fDot0 * this.M20;
        fInvLength = Mathf.InvSqrt(this.M01 * this.M01 + this.M11 * this.M11 + this.M21 * this.M21);
        this.M01 *= fInvLength;
        this.M11 *= fInvLength;
        this.M21 *= fInvLength;
        float fDot1 = this.M01 * this.M02 + this.M11 * this.M12 + this.M21 * this.M22;
        fDot0 = this.M00 * this.M02 + this.M10 * this.M12 + this.M20 * this.M22;
        this.M02 -= fDot0 * this.M00 + fDot1 * this.M01;
        this.M12 -= fDot0 * this.M10 + fDot1 * this.M11;
        this.M22 -= fDot0 * this.M20 + fDot1 * this.M21;
        fInvLength = Mathf.InvSqrt(this.M02 * this.M02 + this.M12 * this.M12 + this.M22 * this.M22);
        this.M02 *= fInvLength;
        this.M12 *= fInvLength;
        this.M22 *= fInvLength;
    }

    public float QForm(Vector3f rkU, Vector3f rkV) {
        Vector3f kResult = new Vector3f();
        this.Mult(rkV, kResult);
        return rkU.Dot(kResult);
    }

    public void Scale(float fScalar) {
        this.Set(fScalar * this.M00, fScalar * this.M01, fScalar * this.M02, fScalar * this.M10, fScalar * this.M11, fScalar * this.M12, fScalar * this.M20, fScalar * this.M21, fScalar * this.M22);
    }

    public final void Set(float fM00, float fM01, float fM02, float fM10, float fM11, float fM12, float fM20, float fM21, float fM22) {
        this.M00 = fM00;
        this.M01 = fM01;
        this.M02 = fM02;
        this.M10 = fM10;
        this.M11 = fM11;
        this.M12 = fM12;
        this.M20 = fM20;
        this.M21 = fM21;
        this.M22 = fM22;
    }

    public void Set(float[] afEntry, boolean bRowMajor) {
        if (bRowMajor) {
            this.M00 = afEntry[0];
            this.M01 = afEntry[1];
            this.M02 = afEntry[2];
            this.M10 = afEntry[3];
            this.M11 = afEntry[4];
            this.M12 = afEntry[5];
            this.M20 = afEntry[6];
            this.M21 = afEntry[7];
            this.M22 = afEntry[8];
        } else {
            this.M00 = afEntry[0];
            this.M01 = afEntry[3];
            this.M02 = afEntry[6];
            this.M10 = afEntry[1];
            this.M11 = afEntry[4];
            this.M12 = afEntry[7];
            this.M20 = afEntry[2];
            this.M21 = afEntry[5];
            this.M22 = afEntry[8];
        }
    }

    public void Set(int iIndex, float fValue) {
        switch (iIndex) {
            case 0: {
                this.M00 = fValue;
                break;
            }
            case 1: {
                this.M01 = fValue;
                break;
            }
            case 2: {
                this.M02 = fValue;
                break;
            }
            case 3: {
                this.M10 = fValue;
                break;
            }
            case 4: {
                this.M11 = fValue;
                break;
            }
            case 5: {
                this.M12 = fValue;
                break;
            }
            case 6: {
                this.M20 = fValue;
                break;
            }
            case 7: {
                this.M21 = fValue;
                break;
            }
            case 8: {
                this.M22 = fValue;
            }
        }
    }

    public final void Set(int iRow, int iCol, float fValue) {
        block0 : switch (iRow) {
            case 0: {
                switch (iCol) {
                    case 0: {
                        this.M00 = fValue;
                        break;
                    }
                    case 1: {
                        this.M01 = fValue;
                        break;
                    }
                    case 2: {
                        this.M02 = fValue;
                    }
                }
                break;
            }
            case 1: {
                switch (iCol) {
                    case 0: {
                        this.M10 = fValue;
                        break;
                    }
                    case 1: {
                        this.M11 = fValue;
                        break;
                    }
                    case 2: {
                        this.M12 = fValue;
                    }
                }
                break;
            }
            case 2: {
                switch (iCol) {
                    case 0: {
                        this.M20 = fValue;
                        break block0;
                    }
                    case 1: {
                        this.M21 = fValue;
                        break block0;
                    }
                    case 2: {
                        this.M22 = fValue;
                    }
                }
            }
        }
    }

    public void SetColumn(int iCol, Vector3f kV) {
        switch (iCol) {
            case 0: {
                this.M00 = kV.X;
                this.M10 = kV.Y;
                this.M20 = kV.Z;
                break;
            }
            case 1: {
                this.M01 = kV.X;
                this.M11 = kV.Y;
                this.M21 = kV.Z;
                break;
            }
            case 2: {
                this.M02 = kV.X;
                this.M12 = kV.Y;
                this.M22 = kV.Z;
            }
        }
    }

    public void TimesDiagonal(Vector3f kDiag) {
        this.Set(this.M00 * kDiag.X, this.M01 * kDiag.Y, this.M02 * kDiag.Z, this.M10 * kDiag.X, this.M11 * kDiag.Y, this.M12 * kDiag.Z, this.M20 * kDiag.X, this.M21 * kDiag.Y, this.M22 * kDiag.Z);
    }

    public void TimesTranspose(Matrix3f kM) {
        this.Set(this.M00 * kM.M00 + this.M01 * kM.M01 + this.M02 * kM.M02, this.M00 * kM.M10 + this.M01 * kM.M11 + this.M02 * kM.M12, this.M00 * kM.M20 + this.M01 * kM.M21 + this.M02 * kM.M22, this.M10 * kM.M00 + this.M11 * kM.M01 + this.M12 * kM.M02, this.M10 * kM.M10 + this.M11 * kM.M11 + this.M12 * kM.M12, this.M10 * kM.M20 + this.M11 * kM.M21 + this.M12 * kM.M22, this.M20 * kM.M00 + this.M21 * kM.M01 + this.M22 * kM.M02, this.M20 * kM.M10 + this.M21 * kM.M11 + this.M22 * kM.M12, this.M20 * kM.M20 + this.M21 * kM.M21 + this.M22 * kM.M22);
    }

    public float ToAxisAngle(Vector3f rkAxis) {
        float fTrace = this.M00 + this.M11 + this.M22;
        float fCos = 0.5f * (fTrace - 1.0f);
        float rfAngle = (float)Math.acos(fCos);
        if (rfAngle > 0.0f) {
            if ((double)rfAngle < Math.PI) {
                rkAxis.X = this.M21 - this.M12;
                rkAxis.Y = this.M02 - this.M20;
                rkAxis.Z = this.M10 - this.M01;
                rkAxis.Normalize();
            } else if (this.M00 >= this.M11) {
                if (this.M00 >= this.M22) {
                    rkAxis.X = (float)(0.5 * Math.sqrt(this.M00 - this.M11 - this.M22 + 1.0f));
                    float fHalfInverse = 0.5f / rkAxis.X;
                    rkAxis.Y = fHalfInverse * this.M01;
                    rkAxis.Z = fHalfInverse * this.M02;
                } else {
                    rkAxis.Z = (float)(0.5 * Math.sqrt(this.M22 - this.M00 - this.M11 + 1.0f));
                    float fHalfInverse = 0.5f / rkAxis.Z;
                    rkAxis.X = fHalfInverse * this.M02;
                    rkAxis.Y = fHalfInverse * this.M12;
                }
            } else if (this.M11 >= this.M22) {
                rkAxis.Y = (float)(0.5 * Math.sqrt(this.M11 - this.M00 - this.M22 + 1.0f));
                float fHalfInverse = 0.5f / rkAxis.Y;
                rkAxis.X = fHalfInverse * this.M01;
                rkAxis.Z = fHalfInverse * this.M12;
            } else {
                rkAxis.Z = (float)(0.5 * Math.sqrt(this.M22 - this.M00 - this.M11 + 1.0f));
                float fHalfInverse = 0.5f / rkAxis.Z;
                rkAxis.X = fHalfInverse * this.M02;
                rkAxis.Y = fHalfInverse * this.M12;
            }
        } else {
            rkAxis.X = 1.0f;
            rkAxis.Y = 0.0f;
            rkAxis.Z = 0.0f;
        }
        return rfAngle;
    }

    public String toString() {
        return new String(this.M00 + " " + this.M01 + " " + this.M02 + " " + this.M10 + " " + this.M11 + " " + this.M12 + " " + this.M20 + " " + this.M21 + " " + this.M22);
    }

    public void Transpose() {
        this.Set(this.M00, this.M10, this.M20, this.M01, this.M11, this.M21, this.M02, this.M12, this.M22);
    }

    public void TransposeTimes(Matrix3f kM) {
        this.Set(this.M00 * kM.M00 + this.M10 * kM.M10 + this.M20 * kM.M20, this.M00 * kM.M01 + this.M10 * kM.M11 + this.M20 * kM.M21, this.M00 * kM.M02 + this.M10 * kM.M12 + this.M20 * kM.M22, this.M01 * kM.M00 + this.M11 * kM.M10 + this.M21 * kM.M20, this.M01 * kM.M01 + this.M11 * kM.M11 + this.M21 * kM.M21, this.M01 * kM.M02 + this.M11 * kM.M12 + this.M21 * kM.M22, this.M02 * kM.M00 + this.M12 * kM.M10 + this.M22 * kM.M20, this.M02 * kM.M01 + this.M12 * kM.M11 + this.M22 * kM.M21, this.M02 * kM.M02 + this.M12 * kM.M12 + this.M22 * kM.M22);
    }
}

