/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import java.io.Serializable;

public class Polynomial1f
implements Serializable {
    private static final long serialVersionUID = 4906614406554304320L;
    private static final float ms_fInvLog2 = 1.0f / (float)Math.log(2.0);
    private static final float ms_fLog10 = (float)Math.log(10.0);
    private static final float ms_fThird = 0.33333334f;
    private static final float ms_fSqrt3 = (float)Math.sqrt(3.0);
    private static final float ms_fTwentySeventh = 0.037037037f;
    protected float[] m_afCoeff;
    protected int m_iDegree;

    public Polynomial1f() {
        this.m_iDegree = -1;
        this.m_afCoeff = null;
    }

    public Polynomial1f(int iDegree) {
        if (iDegree >= 0) {
            this.m_iDegree = iDegree;
            this.m_afCoeff = new float[this.m_iDegree + 1];
        } else {
            this.m_iDegree = -1;
            this.m_afCoeff = null;
        }
    }

    public Polynomial1f(Polynomial1f kPoly) {
        this.m_iDegree = kPoly.m_iDegree;
        this.m_afCoeff = new float[this.m_iDegree + 1];
        System.arraycopy(kPoly.m_afCoeff, 0, this.m_afCoeff, 0, this.m_iDegree + 1);
    }

    public void Add(Polynomial1f kPoly1, Polynomial1f kPoly2) {
        Polynomial1f kSum;
        assert (kPoly1.m_iDegree >= 0 && kPoly2.m_iDegree >= 0);
        if (kPoly1.m_iDegree > kPoly2.m_iDegree) {
            int i;
            kSum = new Polynomial1f(kPoly1.m_iDegree);
            for (i = 0; i <= kPoly2.m_iDegree; ++i) {
                kSum.m_afCoeff[i] = kPoly1.m_afCoeff[i] + kPoly2.m_afCoeff[i];
            }
            for (i = kPoly2.m_iDegree + 1; i <= kPoly1.m_iDegree; ++i) {
                kSum.m_afCoeff[i] = kPoly1.m_afCoeff[i];
            }
        } else {
            int i;
            kSum = new Polynomial1f(kPoly2.m_iDegree);
            for (i = 0; i <= kPoly1.m_iDegree; ++i) {
                kSum.m_afCoeff[i] = kPoly1.m_afCoeff[i] + kPoly2.m_afCoeff[i];
            }
            for (i = kPoly1.m_iDegree + 1; i <= kPoly2.m_iDegree; ++i) {
                kSum.m_afCoeff[i] = kPoly2.m_afCoeff[i];
            }
        }
        this.Copy(kSum);
    }

    public boolean Bisection(float fXMin, float fXMax, int iDigitsAccuracy, float[] afReturn) {
        float fP0 = this.Eval(fXMin);
        float fP1 = this.Eval(fXMax);
        if (Math.abs(fP0) <= 1.1920929E-7f) {
            afReturn[0] = fXMin;
            return true;
        }
        if (Math.abs(fP1) <= 1.1920929E-7f) {
            afReturn[0] = fXMax;
        }
        if (fP0 * fP1 > 0.0f) {
            return false;
        }
        float fTmp0 = (float)Math.log(fXMax - fXMin);
        float fTmp1 = (float)iDigitsAccuracy * ms_fLog10;
        float fArg = (fTmp0 + fTmp1) * ms_fInvLog2;
        int iMaxIter = (int)Math.ceil(fArg);
        float fRoot = 0.0f;
        for (int i = 0; i < iMaxIter; ++i) {
            fRoot = 0.5f * (fXMin + fXMax);
            float fP = this.Eval(fRoot);
            if (Math.abs(fP) <= 1.1920929E-7f) {
                afReturn[0] = fRoot;
                return true;
            }
            if (fP * fP0 < 0.0f) {
                fXMax = fRoot;
                fP1 = fP;
                continue;
            }
            fXMin = fRoot;
            fP0 = fP;
        }
        afReturn[0] = fRoot;
        return true;
    }

    public void Copy(Polynomial1f kPoly) {
        this.m_iDegree = kPoly.m_iDegree;
        this.m_afCoeff = new float[this.m_iDegree + 1];
        System.arraycopy(kPoly.m_afCoeff, 0, this.m_afCoeff, 0, this.m_iDegree + 1);
    }

    public float Eval(float fT) {
        assert (this.m_iDegree >= 0);
        float fResult = this.m_afCoeff[this.m_iDegree];
        for (int i = this.m_iDegree - 1; i >= 0; --i) {
            fResult *= fT;
            fResult += this.m_afCoeff[i];
        }
        return fResult;
    }

    public float GetCoeff(int i) {
        assert (0 <= i && i <= this.m_iDegree);
        return this.m_afCoeff[i];
    }

    public int GetDegree() {
        return this.m_iDegree;
    }

    public Polynomial1f GetDerivative() {
        Polynomial1f kDeriv;
        if (this.m_iDegree > 0) {
            kDeriv = new Polynomial1f(this.m_iDegree - 1);
            int i0 = 0;
            int i1 = 1;
            while (i0 < this.m_iDegree) {
                kDeriv.m_afCoeff[i0] = (float)i1 * this.m_afCoeff[i1];
                ++i0;
                ++i1;
            }
        } else if (this.m_iDegree == 1) {
            kDeriv = new Polynomial1f(0);
            kDeriv.m_afCoeff[0] = 0.0f;
        } else {
            kDeriv = new Polynomial1f();
        }
        return kDeriv;
    }

    public float GetRootBisection() {
        float fTMin = 0.0f;
        float fFMin = this.Eval(fTMin);
        float fTMax = 1.0f;
        float fFMax = this.Eval(fTMax);
        assert (fFMin > 0.0f && fFMax < 0.0f);
        float fTmp0 = (float)Math.log(fTMax - fTMin);
        float fTmp1 = 6.0f * ms_fLog10;
        float fArg = (fTmp0 + fTmp1) * ms_fInvLog2;
        int iMaxIter = (int)Math.ceil(fArg);
        float fTMid = 0.5f * (fTMin + fTMax);
        float fFMid = this.Eval(fTMid);
        for (int i = 0; i < iMaxIter; ++i) {
            fTMid = 0.5f * (fTMin + fTMax);
            fFMid = this.Eval(fTMid);
            float fProduct = fFMid * fFMin;
            if (fProduct < 0.0f) {
                fTMax = fTMid;
                fFMax = fFMid;
                continue;
            }
            fTMin = fTMid;
            fFMin = fFMid;
        }
        float fRadius = (float)Math.sqrt(fTMid);
        return fRadius;
    }

    public int GetRootsOnInterval(float fXMin, float fXMax, float[] afRoot, int iDigitsAccuracy) {
        int i;
        boolean bSuccess;
        float[] aResult = new float[1];
        if (this.m_iDegree == 1) {
            int iCount;
            boolean bSuccess2 = this.Bisection(fXMin, fXMax, iDigitsAccuracy, aResult);
            if (bSuccess2) {
                iCount = 1;
                afRoot[0] = aResult[0];
            } else {
                iCount = 0;
            }
            return iCount;
        }
        Polynomial1f kDeriv = this.GetDerivative();
        int iCount = kDeriv.GetRootsOnInterval(fXMin, fXMax, afRoot, iDigitsAccuracy);
        int iNewCount = 0;
        float[] afNewRoot = new float[iCount + 1];
        if (iCount > 0) {
            bSuccess = this.Bisection(fXMin, afRoot[0], iDigitsAccuracy, aResult);
            if (bSuccess) {
                afNewRoot[iNewCount++] = aResult[0];
            }
            for (i = 0; i <= iCount - 2; ++i) {
                bSuccess = this.Bisection(afRoot[i], afRoot[i + 1], iDigitsAccuracy, aResult);
                if (!bSuccess) continue;
                afNewRoot[iNewCount++] = aResult[0];
            }
            bSuccess = this.Bisection(afRoot[iCount - 1], fXMax, iDigitsAccuracy, aResult);
            if (bSuccess) {
                afNewRoot[iNewCount++] = aResult[0];
            }
        } else {
            bSuccess = this.Bisection(fXMin, fXMax, iDigitsAccuracy, aResult);
            if (bSuccess) {
                afNewRoot[iNewCount++] = aResult[0];
            }
        }
        if (iNewCount > 0) {
            iCount = 1;
            afRoot[0] = afNewRoot[0];
            for (i = 1; i < iNewCount; ++i) {
                if (!(Math.abs(afNewRoot[i] - afNewRoot[i - 1]) > 1.1920929E-7f)) continue;
                afRoot[iCount++] = afNewRoot[i];
            }
        } else {
            iCount = 0;
        }
        return iCount;
    }

    public void Mult(Polynomial1f kPoly1, Polynomial1f kPoly2) {
        assert (kPoly1.m_iDegree >= 0 && kPoly2.m_iDegree >= 0);
        Polynomial1f kProd = new Polynomial1f(kPoly1.m_iDegree + kPoly2.m_iDegree);
        for (int i = 0; i <= kProd.m_iDegree; ++i) {
            kProd.m_afCoeff[i] = 0.0f;
        }
        for (int i1 = 0; i1 <= kPoly1.m_iDegree; ++i1) {
            for (int i2 = 0; i2 <= kPoly2.m_iDegree; ++i2) {
                int n = i1 + i2;
                kProd.m_afCoeff[n] = kProd.m_afCoeff[n] + kPoly1.m_afCoeff[i1] * kPoly2.m_afCoeff[i2];
            }
        }
        this.Copy(kProd);
    }

    public int RootsDegree3(float[] afRoot) {
        int iCount;
        if (this.m_iDegree != 3) {
            return 0;
        }
        float[] afCoeff = new float[]{this.m_afCoeff[0], this.m_afCoeff[1], this.m_afCoeff[2]};
        if (this.m_afCoeff[3] != 1.0f) {
            float fInv = 1.0f / this.m_afCoeff[3];
            afCoeff[0] = afCoeff[0] * fInv;
            afCoeff[1] = afCoeff[1] * fInv;
            afCoeff[2] = afCoeff[2] * fInv;
        }
        float fA = 0.33333334f * (3.0f * afCoeff[1] - afCoeff[2] * afCoeff[2]);
        float fB = 0.037037037f * (2.0f * afCoeff[2] * afCoeff[2] * afCoeff[2] - 9.0f * afCoeff[1] * afCoeff[2] + 27.0f * afCoeff[0]);
        float fOffset = 0.33333334f * afCoeff[2];
        float fDiscr = 0.25f * fB * fB + 0.037037037f * fA * fA * fA;
        if (Math.abs(fDiscr) <= 1.1920929E-7f) {
            fDiscr = 0.0f;
        }
        float fHalfB = 0.5f * fB;
        if (fDiscr > 0.0f) {
            float fTemp = -fHalfB + (fDiscr = (float)Math.sqrt(fDiscr));
            afRoot[0] = fTemp >= 0.0f ? (float)Math.pow(fTemp, 0.3333333432674408) : -((float)Math.pow(-fTemp, 0.3333333432674408));
            fTemp = -fHalfB - fDiscr;
            afRoot[0] = fTemp >= 0.0f ? (float)((double)afRoot[0] + Math.pow(fTemp, 0.3333333432674408)) : (float)((double)afRoot[0] - Math.pow(-fTemp, 0.3333333432674408));
            afRoot[0] = afRoot[0] - fOffset;
            iCount = 1;
        } else if (fDiscr < 0.0f) {
            float fDist = (float)Math.sqrt(-0.33333334f * fA);
            float fAngle = 0.33333334f * (float)Math.atan2(Math.sqrt(-fDiscr), -fHalfB);
            float fCos = (float)Math.cos(fAngle);
            float fSin = (float)Math.sin(fAngle);
            afRoot[0] = 2.0f * fDist * fCos - fOffset;
            afRoot[1] = -fDist * (fCos + ms_fSqrt3 * fSin) - fOffset;
            afRoot[2] = -fDist * (fCos - ms_fSqrt3 * fSin) - fOffset;
            iCount = 3;
        } else {
            float fTemp = fHalfB >= 0.0f ? -((float)Math.pow(fHalfB, 0.3333333432674408)) : (float)Math.pow(-fHalfB, 0.3333333432674408);
            afRoot[0] = 2.0f * fTemp - fOffset;
            afRoot[1] = -fTemp - fOffset;
            afRoot[2] = afRoot[1];
            iCount = 3;
        }
        return iCount;
    }

    public void Scale(float fScalar) {
        assert (this.m_iDegree >= 0);
        int i = 0;
        while (i <= this.m_iDegree) {
            int n = i++;
            this.m_afCoeff[n] = this.m_afCoeff[n] * fScalar;
        }
    }

    public void SetCoeff(int i, float fValue) {
        assert (0 <= i && i <= this.m_iDegree);
        this.m_afCoeff[i] = fValue;
    }

    public void Sub(Polynomial1f kPoly1, Polynomial1f kPoly2) {
        Polynomial1f kDiff;
        assert (kPoly1.m_iDegree >= 0 && kPoly2.m_iDegree >= 0);
        if (kPoly1.m_iDegree > kPoly2.m_iDegree) {
            int i;
            kDiff = new Polynomial1f(kPoly1.m_iDegree);
            for (i = 0; i <= kPoly2.m_iDegree; ++i) {
                kDiff.m_afCoeff[i] = kPoly1.m_afCoeff[i] - kPoly2.m_afCoeff[i];
            }
            for (i = kPoly2.m_iDegree + 1; i <= kPoly1.m_iDegree; ++i) {
                kDiff.m_afCoeff[i] = kPoly1.m_afCoeff[i];
            }
        } else {
            int i;
            kDiff = new Polynomial1f(kPoly2.m_iDegree);
            for (i = 0; i <= kPoly1.m_iDegree; ++i) {
                kDiff.m_afCoeff[i] = kPoly1.m_afCoeff[i] - kPoly2.m_afCoeff[i];
            }
            for (i = kPoly1.m_iDegree + 1; i <= kPoly2.m_iDegree; ++i) {
                kDiff.m_afCoeff[i] = -kPoly2.m_afCoeff[i];
            }
        }
        this.Copy(kDiff);
    }
}

