/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import WildMagic.LibFoundation.Mathematics.Mathd;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class Vector3d
implements Serializable {
    public static final transient Vector3d ZERO = new Vector3d(0.0, 0.0, 0.0);
    public static final transient Vector3d UNIT_X = new Vector3d(1.0, 0.0, 0.0);
    public static final transient Vector3d UNIT_Y = new Vector3d(0.0, 1.0, 0.0);
    public static final transient Vector3d UNIT_Z = new Vector3d(0.0, 0.0, 1.0);
    public static final transient Vector3d UNIT_X_NEG = new Vector3d(-1.0, 0.0, 0.0);
    public static final transient Vector3d UNIT_Y_NEG = new Vector3d(0.0, -1.0, 0.0);
    public static final transient Vector3d UNIT_Z_NEG = new Vector3d(0.0, 0.0, -1.0);
    public static final transient Vector3d ONE = new Vector3d(1.0, 1.0, 1.0);
    public double X = 0.0;
    public double Y = 0.0;
    public double Z = 0.0;

    public Vector3d() {
    }

    public Vector3d(double dX, double dY, double dZ) {
        this.X = dX;
        this.Y = dY;
        this.Z = dZ;
    }

    public Vector3d(double[] adTuple) {
        this.X = adTuple[0];
        this.Y = adTuple[1];
        this.Z = adTuple[2];
    }

    public Vector3d(Vector3f rkV) {
        if (rkV != null) {
            this.X = rkV.X;
            this.Y = rkV.Y;
            this.Z = rkV.Z;
        } else {
            this.X = 0.0;
            this.Y = 0.0;
            this.Z = 0.0;
        }
    }

    public Vector3d(Vector3d rkV) {
        if (rkV != null) {
            this.X = rkV.X;
            this.Y = rkV.Y;
            this.Z = rkV.Z;
        } else {
            this.X = 0.0;
            this.Y = 0.0;
            this.Z = 0.0;
        }
    }

    public static double Angle(Vector3d rkV1, Vector3d rkV2) {
        if (rkV1.IsEqual(rkV2)) {
            return 0.0;
        }
        Vector3d kBisector = new Vector3d();
        kBisector.Add(rkV1, rkV2);
        kBisector.Normalize();
        Vector3d rkV3 = new Vector3d(rkV1.X, rkV1.Y, rkV1.Z);
        rkV3.Normalize();
        double dCosHalfAngle = rkV3.Dot(kBisector);
        if (dCosHalfAngle != 0.0) {
            double dAngle = Math.acos(dCosHalfAngle) * 2.0;
            return dAngle;
        }
        return Math.PI;
    }

    public static void ComputeExtremes(int iVQuantity, Vector3d[] akPoint, Vector3d rkMin, Vector3d rkMax) {
        if (iVQuantity <= 0 || akPoint == null) {
            return;
        }
        rkMin.Copy(akPoint[0]);
        rkMax.Copy(akPoint[0]);
        for (int i = 1; i < iVQuantity; ++i) {
            if (akPoint[i].X < rkMin.X) {
                rkMin.X = akPoint[i].X;
            }
            if (akPoint[i].Y < rkMin.Y) {
                rkMin.Y = akPoint[i].Y;
            }
            if (akPoint[i].Z < rkMin.Z) {
                rkMin.Z = akPoint[i].Z;
            }
            if (akPoint[i].X > rkMax.X) {
                rkMax.X = akPoint[i].X;
            }
            if (akPoint[i].Y > rkMax.Y) {
                rkMax.Y = akPoint[i].Y;
            }
            if (!(akPoint[i].Z > rkMax.Z)) continue;
            rkMax.Z = akPoint[i].Z;
        }
    }

    public static void GenerateComplementBasis(Vector3d rkU, Vector3d rkV, Vector3d rkW) {
        if (Math.abs(rkW.X) >= Math.abs(rkW.Y)) {
            double dInvLength = Mathd.InvSqrt(rkW.X * rkW.X + rkW.Z * rkW.Z);
            rkU.X = -rkW.Z * dInvLength;
            rkU.Y = 0.0;
            rkU.Z = rkW.X * dInvLength;
            rkV.X = rkW.Y * rkU.Z;
            rkV.Y = rkW.Z * rkU.X - rkW.X * rkU.Z;
            rkV.Z = -rkW.Y * rkU.X;
        } else {
            double dInvLength = Mathd.InvSqrt(rkW.Y * rkW.Y + rkW.Z * rkW.Z);
            rkU.X = 0.0;
            rkU.Y = rkW.Z * dInvLength;
            rkU.Z = -rkW.Y * dInvLength;
            rkV.X = rkW.Y * rkU.Z - rkW.Z * rkU.Y;
            rkV.Y = -rkW.X * rkU.Z;
            rkV.Z = rkW.X * rkU.Y;
        }
    }

    public static void GenerateOrthonormalBasis(Vector3d rkU, Vector3d rkV, Vector3d rkW) {
        rkW.Normalize();
        Vector3d.GenerateComplementBasis(rkU, rkV, rkW);
    }

    public void Add(double dX, double dY, double dZ) {
        this.X += dX;
        this.Y += dY;
        this.Z += dZ;
    }

    public void Add(Vector3d rkV) {
        this.X += rkV.X;
        this.Y += rkV.Y;
        this.Z += rkV.Z;
    }

    public void Add(Vector3d rkV1, Vector3d rkV2) {
        this.X = rkV1.X + rkV2.X;
        this.Y = rkV1.Y + rkV2.Y;
        this.Z = rkV1.Z + rkV2.Z;
    }

    public double Angle(Vector3d rkV1) {
        if (this.equals(rkV1)) {
            return 0.0;
        }
        Vector3d rkV2 = new Vector3d(this.X, this.Y, this.Z);
        Vector3d kBisector = new Vector3d();
        kBisector.Add(rkV1, rkV2);
        kBisector.Normalize();
        Vector3d rkV3 = new Vector3d(rkV1.X, rkV1.Y, rkV1.Z);
        rkV3.Normalize();
        double dCosHalfAngle = rkV3.Dot(kBisector);
        if (dCosHalfAngle != 0.0) {
            double dAngle = Math.acos(dCosHalfAngle) * 2.0;
            return dAngle;
        }
        return Math.PI;
    }

    public void Copy(Vector3d rkV) {
        this.X = rkV.X;
        this.Y = rkV.Y;
        this.Z = rkV.Z;
    }

    public void Cross(Vector3d rkV) {
        this.Set(this.Y * rkV.Z - this.Z * rkV.Y, this.Z * rkV.X - this.X * rkV.Z, this.X * rkV.Y - this.Y * rkV.X);
    }

    public void Cross(Vector3d kV1, Vector3d kV2) {
        this.Set(kV1.Y * kV2.Z - kV1.Z * kV2.Y, kV1.Z * kV2.X - kV1.X * kV2.Z, kV1.X * kV2.Y - kV1.Y * kV2.X);
    }

    public double Distance(Vector3d kV) {
        return Math.sqrt((this.X - kV.X) * (this.X - kV.X) + (this.Y - kV.Y) * (this.Y - kV.Y) + (this.Z - kV.Z) * (this.Z - kV.Z));
    }

    public void Div(double dScalar) {
        if (dScalar != 0.0) {
            double dInvScalar = 1.0 / dScalar;
            this.X *= dInvScalar;
            this.Y *= dInvScalar;
            this.Z *= dInvScalar;
        } else {
            this.X = Double.MAX_VALUE;
            this.Y = Double.MAX_VALUE;
            this.Z = Double.MAX_VALUE;
        }
    }

    public void Div(double dScalar, Vector3d kV) {
        if (dScalar != 0.0) {
            double dInvScalar = 1.0 / dScalar;
            this.X = dInvScalar * kV.X;
            this.Y = dInvScalar * kV.Y;
            this.Z = dInvScalar * kV.Z;
        } else {
            this.X = Double.MAX_VALUE;
            this.Y = Double.MAX_VALUE;
            this.Z = Double.MAX_VALUE;
        }
    }

    public double Dot(Vector3d rkV) {
        return this.X * rkV.X + this.Y * rkV.Y + this.Z * rkV.Z;
    }

    public boolean equals(Object kObject) {
        Vector3d kV = (Vector3d)kObject;
        return this.X == kV.X && this.Y == kV.Y && this.Z == kV.Z;
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.X) + Double.doubleToLongBits(this.Y) + Double.doubleToLongBits(this.Z));
    }

    public void Invert() {
        this.X = this.X == 0.0 ? 0.0 : 1.0 / this.X;
        this.Y = this.Y == 0.0 ? 0.0 : 1.0 / this.Y;
        this.Z = this.Z == 0.0 ? 0.0 : 1.0 / this.Z;
    }

    public boolean IsEqual(Vector3d rkV) {
        if (rkV == null) {
            return false;
        }
        return Math.abs(this.X - rkV.X) < 1.0E-12 && Math.abs(this.Y - rkV.Y) < 1.0E-12 && Math.abs(this.Z - rkV.Z) < 1.0E-12;
    }

    public boolean IsLessThan(Vector3d rkV) {
        return Math.abs(this.X - rkV.X) < 1.0E-12 && Math.abs(this.Y - rkV.Y) < 1.0E-12 && Math.abs(this.Z - rkV.Z) < 1.0E-12;
    }

    public double Length() {
        return Math.sqrt(this.X * this.X + this.Y * this.Y + this.Z * this.Z);
    }

    public void Max(Vector3d kV) {
        this.X = Math.max(this.X, kV.X);
        this.Y = Math.max(this.Y, kV.Y);
        this.Z = Math.max(this.Z, kV.Z);
    }

    public void Min(Vector3d kV) {
        this.X = Math.min(this.X, kV.X);
        this.Y = Math.min(this.Y, kV.Y);
        this.Z = Math.min(this.Z, kV.Z);
    }

    public void Mult(Vector3d rkV) {
        this.X *= rkV.X;
        this.Y *= rkV.Y;
        this.Z *= rkV.Z;
    }

    public void Mult(Vector3d rkV1, Vector3d rkV2) {
        this.X = rkV1.X * rkV2.X;
        this.Y = rkV1.Y * rkV2.Y;
        this.Z = rkV1.Z * rkV2.Z;
    }

    public void Neg() {
        this.X = -this.X;
        this.Y = -this.Y;
        this.Z = -this.Z;
    }

    public void Neg(Vector3d kV) {
        this.X = -kV.X;
        this.Y = -kV.Y;
        this.Z = -kV.Z;
    }

    public double Normalize() {
        double dLength = this.Length();
        if (dLength > 1.0E-12) {
            double dInvLength = 1.0 / dLength;
            this.X *= dInvLength;
            this.Y *= dInvLength;
            this.Z *= dInvLength;
        } else {
            dLength = 0.0;
            this.X = 0.0;
            this.Y = 0.0;
            this.Z = 0.0;
        }
        return dLength;
    }

    public double Normalize(Vector3d kV) {
        this.Copy(kV);
        return this.Normalize();
    }

    public void Scale(double dScalar) {
        this.X *= dScalar;
        this.Y *= dScalar;
        this.Z *= dScalar;
    }

    public void Scale(double dX, double dY, double dZ) {
        this.X *= dX;
        this.Y *= dY;
        this.Z *= dZ;
    }

    public void Scale(double dScalar, Vector3d rkV) {
        this.X = dScalar * rkV.X;
        this.Y = dScalar * rkV.Y;
        this.Z = dScalar * rkV.Z;
    }

    public void ScaleAdd(double dScalar, Vector3d rkV1, Vector3d rkV2) {
        this.X = dScalar * rkV1.X + rkV2.X;
        this.Y = dScalar * rkV1.Y + rkV2.Y;
        this.Z = dScalar * rkV1.Z + rkV2.Z;
    }

    public void Set(double dX, double dY, double dZ) {
        this.X = dX;
        this.Y = dY;
        this.Z = dZ;
    }

    public double SquaredDistance(Vector3d kV) {
        return (this.X - kV.X) * (this.X - kV.X) + (this.Y - kV.Y) * (this.Y - kV.Y) + (this.Z - kV.Z) * (this.Z - kV.Z);
    }

    public double SquaredLength() {
        return this.X * this.X + this.Y * this.Y + this.Z * this.Z;
    }

    public void Sub(Vector3d rkV) {
        this.X -= rkV.X;
        this.Y -= rkV.Y;
        this.Z -= rkV.Z;
    }

    public void Sub(Vector3d rkV1, Vector3d rkV2) {
        this.X = rkV1.X - rkV2.X;
        this.Y = rkV1.Y - rkV2.Y;
        this.Z = rkV1.Z - rkV2.Z;
    }

    public String toString() {
        return new String(this.X + " " + this.Y + " " + this.Z);
    }

    public void UnitCross(Vector3d rkV) {
        this.Set(this.Y * rkV.Z - this.Z * rkV.Y, this.Z * rkV.X - this.X * rkV.Z, this.X * rkV.Y - this.Y * rkV.X);
        this.Normalize();
    }

    public void UnitCross(Vector3d kV1, Vector3d kV2) {
        this.Set(kV1.Y * kV2.Z - kV1.Z * kV2.Y, kV1.Z * kV2.X - kV1.X * kV2.Z, kV1.X * kV2.Y - kV1.Y * kV2.X);
        this.Normalize();
    }
}

