/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import WildMagic.LibFoundation.Mathematics.Mathf;
import java.io.Serializable;

public class Vector3f
implements Serializable {
    private static final long serialVersionUID = 6404041982621934203L;
    public static final transient Vector3f ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final transient Vector3f UNIT_X = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final transient Vector3f UNIT_Y = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final transient Vector3f UNIT_Z = new Vector3f(0.0f, 0.0f, 1.0f);
    public static final transient Vector3f UNIT_X_NEG = new Vector3f(-1.0f, 0.0f, 0.0f);
    public static final transient Vector3f UNIT_Y_NEG = new Vector3f(0.0f, -1.0f, 0.0f);
    public static final transient Vector3f UNIT_Z_NEG = new Vector3f(0.0f, 0.0f, -1.0f);
    public static final transient Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    public float X = 0.0f;
    public float Y = 0.0f;
    public float Z = 0.0f;

    public Vector3f() {
    }

    public Vector3f(float fX, float fY, float fZ) {
        this.X = fX;
        this.Y = fY;
        this.Z = fZ;
    }

    public Vector3f(float[] afTuple) {
        this.X = afTuple[0];
        this.Y = afTuple[1];
        this.Z = afTuple[2];
    }

    public Vector3f(Vector3f rkV) {
        if (rkV != null) {
            this.X = rkV.X;
            this.Y = rkV.Y;
            this.Z = rkV.Z;
        } else {
            this.X = 0.0f;
            this.Y = 0.0f;
            this.Z = 0.0f;
        }
    }

    public static float Angle(Vector3f rkV1, Vector3f rkV2) {
        if (rkV1.IsEqual(rkV2)) {
            return 0.0f;
        }
        Vector3f kBisector = new Vector3f();
        kBisector.Add(rkV1, rkV2);
        kBisector.Normalize();
        Vector3f rkV3 = new Vector3f(rkV1.X, rkV1.Y, rkV1.Z);
        rkV3.Normalize();
        float fCosHalfAngle = rkV3.Dot(kBisector);
        if ((double)fCosHalfAngle != 0.0) {
            float fAngle = (float)Math.acos(fCosHalfAngle) * 2.0f;
            return fAngle;
        }
        return (float)Math.PI;
    }

    public static void ComputeExtremes(int iVQuantity, Vector3f[] akPoint, Vector3f rkMin, Vector3f rkMax) {
        if (iVQuantity <= 0 || akPoint == null) {
            return;
        }
        rkMin.Copy(akPoint[0]);
        rkMax.Copy(akPoint[0]);
        for (int i = 1; i < iVQuantity; ++i) {
            rkMin.Min(akPoint[i]);
            rkMax.Max(akPoint[i]);
        }
    }

    public static void GenerateComplementBasis(Vector3f rkU, Vector3f rkV, Vector3f rkW) {
        if (Math.abs(rkW.X) >= Math.abs(rkW.Y)) {
            float fInvLength = Mathf.InvSqrt(rkW.X * rkW.X + rkW.Z * rkW.Z);
            rkU.X = -rkW.Z * fInvLength;
            rkU.Y = 0.0f;
            rkU.Z = rkW.X * fInvLength;
            rkV.X = rkW.Y * rkU.Z;
            rkV.Y = rkW.Z * rkU.X - rkW.X * rkU.Z;
            rkV.Z = -rkW.Y * rkU.X;
        } else {
            float fInvLength = Mathf.InvSqrt(rkW.Y * rkW.Y + rkW.Z * rkW.Z);
            rkU.X = 0.0f;
            rkU.Y = rkW.Z * fInvLength;
            rkU.Z = -rkW.Y * fInvLength;
            rkV.X = rkW.Y * rkU.Z - rkW.Z * rkU.Y;
            rkV.Y = -rkW.X * rkU.Z;
            rkV.Z = rkW.X * rkU.Y;
        }
    }

    public static void GenerateOrthonormalBasis(Vector3f rkU, Vector3f rkV, Vector3f rkW) {
        rkW.Normalize();
        Vector3f.GenerateComplementBasis(rkU, rkV, rkW);
    }

    public void Add(float fX, float fY, float fZ) {
        this.X += fX;
        this.Y += fY;
        this.Z += fZ;
    }

    public void Add(Vector3f rkV) {
        this.X += rkV.X;
        this.Y += rkV.Y;
        this.Z += rkV.Z;
    }

    public void Add(Vector3f rkV1, Vector3f rkV2) {
        this.X = rkV1.X + rkV2.X;
        this.Y = rkV1.Y + rkV2.Y;
        this.Z = rkV1.Z + rkV2.Z;
    }

    public float Angle(Vector3f rkV1) {
        if (this.equals(rkV1)) {
            return 0.0f;
        }
        if (this.IsEqual(rkV1)) {
            return 0.0f;
        }
        Vector3f rkV2 = new Vector3f(this.X, this.Y, this.Z);
        Vector3f kBisector = new Vector3f();
        kBisector.Add(rkV1, rkV2);
        kBisector.Normalize();
        Vector3f rkV3 = new Vector3f(rkV1.X, rkV1.Y, rkV1.Z);
        rkV3.Normalize();
        float fCosHalfAngle = Math.min(1.0f, rkV3.Dot(kBisector));
        if (Math.abs(fCosHalfAngle) > 1.0E-6f) {
            float fAngle = (float)Math.acos(fCosHalfAngle) * 2.0f;
            return fAngle;
        }
        return (float)Math.PI;
    }

    public void Copy(Vector3f rkV) {
        this.X = rkV.X;
        this.Y = rkV.Y;
        this.Z = rkV.Z;
    }

    public void Cross(Vector3f rkV) {
        this.Set(this.Y * rkV.Z - this.Z * rkV.Y, this.Z * rkV.X - this.X * rkV.Z, this.X * rkV.Y - this.Y * rkV.X);
    }

    public void Cross(Vector3f kV1, Vector3f kV2) {
        this.Set(kV1.Y * kV2.Z - kV1.Z * kV2.Y, kV1.Z * kV2.X - kV1.X * kV2.Z, kV1.X * kV2.Y - kV1.Y * kV2.X);
    }

    public float Distance(Vector3f kV) {
        return (float)Math.sqrt((this.X - kV.X) * (this.X - kV.X) + (this.Y - kV.Y) * (this.Y - kV.Y) + (this.Z - kV.Z) * (this.Z - kV.Z));
    }

    public void Div(float fScalar) {
        if (fScalar != 0.0f) {
            float fInvScalar = 1.0f / fScalar;
            this.X *= fInvScalar;
            this.Y *= fInvScalar;
            this.Z *= fInvScalar;
        } else {
            this.X = Float.MAX_VALUE;
            this.Y = Float.MAX_VALUE;
            this.Z = Float.MAX_VALUE;
        }
    }

    public void Div(float fScalar, Vector3f kV) {
        if (fScalar != 0.0f) {
            float fInvScalar = 1.0f / fScalar;
            this.X = fInvScalar * kV.X;
            this.Y = fInvScalar * kV.Y;
            this.Z = fInvScalar * kV.Z;
        } else {
            this.X = Float.MAX_VALUE;
            this.Y = Float.MAX_VALUE;
            this.Z = Float.MAX_VALUE;
        }
    }

    public float Dot(Vector3f rkV) {
        return this.X * rkV.X + this.Y * rkV.Y + this.Z * rkV.Z;
    }

    public boolean equals(Object kObject) {
        Vector3f kV = (Vector3f)kObject;
        return this.X == kV.X && this.Y == kV.Y && this.Z == kV.Z;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.X) + Float.floatToIntBits(this.Y) + Float.floatToIntBits(this.Z);
    }

    public void Invert() {
        this.X = this.X == 0.0f ? 0.0f : 1.0f / this.X;
        this.Y = this.Y == 0.0f ? 0.0f : 1.0f / this.Y;
        this.Z = this.Z == 0.0f ? 0.0f : 1.0f / this.Z;
    }

    public boolean IsEqual(Vector3f rkV) {
        if (rkV == null) {
            return false;
        }
        return Math.abs(this.X - rkV.X) < 1.0E-6f && Math.abs(this.Y - rkV.Y) < 1.0E-6f && Math.abs(this.Z - rkV.Z) < 1.0E-6f;
    }

    public boolean IsLessThan(Vector3f rkV) {
        return Math.abs(this.X - rkV.X) < 1.0E-6f && Math.abs(this.Y - rkV.Y) < 1.0E-6f && Math.abs(this.Z - rkV.Z) < 1.0E-6f;
    }

    public float Length() {
        return (float)Math.sqrt(this.X * this.X + this.Y * this.Y + this.Z * this.Z);
    }

    public void Max(Vector3f kV) {
        this.X = Math.max(this.X, kV.X);
        this.Y = Math.max(this.Y, kV.Y);
        this.Z = Math.max(this.Z, kV.Z);
    }

    public void Min(Vector3f kV) {
        this.X = Math.min(this.X, kV.X);
        this.Y = Math.min(this.Y, kV.Y);
        this.Z = Math.min(this.Z, kV.Z);
    }

    public void Mult(Vector3f rkV) {
        this.X *= rkV.X;
        this.Y *= rkV.Y;
        this.Z *= rkV.Z;
    }

    public void Mult(Vector3f rkV1, Vector3f rkV2) {
        this.X = rkV1.X * rkV2.X;
        this.Y = rkV1.Y * rkV2.Y;
        this.Z = rkV1.Z * rkV2.Z;
    }

    public void Neg() {
        this.X = -this.X;
        this.Y = -this.Y;
        this.Z = -this.Z;
    }

    public void Neg(Vector3f kV) {
        this.X = -kV.X;
        this.Y = -kV.Y;
        this.Z = -kV.Z;
    }

    public float Normalize() {
        float fLength = this.Length();
        if (fLength > 1.0E-6f) {
            float fInvLength = 1.0f / fLength;
            this.X *= fInvLength;
            this.Y *= fInvLength;
            this.Z *= fInvLength;
        } else {
            fLength = 0.0f;
            this.X = 0.0f;
            this.Y = 0.0f;
            this.Z = 0.0f;
        }
        return fLength;
    }

    public float Normalize(Vector3f kV) {
        this.Copy(kV);
        return this.Normalize();
    }

    public void Scale(float fScalar) {
        this.X *= fScalar;
        this.Y *= fScalar;
        this.Z *= fScalar;
    }

    public void Scale(float fX, float fY, float fZ) {
        this.X *= fX;
        this.Y *= fY;
        this.Z *= fZ;
    }

    public void Scale(float fScalar, Vector3f rkV) {
        this.X = fScalar * rkV.X;
        this.Y = fScalar * rkV.Y;
        this.Z = fScalar * rkV.Z;
    }

    public void ScaleAdd(float fScalar, Vector3f rkV1, Vector3f rkV2) {
        this.X = fScalar * rkV1.X + rkV2.X;
        this.Y = fScalar * rkV1.Y + rkV2.Y;
        this.Z = fScalar * rkV1.Z + rkV2.Z;
    }

    public void Set(float fX, float fY, float fZ) {
        this.X = fX;
        this.Y = fY;
        this.Z = fZ;
    }

    public float SquaredDistance(Vector3f kV) {
        return (this.X - kV.X) * (this.X - kV.X) + (this.Y - kV.Y) * (this.Y - kV.Y) + (this.Z - kV.Z) * (this.Z - kV.Z);
    }

    public float SquaredLength() {
        return this.X * this.X + this.Y * this.Y + this.Z * this.Z;
    }

    public void Sub(Vector3f rkV) {
        this.X -= rkV.X;
        this.Y -= rkV.Y;
        this.Z -= rkV.Z;
    }

    public void Sub(Vector3f rkV1, Vector3f rkV2) {
        this.X = rkV1.X - rkV2.X;
        this.Y = rkV1.Y - rkV2.Y;
        this.Z = rkV1.Z - rkV2.Z;
    }

    public String toString() {
        return new String(this.X + " " + this.Y + " " + this.Z);
    }

    public void UnitCross(Vector3f rkV) {
        this.Set(this.Y * rkV.Z - this.Z * rkV.Y, this.Z * rkV.X - this.X * rkV.Z, this.X * rkV.Y - this.Y * rkV.X);
        this.Normalize();
    }

    public void UnitCross(Vector3f kV1, Vector3f kV2) {
        this.Set(kV1.Y * kV2.Z - kV1.Z * kV2.Y, kV1.Z * kV2.X - kV1.X * kV2.Z, kV1.X * kV2.Y - kV1.Y * kV2.X);
        this.Normalize();
    }
}

