/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Mathematics;

import java.io.Serializable;

public class Vector4d
implements Serializable {
    public static final Vector4d ZERO = new Vector4d(0.0, 0.0, 0.0, 0.0);
    public static final Vector4d UNIT_X = new Vector4d(1.0, 0.0, 0.0, 0.0);
    public static final Vector4d UNIT_Y = new Vector4d(0.0, 1.0, 0.0, 0.0);
    public static final Vector4d UNIT_Z = new Vector4d(0.0, 0.0, 1.0, 0.0);
    public static final Vector4d UNIT_W = new Vector4d(0.0, 0.0, 0.0, 1.0);
    public static final Vector4d ONE = new Vector4d(1.0, 1.0, 1.0, 1.0);
    public double X = 0.0;
    public double Y = 0.0;
    public double Z = 0.0;
    public double W = 0.0;

    public Vector4d() {
    }

    public Vector4d(float fX, float fY, float fZ, float fW) {
        this.X = fX;
        this.Y = fY;
        this.Z = fZ;
        this.W = fW;
    }

    public Vector4d(double dX, double dY, double dZ, double dW) {
        this.X = dX;
        this.Y = dY;
        this.Z = dZ;
        this.W = dW;
    }

    public Vector4d(float[] afTuple) {
        this.X = afTuple[0];
        this.Y = afTuple[1];
        this.Z = afTuple[2];
        this.W = afTuple[3];
    }

    public Vector4d(double[] adTuple) {
        this.X = adTuple[0];
        this.Y = adTuple[1];
        this.Z = adTuple[2];
        this.W = adTuple[3];
    }

    public Vector4d(Vector4d rkV) {
        this.X = rkV.X;
        this.Y = rkV.Y;
        this.Z = rkV.Z;
        this.W = rkV.W;
    }

    public void Copy(Vector4d rkV) {
        this.X = rkV.X;
        this.Y = rkV.Y;
        this.Z = rkV.Z;
        this.W = rkV.W;
    }

    public double Dot(Vector4d rkV) {
        return this.X * rkV.X + this.Y * rkV.Y + this.Z * rkV.Z + this.W * rkV.W;
    }

    public boolean equals(Object kObject) {
        Vector4d kV = (Vector4d)kObject;
        return this.X == kV.X && this.Y == kV.Y && this.Z == kV.Z && this.W == kV.W;
    }

    public boolean IsEqual(Vector4d rkV) {
        return Math.abs(this.X - rkV.X) < 1.0E-12 && Math.abs(this.Y - rkV.Y) < 1.0E-12 && Math.abs(this.Z - rkV.Z) < 1.0E-12 && Math.abs(this.W - rkV.W) < 1.0E-12;
    }

    public double Length() {
        return Math.sqrt(this.X * this.X + this.Y * this.Y + this.Z * this.Z + this.W * this.W);
    }

    public void Neg(Vector4d kV) {
        this.X = -kV.X;
        this.Y = -kV.Y;
        this.Z = -kV.Z;
        this.W = -kV.W;
    }

    public double Normalize() {
        double dLength = this.Length();
        if (dLength > 1.0E-12) {
            double dInvLength = 1.0 / dLength;
            this.X *= dInvLength;
            this.Y *= dInvLength;
            this.Z *= dInvLength;
            this.W *= dInvLength;
        } else {
            dLength = 0.0;
            this.X = 0.0;
            this.Y = 0.0;
            this.Z = 0.0;
            this.W = 0.0;
        }
        return dLength;
    }

    public void Scale(double dScalar) {
        this.X *= dScalar;
        this.Y *= dScalar;
        this.Z *= dScalar;
    }

    public void Set(double dX, double dY, double dZ, double dW) {
        this.X = dX;
        this.Y = dY;
        this.Z = dZ;
        this.W = dW;
    }

    public double SquaredLength() {
        return this.X * this.X + this.Y * this.Y + this.Z * this.Z + this.W * this.W;
    }

    public String toString() {
        return new String(this.X + " " + this.Y + " " + this.Z + " " + this.W);
    }
}

