/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Meshes;

import WildMagic.LibFoundation.Mathematics.GMatrixf;
import WildMagic.LibFoundation.Mathematics.Matrix2f;
import WildMagic.LibFoundation.Mathematics.Matrix3f;
import WildMagic.LibFoundation.Mathematics.Vector2f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class MeshCurvature
implements Serializable {
    private static final long serialVersionUID = 2373057866588764846L;
    protected int m_iVQuantity;
    protected final Vector3f[] m_akVertex;
    protected int m_iTQuantity;
    protected final int[] m_aiIndex;
    protected Vector3f[] m_akNormal;
    protected float[] m_afMinCurvature;
    protected float[] m_afMaxCurvature;
    protected float[] m_afMeanCurvature;
    protected Vector3f[] m_akMinDirection;
    protected Vector3f[] m_akMaxDirection;

    public MeshCurvature(int iVQuantity, Vector3f[] akVertex, int iTQuantity, int[] aiIndex) {
        int iV2;
        int iV1;
        int iV0;
        int i;
        this.m_iVQuantity = iVQuantity;
        this.m_akVertex = akVertex;
        this.m_iTQuantity = iTQuantity;
        this.m_aiIndex = aiIndex;
        Matrix3f[] akWWTrn = new Matrix3f[this.m_iVQuantity];
        Matrix3f[] akDWTrn = new Matrix3f[this.m_iVQuantity];
        this.m_akNormal = new Vector3f[this.m_iVQuantity];
        for (i = 0; i < this.m_iVQuantity; ++i) {
            this.m_akNormal[i] = new Vector3f();
            akWWTrn[i] = new Matrix3f();
            akDWTrn[i] = new Matrix3f();
        }
        Vector3f kEdge1 = new Vector3f();
        Vector3f kEdge2 = new Vector3f();
        Vector3f kNormal = new Vector3f();
        for (i = 0; i < this.m_iTQuantity; ++i) {
            iV0 = aiIndex[i * 3 + 0];
            iV1 = aiIndex[i * 3 + 1];
            iV2 = aiIndex[i * 3 + 2];
            kEdge1.Sub(this.m_akVertex[iV1], this.m_akVertex[iV0]);
            kEdge2.Sub(this.m_akVertex[iV2], this.m_akVertex[iV0]);
            kNormal.Cross(kEdge1, kEdge2);
            this.m_akNormal[iV0].Add(kNormal);
            this.m_akNormal[iV1].Add(kNormal);
            this.m_akNormal[iV2].Add(kNormal);
        }
        for (i = 0; i < this.m_iVQuantity; ++i) {
            this.m_akNormal[i].Normalize();
        }
        int[] aiV = new int[3];
        Vector3f kE = new Vector3f();
        Vector3f kW = new Vector3f();
        Vector3f kD = new Vector3f();
        Vector3f kNScale = new Vector3f();
        for (i = 0; i < this.m_iTQuantity; ++i) {
            aiV[0] = aiIndex[i * 3 + 0];
            aiV[1] = aiIndex[i * 3 + 1];
            aiV[2] = aiIndex[i * 3 + 2];
            for (int j = 0; j < 3; ++j) {
                iV0 = aiV[j];
                iV1 = aiV[(j + 1) % 3];
                iV2 = aiV[(j + 2) % 3];
                kE.Sub(this.m_akVertex[iV1], this.m_akVertex[iV0]);
                kNScale.Scale(kE.Dot(this.m_akNormal[iV0]), this.m_akNormal[iV0]);
                kW.Sub(kE, kNScale);
                kD.Sub(this.m_akNormal[iV1], this.m_akNormal[iV0]);
                akWWTrn[iV0].M00 += kW.X * kW.X;
                akWWTrn[iV0].M01 += kW.X * kW.Y;
                akWWTrn[iV0].M02 += kW.X * kW.Z;
                akWWTrn[iV0].M10 += kW.Y * kW.X;
                akWWTrn[iV0].M11 += kW.Y * kW.Y;
                akWWTrn[iV0].M12 += kW.Y * kW.Z;
                akWWTrn[iV0].M20 += kW.Z * kW.X;
                akWWTrn[iV0].M21 += kW.Z * kW.Y;
                akWWTrn[iV0].M22 += kW.Z * kW.Z;
                akDWTrn[iV0].M00 += kD.X * kW.X;
                akDWTrn[iV0].M01 += kD.X * kW.Y;
                akDWTrn[iV0].M02 += kD.X * kW.Z;
                akDWTrn[iV0].M10 += kD.Y * kW.X;
                akDWTrn[iV0].M11 += kD.Y * kW.Y;
                akDWTrn[iV0].M12 += kD.Y * kW.Z;
                akDWTrn[iV0].M20 += kD.Z * kW.X;
                akDWTrn[iV0].M21 += kD.Z * kW.Y;
                akDWTrn[iV0].M22 += kD.Z * kW.Z;
                kE.Sub(this.m_akVertex[iV2], this.m_akVertex[iV0]);
                kNScale.Scale(kE.Dot(this.m_akNormal[iV0]), this.m_akNormal[iV0]);
                kW.Sub(kE, kNScale);
                kD.Sub(this.m_akNormal[iV2], this.m_akNormal[iV0]);
                akWWTrn[iV0].M00 += kW.X * kW.X;
                akWWTrn[iV0].M01 += kW.X * kW.Y;
                akWWTrn[iV0].M02 += kW.X * kW.Z;
                akWWTrn[iV0].M10 += kW.Y * kW.X;
                akWWTrn[iV0].M11 += kW.Y * kW.Y;
                akWWTrn[iV0].M12 += kW.Y * kW.Z;
                akWWTrn[iV0].M20 += kW.Z * kW.X;
                akWWTrn[iV0].M21 += kW.Z * kW.Y;
                akWWTrn[iV0].M22 += kW.Z * kW.Z;
                akDWTrn[iV0].M00 += kD.X * kW.X;
                akDWTrn[iV0].M01 += kD.X * kW.Y;
                akDWTrn[iV0].M02 += kD.X * kW.Z;
                akDWTrn[iV0].M10 += kD.Y * kW.X;
                akDWTrn[iV0].M11 += kD.Y * kW.Y;
                akDWTrn[iV0].M12 += kD.Y * kW.Z;
                akDWTrn[iV0].M20 += kD.Z * kW.X;
                akDWTrn[iV0].M21 += kD.Z * kW.Y;
                akDWTrn[iV0].M22 += kD.Z * kW.Z;
            }
        }
        float[] afData = new float[9];
        GMatrixf fGmatrix = new GMatrixf(3, 3, afData);
        Matrix3f[] akDNormal = new Matrix3f[this.m_iVQuantity];
        for (i = 0; i < this.m_iVQuantity; ++i) {
            akWWTrn[i].M00 = 0.5f * akWWTrn[i].M00 + this.m_akNormal[i].X * this.m_akNormal[i].X;
            akWWTrn[i].M01 = 0.5f * akWWTrn[i].M01 + this.m_akNormal[i].X * this.m_akNormal[i].Y;
            akWWTrn[i].M02 = 0.5f * akWWTrn[i].M02 + this.m_akNormal[i].X * this.m_akNormal[i].Z;
            akWWTrn[i].M10 = 0.5f * akWWTrn[i].M10 + this.m_akNormal[i].Y * this.m_akNormal[i].X;
            akWWTrn[i].M11 = 0.5f * akWWTrn[i].M11 + this.m_akNormal[i].Y * this.m_akNormal[i].Y;
            akWWTrn[i].M12 = 0.5f * akWWTrn[i].M12 + this.m_akNormal[i].Y * this.m_akNormal[i].Z;
            akWWTrn[i].M20 = 0.5f * akWWTrn[i].M20 + this.m_akNormal[i].Z * this.m_akNormal[i].X;
            akWWTrn[i].M21 = 0.5f * akWWTrn[i].M21 + this.m_akNormal[i].Z * this.m_akNormal[i].Y;
            akWWTrn[i].M22 = 0.5f * akWWTrn[i].M22 + this.m_akNormal[i].Z * this.m_akNormal[i].Z;
            akDWTrn[i].Scale(0.5f);
            akDNormal[i] = new Matrix3f();
            akWWTrn[i].GetData(afData);
            fGmatrix.SetMatrix(3, 3, afData);
            fGmatrix.Inverse();
            akWWTrn[i].Set(fGmatrix.GetData(), true);
            akDNormal[i].Mult(akDWTrn[i], akWWTrn[i]);
        }
        akWWTrn = null;
        akDWTrn = null;
        this.m_afMinCurvature = new float[this.m_iVQuantity];
        this.m_afMaxCurvature = new float[this.m_iVQuantity];
        this.m_afMeanCurvature = new float[this.m_iVQuantity];
        this.m_akMinDirection = new Vector3f[this.m_iVQuantity];
        this.m_akMaxDirection = new Vector3f[this.m_iVQuantity];
        Vector3f kNormalmU = new Vector3f();
        Vector3f kNormalmV = new Vector3f();
        Vector3f kU = new Vector3f();
        Vector3f kV = new Vector3f();
        Matrix2f kS = new Matrix2f();
        Vector2f kW0 = new Vector2f();
        Vector2f kW1 = new Vector2f();
        Vector3f kUScale = new Vector3f();
        Vector3f kVScale = new Vector3f();
        for (i = 0; i < this.m_iVQuantity; ++i) {
            Vector3f.GenerateComplementBasis(kU, kV, this.m_akNormal[i]);
            akDNormal[i].Mult(kU, kNormalmU);
            akDNormal[i].Mult(kV, kNormalmV);
            float fS01 = kU.Dot(kNormalmV);
            float fS10 = kV.Dot(kNormalmU);
            float fSAvr = 0.5f * (fS01 + fS10);
            kS.Set(kU.Dot(kNormalmU), fSAvr, fSAvr, kV.Dot(kNormalmV));
            float fTrace = kS.M00 + kS.M11;
            float fDet = kS.M00 * kS.M11 - kS.M01 * kS.M10;
            float fDiscr = fTrace * fTrace - 4.0f * fDet;
            float fRootDiscr = (float)Math.sqrt(Math.abs(fDiscr));
            this.m_afMinCurvature[i] = 0.5f * (fTrace - fRootDiscr);
            this.m_afMaxCurvature[i] = 0.5f * (fTrace + fRootDiscr);
            this.m_afMeanCurvature[i] = 0.5f * (this.m_afMinCurvature[i] + this.m_afMaxCurvature[i]);
            kW0.Set(kS.M01, this.m_afMinCurvature[i] - kS.M00);
            kW1.Set(this.m_afMinCurvature[i] - kS.M11, kS.M10);
            if (kW0.SquaredLength() >= kW1.SquaredLength()) {
                kW0.Normalize();
                kUScale.Scale(kW0.X, kU);
                kVScale.Scale(kW0.Y, kV);
                this.m_akMinDirection[i] = new Vector3f();
                this.m_akMinDirection[i].Add(kUScale, kVScale);
            } else {
                kW1.Normalize();
                kUScale.Scale(kW1.X, kU);
                kVScale.Scale(kW1.Y, kV);
                this.m_akMinDirection[i] = new Vector3f();
                this.m_akMinDirection[i].Add(kUScale, kVScale);
            }
            kW0.Set(kS.M01, this.m_afMaxCurvature[i] - kS.M00);
            kW1.Set(this.m_afMaxCurvature[i] - kS.M11, kS.M10);
            if (kW0.SquaredLength() >= kW1.SquaredLength()) {
                kW0.Normalize();
                kUScale.Scale(kW0.X, kU);
                kVScale.Scale(kW0.Y, kV);
                this.m_akMaxDirection[i] = new Vector3f();
                this.m_akMaxDirection[i].Add(kUScale, kVScale);
                continue;
            }
            kW1.Normalize();
            kUScale.Scale(kW1.X, kU);
            kVScale.Scale(kW1.Y, kV);
            this.m_akMaxDirection[i] = new Vector3f();
            this.m_akMaxDirection[i].Add(kUScale, kVScale);
        }
        akDNormal = null;
    }

    public void dispose() {
        this.m_akNormal = null;
        this.m_afMinCurvature = null;
        this.m_afMaxCurvature = null;
        this.m_akMinDirection = null;
        this.m_akMaxDirection = null;
    }

    public final int[] GetIndices() {
        return this.m_aiIndex;
    }

    public final float[] GetMaxCurvatures() {
        return this.m_afMaxCurvature;
    }

    public final Vector3f[] GetMaxDirections() {
        return this.m_akMaxDirection;
    }

    public float[] GetMeanCurvatures() {
        return this.m_afMeanCurvature;
    }

    public final float[] GetMinCurvatures() {
        return this.m_afMinCurvature;
    }

    public final Vector3f[] GetMinDirections() {
        return this.m_akMinDirection;
    }

    public final Vector3f[] GetNormals() {
        return this.m_akNormal;
    }

    public int GetTQuantity() {
        return this.m_iTQuantity;
    }

    public final Vector3f[] GetVertices() {
        return this.m_akVertex;
    }

    public int GetVQuantity() {
        return this.m_iVQuantity;
    }
}

