/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.Meshes;

import WildMagic.LibFoundation.System.TSmallUnorderedSet;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public class VETMesh
implements Serializable {
    private static final long serialVersionUID = -5441733056532429719L;
    protected HashMap<Edge, EdgeAttribute> m_kEMap;
    protected HashMap<Triangle, TriangleAttribute> m_kTMap;
    protected HashMap<Vertex, VertexAttribute> m_kVMap;

    public VETMesh() {
        this.m_kVMap = new HashMap();
        this.m_kEMap = new HashMap();
        this.m_kTMap = new HashMap();
    }

    public VETMesh(int iVCapacity, float fVLoad, int iECapacity, float fELoad, int iTCapacity, float fTLoad) {
        this.m_kVMap = new HashMap(iVCapacity, fVLoad);
        this.m_kEMap = new HashMap(iECapacity, fELoad);
        this.m_kTMap = new HashMap(iTCapacity, fTLoad);
    }

    public VETMesh(int iVCapacity, float fVLoad, int iECapacity, float fELoad, int iTCapacity, float fTLoad, int[] aiConnect) {
        this.m_kVMap = new HashMap(iVCapacity, fVLoad);
        this.m_kEMap = new HashMap(iECapacity, fELoad);
        this.m_kTMap = new HashMap(iTCapacity, fTLoad);
        for (int i = 0; i < aiConnect.length; i += 3) {
            int iV0 = aiConnect[i];
            int iV1 = aiConnect[i + 1];
            int iV2 = aiConnect[i + 2];
            this.InsertTriangle(iV0, iV1, iV2);
        }
    }

    public VETMesh Create() {
        return new VETMesh();
    }

    public void GetComponents(Vector<VETMesh> kComponents) {
        int iTSize = this.m_kTMap.size();
        if (iTSize == 0) {
            return;
        }
        HashMap<Triangle, Boolean> kVisitedMap = new HashMap<Triangle, Boolean>();
        for (Map.Entry<Triangle, TriangleAttribute> kTMEntry : this.m_kTMap.entrySet()) {
            kVisitedMap.put(kTMEntry.getKey(), Boolean.FALSE);
        }
        while (iTSize > 0) {
            Stack<Object> kStack = new Stack<Object>();
            for (Map.Entry entry : kVisitedMap.entrySet()) {
                if (entry.getValue() != Boolean.FALSE) continue;
                kStack.push(entry.getKey());
                entry.setValue(Boolean.TRUE);
                --iTSize;
                break;
            }
            VETMesh kComponent = this.Create();
            while (!kStack.empty()) {
                Triangle kT = (Triangle)kStack.pop();
                kComponent.InsertTriangle(kT);
                int iV0 = 0;
                int iV1 = 0;
                for (int i = 0; i < 3; ++i) {
                    switch (i) {
                        case 0: {
                            iV0 = kT.m_iV0;
                            iV1 = kT.m_iV1;
                            break;
                        }
                        case 1: {
                            iV0 = kT.m_iV1;
                            iV1 = kT.m_iV2;
                            break;
                        }
                        case 2: {
                            iV0 = kT.m_iV2;
                            iV1 = kT.m_iV0;
                        }
                    }
                    Edge kE = new Edge(iV0, iV1);
                    EdgeAttribute kEAttr = this.m_kEMap.get(kE);
                    for (int j = 0; j < kEAttr.m_kTSet.GetQuantity(); ++j) {
                        Triangle kTAdj = (Triangle)kEAttr.m_kTSet.GetElement(j);
                        Boolean kVisited = (Boolean)kVisitedMap.get(kTAdj);
                        if (kVisited != Boolean.FALSE) continue;
                        kStack.push(kTAdj);
                        kVisitedMap.put(kTAdj, Boolean.TRUE);
                        --iTSize;
                    }
                }
            }
            kComponents.add(kComponent);
        }
    }

    public boolean GetConsistentComponents(Vector<VETMesh> kComponents) {
        if (!this.IsManifold()) {
            return false;
        }
        int iTSize = this.m_kTMap.size();
        if (iTSize == 0) {
            return true;
        }
        HashMap<Triangle, Boolean> kVisitedMap = new HashMap<Triangle, Boolean>();
        for (Map.Entry<Triangle, TriangleAttribute> kTMEntry : this.m_kTMap.entrySet()) {
            kVisitedMap.put(kTMEntry.getKey(), Boolean.FALSE);
        }
        while (iTSize > 0) {
            Stack<Object> kStack = new Stack<Object>();
            for (Map.Entry entry : kVisitedMap.entrySet()) {
                if (entry.getValue() != Boolean.FALSE) continue;
                kStack.push(entry.getKey());
                entry.setValue(Boolean.TRUE);
                --iTSize;
                break;
            }
            VETMesh kComponent = this.Create();
            while (!kStack.empty()) {
                Triangle kT = (Triangle)kStack.pop();
                kComponent.InsertTriangle(kT);
                int iV0 = 0;
                int iV1 = 0;
                int iV2 = 0;
                for (int i = 0; i < 3; ++i) {
                    Boolean kVisited;
                    switch (i) {
                        case 0: {
                            iV0 = kT.m_iV0;
                            iV1 = kT.m_iV1;
                            break;
                        }
                        case 1: {
                            iV0 = kT.m_iV1;
                            iV1 = kT.m_iV2;
                            break;
                        }
                        case 2: {
                            iV0 = kT.m_iV2;
                            iV1 = kT.m_iV0;
                        }
                    }
                    Edge kE = new Edge(iV0, iV1);
                    EdgeAttribute kEAttr = this.m_kEMap.get(kE);
                    if (kEAttr.m_kTSet.GetQuantity() != 2) continue;
                    Triangle kTAdj = (Triangle)kEAttr.m_kTSet.GetElement(0);
                    if (kTAdj == kT) {
                        kTAdj = (Triangle)kEAttr.m_kTSet.GetElement(1);
                    }
                    if ((kVisited = (Boolean)kVisitedMap.get(kTAdj)) != Boolean.FALSE) continue;
                    if (kTAdj.m_iV0 == iV0 && kTAdj.m_iV1 == iV1 || kTAdj.m_iV1 == iV0 && kTAdj.m_iV2 == iV1 || kTAdj.m_iV2 == iV0 && kTAdj.m_iV0 == iV1) {
                        iV0 = kTAdj.m_iV0;
                        iV1 = kTAdj.m_iV1;
                        iV2 = kTAdj.m_iV2;
                        kVisitedMap.remove(kTAdj);
                        this.RemoveTriangle(iV0, iV1, iV2);
                        this.InsertTriangle(iV1, iV0, iV2);
                        kVisitedMap.put(new Triangle(iV1, iV0, iV2), Boolean.FALSE);
                        kEAttr = this.m_kEMap.get(kE);
                        kTAdj = (Triangle)kEAttr.m_kTSet.GetElement(0);
                        if (kTAdj == kT) {
                            kTAdj = (Triangle)kEAttr.m_kTSet.GetElement(1);
                        }
                        kVisited = (Boolean)kVisitedMap.get(kTAdj);
                    }
                    kStack.push(kTAdj);
                    kVisitedMap.put(kTAdj, Boolean.TRUE);
                    --iTSize;
                }
            }
            kComponents.add(kComponent);
        }
        return true;
    }

    public Object GetData(Edge kE) {
        EdgeAttribute kEAttr = this.m_kEMap.get(kE);
        return kEAttr != null ? kEAttr.m_kData : null;
    }

    public Object GetData(Triangle kT) {
        TriangleAttribute kTAttr = this.m_kTMap.get(kT);
        return kTAttr != null ? kTAttr.m_kData : null;
    }

    public Object GetData(Vertex kV) {
        VertexAttribute kVAttr = this.m_kVMap.get(kV);
        return kVAttr != null ? kVAttr.m_kData : null;
    }

    public HashMap<Edge, EdgeAttribute> GetEdgeMap() {
        return this.m_kEMap;
    }

    public int GetEdgeQuantity() {
        return this.m_kEMap.size();
    }

    public VETMesh GetReversedOrderMesh() {
        VETMesh kReversed = this.Create();
        for (Triangle kT : this.m_kTMap.keySet()) {
            kReversed.InsertTriangle(kT.m_iV0, kT.m_iV2, kT.m_iV1);
        }
        return kReversed;
    }

    public HashMap<Triangle, TriangleAttribute> GetTriangleMap() {
        return this.m_kTMap;
    }

    public int GetTriangleQuantity() {
        return this.m_kTMap.size();
    }

    public int[] GetTriangles() {
        int iTSize = this.m_kTMap.size();
        if (iTSize == 0) {
            return null;
        }
        int[] aiConnect = new int[iTSize * 3];
        int iIndex = 0;
        for (Triangle kT : this.m_kTMap.keySet()) {
            aiConnect[iIndex++] = kT.m_iV0;
            aiConnect[iIndex++] = kT.m_iV1;
            aiConnect[iIndex++] = kT.m_iV2;
        }
        return aiConnect;
    }

    public HashMap<Vertex, VertexAttribute> GetVertexMap() {
        return this.m_kVMap;
    }

    public int GetVertexQuantity() {
        return this.m_kVMap.size();
    }

    public void InsertTriangle(int iV0, int iV1, int iV2) {
        boolean bE2Created;
        boolean bE1Created;
        boolean bE0Created;
        boolean bV2Created;
        boolean bV1Created;
        VertexAttribute kV0Attr;
        boolean bV0Created;
        boolean bTCreated;
        Vertex kV0 = new Vertex(iV0);
        Vertex kV1 = new Vertex(iV1);
        Vertex kV2 = new Vertex(iV2);
        Edge kE0 = new Edge(iV0, iV1);
        Edge kE1 = new Edge(iV1, iV2);
        Edge kE2 = new Edge(iV2, iV0);
        Triangle kT = new Triangle(iV0, iV1, iV2);
        TriangleAttribute kTAttr = this.m_kTMap.get(kT);
        boolean bl = bTCreated = kTAttr == null;
        if (bTCreated) {
            kTAttr = new TriangleAttribute();
            this.m_kTMap.put(kT, kTAttr);
        }
        boolean bl2 = bV0Created = (kV0Attr = this.m_kVMap.get(kV0)) == null;
        if (bV0Created) {
            kV0Attr = new VertexAttribute();
            this.m_kVMap.put(kV0, kV0Attr);
        }
        kV0Attr.m_kESet.Insert(kE0);
        kV0Attr.m_kESet.Insert(kE2);
        kV0Attr.m_kTSet.Insert(kT);
        VertexAttribute kV1Attr = this.m_kVMap.get(kV1);
        boolean bl3 = bV1Created = kV1Attr == null;
        if (bV1Created) {
            kV1Attr = new VertexAttribute();
            this.m_kVMap.put(kV1, kV1Attr);
        }
        kV1Attr.m_kESet.Insert(kE0);
        kV1Attr.m_kESet.Insert(kE1);
        kV1Attr.m_kTSet.Insert(kT);
        VertexAttribute kV2Attr = this.m_kVMap.get(kV2);
        boolean bl4 = bV2Created = kV2Attr == null;
        if (bV2Created) {
            kV2Attr = new VertexAttribute();
            this.m_kVMap.put(kV2, kV2Attr);
        }
        kV2Attr.m_kESet.Insert(kE1);
        kV2Attr.m_kESet.Insert(kE2);
        kV2Attr.m_kTSet.Insert(kT);
        EdgeAttribute kE0Attr = this.m_kEMap.get(kE0);
        boolean bl5 = bE0Created = kE0Attr == null;
        if (bE0Created) {
            kE0Attr = new EdgeAttribute();
            this.m_kEMap.put(kE0, kE0Attr);
        }
        kE0Attr.m_kTSet.Insert(kT);
        EdgeAttribute kE1Attr = this.m_kEMap.get(kE1);
        boolean bl6 = bE1Created = kE1Attr == null;
        if (bE1Created) {
            kE1Attr = new EdgeAttribute();
            this.m_kEMap.put(kE1, kE1Attr);
        }
        kE1Attr.m_kTSet.Insert(kT);
        EdgeAttribute kE2Attr = this.m_kEMap.get(kE2);
        boolean bl7 = bE2Created = kE2Attr == null;
        if (bE2Created) {
            kE2Attr = new EdgeAttribute();
            this.m_kEMap.put(kE2, kE2Attr);
        }
        kE2Attr.m_kTSet.Insert(kT);
        this.OnVertexInsert(kV0, bV0Created, kV0Attr);
        this.OnVertexInsert(kV1, bV1Created, kV1Attr);
        this.OnVertexInsert(kV2, bV2Created, kV2Attr);
        this.OnEdgeInsert(kE0, bE0Created, kE0Attr);
        this.OnEdgeInsert(kE1, bE1Created, kE1Attr);
        this.OnEdgeInsert(kE2, bE2Created, kE2Attr);
        this.OnTriangleInsert(kT, bTCreated, kTAttr);
    }

    public void InsertTriangle(Triangle kT) {
        this.InsertTriangle(kT.m_iV0, kT.m_iV1, kT.m_iV2);
    }

    public boolean IsClosed() {
        return this.IsManifold();
    }

    public boolean IsConnected() {
        int iTSize = this.m_kTMap.size();
        if (iTSize == 0) {
            return true;
        }
        HashMap<Triangle, Boolean> kVisitedMap = new HashMap<Triangle, Boolean>();
        Iterator<Map.Entry<Triangle, TriangleAttribute>> kTIter = this.m_kTMap.entrySet().iterator();
        Map.Entry<Triangle, TriangleAttribute> kTMEntry = null;
        while (kTIter.hasNext()) {
            kTMEntry = kTIter.next();
            kVisitedMap.put(kTMEntry.getKey(), Boolean.FALSE);
        }
        Stack<Triangle> kStack = new Stack<Triangle>();
        Triangle kT = this.m_kTMap.keySet().iterator().next();
        kStack.push(kT);
        kVisitedMap.put(kTMEntry.getKey(), Boolean.TRUE);
        --iTSize;
        while (!kStack.empty()) {
            kT = (Triangle)kStack.pop();
            int iV0 = 0;
            int iV1 = 0;
            for (int i = 0; i < 3; ++i) {
                switch (i) {
                    case 0: {
                        iV0 = kT.m_iV0;
                        iV1 = kT.m_iV1;
                        break;
                    }
                    case 1: {
                        iV0 = kT.m_iV1;
                        iV1 = kT.m_iV2;
                        break;
                    }
                    case 2: {
                        iV0 = kT.m_iV2;
                        iV1 = kT.m_iV0;
                    }
                }
                Edge kE = new Edge(iV0, iV1);
                EdgeAttribute kEAttr = this.m_kEMap.get(kE);
                for (int j = 0; j < kEAttr.m_kTSet.GetQuantity(); ++j) {
                    Triangle kTAdj = (Triangle)kEAttr.m_kTSet.GetElement(j);
                    Boolean kVisited = (Boolean)kVisitedMap.get(kTAdj);
                    if (kVisited != Boolean.FALSE) continue;
                    kStack.push(kTAdj);
                    kVisitedMap.put(kTAdj, Boolean.TRUE);
                    kVisited = (Boolean)kVisitedMap.get(kTAdj);
                    --iTSize;
                }
            }
        }
        return iTSize == 0;
    }

    public boolean IsManifold() {
        for (EdgeAttribute kEAttr : this.m_kEMap.values()) {
            if (kEAttr.m_kTSet.GetQuantity() == 2) continue;
            return false;
        }
        return true;
    }

    public void OnEdgeInsert(Edge kE, boolean bCreate, EdgeAttribute kEAttr) {
    }

    public void OnEdgeRemove(Edge kE, boolean bDestroy, EdgeAttribute kEAttr) {
    }

    public void OnTriangleInsert(Triangle kT, boolean bCreate, TriangleAttribute kTAttr) {
    }

    public void OnTriangleRemove(Triangle kT, boolean bDestroy, TriangleAttribute kTAttr) {
    }

    public void OnVertexInsert(Vertex kV, boolean bCreate, VertexAttribute kVAttr) {
    }

    public void OnVertexRemove(Vertex kV, boolean bDestroy, VertexAttribute kVAttr) {
    }

    public int RemoveComponent(int iOffset, int[] aiConnect) {
        int iComponentIQuantity = 0;
        int iTSize = this.m_kTMap.size();
        if (iTSize == 0) {
            return 0;
        }
        HashSet<Triangle> kVisited = new HashSet<Triangle>();
        Iterator<Map.Entry<Triangle, TriangleAttribute>> kTIter = this.m_kTMap.entrySet().iterator();
        Map.Entry<Triangle, TriangleAttribute> kEntry = kTIter.next();
        kVisited.add(kEntry.getKey());
        while (!kVisited.isEmpty()) {
            Triangle kT = (Triangle)kVisited.iterator().next();
            int iV0 = 0;
            int iV1 = 0;
            for (int i = 0; i < 3; ++i) {
                switch (i) {
                    case 0: {
                        iV0 = kT.m_iV0;
                        iV1 = kT.m_iV1;
                        break;
                    }
                    case 1: {
                        iV0 = kT.m_iV1;
                        iV1 = kT.m_iV2;
                        break;
                    }
                    case 2: {
                        iV0 = kT.m_iV2;
                        iV1 = kT.m_iV0;
                    }
                }
                Edge kE = new Edge(iV0, iV1);
                EdgeAttribute kEAttr = this.m_kEMap.get(kE);
                for (int j = 0; j < kEAttr.m_kTSet.GetQuantity(); ++j) {
                    Triangle kTAdj = (Triangle)kEAttr.m_kTSet.GetElement(j);
                    if (kTAdj == kT) continue;
                    kVisited.add(kTAdj);
                }
            }
            aiConnect[iOffset + iComponentIQuantity++] = kT.m_iV0;
            aiConnect[iOffset + iComponentIQuantity++] = kT.m_iV1;
            aiConnect[iOffset + iComponentIQuantity++] = kT.m_iV2;
            kVisited.remove(kT);
            this.RemoveTriangle(kT);
        }
        return iComponentIQuantity;
    }

    public void RemoveTriangle(int iV0, int iV1, int iV2) {
        Triangle kT = new Triangle(iV0, iV1, iV2);
        TriangleAttribute kTAttr = this.m_kTMap.get(kT);
        if (kTAttr == null) {
            return;
        }
        Edge kE0 = new Edge(iV0, iV1);
        EdgeAttribute kE0Attr = this.m_kEMap.get(kE0);
        kE0Attr.m_kTSet.Remove(kT);
        Edge kE1 = new Edge(iV1, iV2);
        EdgeAttribute kE1Attr = this.m_kEMap.get(kE1);
        kE1Attr.m_kTSet.Remove(kT);
        Edge kE2 = new Edge(iV2, iV0);
        EdgeAttribute kE2Attr = this.m_kEMap.get(kE2);
        kE2Attr.m_kTSet.Remove(kT);
        Vertex kV0 = new Vertex(iV0);
        VertexAttribute kV0Attr = this.m_kVMap.get(kV0);
        kV0Attr.m_kTSet.Remove(kT);
        Vertex kV1 = new Vertex(iV1);
        VertexAttribute kV1Attr = this.m_kVMap.get(kV1);
        kV1Attr.m_kTSet.Remove(kT);
        Vertex kV2 = new Vertex(iV2);
        VertexAttribute kV2Attr = this.m_kVMap.get(kV2);
        kV2Attr.m_kTSet.Remove(kT);
        if (kE0Attr.m_kTSet.IsEmpty()) {
            kV0Attr.m_kESet.Remove(kE0);
            kV1Attr.m_kESet.Remove(kE0);
        }
        if (kE1Attr.m_kTSet.IsEmpty()) {
            kV1Attr.m_kESet.Remove(kE1);
            kV2Attr.m_kESet.Remove(kE1);
        }
        if (kE2Attr.m_kTSet.IsEmpty()) {
            kV0Attr.m_kESet.Remove(kE2);
            kV2Attr.m_kESet.Remove(kE2);
        }
        boolean bDestroyed = kV0Attr.IsEmpty();
        this.OnVertexRemove(kV0, bDestroyed, kV0Attr);
        if (bDestroyed) {
            this.m_kVMap.remove(kV0);
        }
        bDestroyed = kV1Attr.IsEmpty();
        this.OnVertexRemove(kV1, bDestroyed, kV1Attr);
        if (bDestroyed) {
            this.m_kVMap.remove(kV1);
        }
        bDestroyed = kV2Attr.IsEmpty();
        this.OnVertexRemove(kV2, bDestroyed, kV2Attr);
        if (bDestroyed) {
            this.m_kVMap.remove(kV2);
        }
        bDestroyed = kE0Attr.IsEmpty();
        this.OnEdgeRemove(kE0, bDestroyed, kE0Attr);
        if (bDestroyed) {
            this.m_kEMap.remove(kE0);
        }
        bDestroyed = kE1Attr.IsEmpty();
        this.OnEdgeRemove(kE1, bDestroyed, kE1Attr);
        if (bDestroyed) {
            this.m_kEMap.remove(kE1);
        }
        bDestroyed = kE2Attr.IsEmpty();
        this.OnEdgeRemove(kE2, bDestroyed, kE2Attr);
        if (bDestroyed) {
            this.m_kEMap.remove(kE2);
        }
        this.OnTriangleRemove(kT, true, kTAttr);
        this.m_kTMap.remove(kT);
    }

    public void RemoveTriangle(Triangle kT) {
        this.RemoveTriangle(kT.m_iV0, kT.m_iV1, kT.m_iV2);
    }

    public void SetData(Edge kE, Object kData) {
        EdgeAttribute kEAttr = this.m_kEMap.get(kE);
        if (kEAttr != null) {
            kEAttr.m_kData = kData;
        }
    }

    public void SetData(Triangle kT, Object kData) {
        TriangleAttribute kTAttr = this.m_kTMap.get(kT);
        if (kTAttr != null) {
            kTAttr.m_kData = kData;
        }
    }

    public void SetData(Vertex kV, Object kData) {
        VertexAttribute kVAttr = this.m_kVMap.get(kV);
        if (kVAttr != null) {
            kVAttr.m_kData = kData;
        }
    }

    protected class VertexAttribute {
        public Object m_kData = null;
        public TSmallUnorderedSet m_kESet = new TSmallUnorderedSet(8, 8);
        public TSmallUnorderedSet m_kTSet = new TSmallUnorderedSet(8, 8);

        public boolean IsEmpty() {
            return this.m_kESet.IsEmpty() && this.m_kTSet.IsEmpty();
        }
    }

    protected class TriangleAttribute {
        public Object m_kData = null;
    }

    protected class EdgeAttribute {
        public Object m_kData = null;
        public TSmallUnorderedSet m_kTSet = new TSmallUnorderedSet(4, 4);

        public boolean IsEmpty() {
            return this.m_kTSet.IsEmpty();
        }
    }

    public class Vertex {
        public int m_iV;

        public Vertex(int iV) {
            this.m_iV = iV;
        }

        public boolean equals(Object kObject) {
            Vertex kV = (Vertex)kObject;
            return this.m_iV == kV.m_iV;
        }

        public int hashCode() {
            return this.m_iV;
        }
    }

    public class Triangle {
        public int m_iV0;
        public int m_iV1;
        public int m_iV2;

        public Triangle(int iV0, int iV1, int iV2) {
            if (iV0 < iV1) {
                if (iV0 < iV2) {
                    this.m_iV0 = iV0;
                    this.m_iV1 = iV1;
                    this.m_iV2 = iV2;
                } else {
                    this.m_iV0 = iV2;
                    this.m_iV1 = iV0;
                    this.m_iV2 = iV1;
                }
            } else if (iV1 < iV2) {
                this.m_iV0 = iV1;
                this.m_iV1 = iV2;
                this.m_iV2 = iV0;
            } else {
                this.m_iV0 = iV2;
                this.m_iV1 = iV0;
                this.m_iV2 = iV1;
            }
        }

        public boolean equals(Object kObject) {
            Triangle kT = (Triangle)kObject;
            return this.m_iV0 == kT.m_iV0 && this.m_iV1 == kT.m_iV1 && this.m_iV2 == kT.m_iV2;
        }

        public int hashCode() {
            int iCmp = this.m_iV1 < this.m_iV2 ? this.m_iV1 << 8 ^ (this.m_iV0 << 16 | this.m_iV2) : this.m_iV2 << 8 ^ (this.m_iV0 << 16 | this.m_iV1);
            return iCmp;
        }
    }

    public static class Statistics {
        public float m_fAverageEdgesPerVertex;
        public float m_fAverageTrianglesPerEdge;
        public float m_fAverageTrianglesPerVertex;
        public int m_iEQuantity;
        public int m_iMaximumEdgesPerVertex;
        public int m_iMaximumTrianglesPerEdge;
        public int m_iMaximumTrianglesPerVertex;
        public int m_iTQuantity;
        public int m_iVQuantity;

        public Statistics(VETMesh kTopo) {
            int iTSize;
            this.m_iVQuantity = kTopo.m_kVMap.size();
            this.m_iEQuantity = kTopo.m_kEMap.size();
            this.m_iTQuantity = kTopo.m_kTMap.size();
            int iESumForV = 0;
            int iTSumForV = 0;
            this.m_iMaximumEdgesPerVertex = 0;
            this.m_iMaximumTrianglesPerVertex = 0;
            for (Map.Entry<Vertex, VertexAttribute> entry : kTopo.m_kVMap.entrySet()) {
                VertexAttribute kVAttr = entry.getValue();
                int iESize = kVAttr.m_kESet.GetQuantity();
                iTSize = kVAttr.m_kTSet.GetQuantity();
                iESumForV += iESize;
                iTSumForV += iTSize;
                if (iESize > this.m_iMaximumEdgesPerVertex) {
                    this.m_iMaximumEdgesPerVertex = iESize;
                }
                if (iTSize <= this.m_iMaximumTrianglesPerVertex) continue;
                this.m_iMaximumTrianglesPerVertex = iTSize;
            }
            int iTSumForE = 0;
            this.m_iMaximumTrianglesPerEdge = 0;
            for (Map.Entry<Edge, EdgeAttribute> entry : kTopo.m_kEMap.entrySet()) {
                EdgeAttribute kEAttr = entry.getValue();
                iTSize = kEAttr.m_kTSet.GetQuantity();
                iTSumForE += iTSize;
                if (iTSize <= this.m_iMaximumTrianglesPerEdge) continue;
                this.m_iMaximumTrianglesPerEdge = iTSize;
            }
            this.m_fAverageEdgesPerVertex = (float)iESumForV / (float)this.m_iVQuantity;
            this.m_fAverageTrianglesPerVertex = (float)iTSumForV / (float)this.m_iVQuantity;
            this.m_fAverageTrianglesPerEdge = (float)iTSumForE / (float)this.m_iEQuantity;
        }

        public void print() {
            System.err.print("vertex quantity = ");
            System.err.print(this.m_iVQuantity + "\n");
            System.err.print("edge quantity = ");
            System.err.print(this.m_iEQuantity + "\n");
            System.err.print("triangle quantity = ");
            System.err.print(this.m_iTQuantity + "\n");
            System.err.print("average edges per vertex = ");
            System.err.print(this.m_fAverageEdgesPerVertex + "\n");
            System.err.print("average triangles per vertex = ");
            System.err.print(this.m_fAverageTrianglesPerVertex + "\n");
            System.err.print("average triangles per edge = ");
            System.err.print(this.m_fAverageTrianglesPerEdge + "\n");
            System.err.print("maximum edges per vertex = ");
            System.err.print(this.m_iMaximumEdgesPerVertex + "\n");
            System.err.print("maximum triangles per vertex = ");
            System.err.print(this.m_iMaximumTrianglesPerVertex + "\n");
            System.err.print("maximum triangles per edge = ");
            System.err.print(this.m_iMaximumTrianglesPerEdge + "\n");
        }
    }

    public class Edge {
        public int m_iV0;
        public int m_iV1;

        public Edge(int iV0, int iV1) {
            if (iV0 < iV1) {
                this.m_iV0 = iV0;
                this.m_iV1 = iV1;
            } else {
                this.m_iV0 = iV1;
                this.m_iV1 = iV0;
            }
        }

        public boolean equals(Object kObject) {
            Edge kE = (Edge)kObject;
            return this.m_iV0 == kE.m_iV0 && this.m_iV1 == kE.m_iV1;
        }

        public int hashCode() {
            return this.m_iV0 << 16 | this.m_iV1;
        }
    }
}

