/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.NumericalAnalysis;

import WildMagic.LibFoundation.Mathematics.GMatrixf;
import WildMagic.LibFoundation.Mathematics.GVectorf;
import WildMagic.LibFoundation.Mathematics.Matrix3f;
import WildMagic.LibFoundation.Mathematics.Vector2f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import java.io.Serializable;

public class Eigenf
implements Serializable {
    private static final long serialVersionUID = -4884216803495497983L;
    private int m_iSize;
    private GMatrixf m_kMat;
    private float[] m_afDiag;
    private float[] m_afSubd;
    private boolean m_bIsRotation;

    public Eigenf(int iSize) {
        this.m_kMat = new GMatrixf(iSize, iSize);
        assert (iSize >= 2);
        this.m_iSize = iSize;
        this.m_afDiag = new float[this.m_iSize];
        this.m_afSubd = new float[this.m_iSize];
        this.m_bIsRotation = false;
    }

    public Eigenf(Matrix3f rkM) {
        float[] afData = new float[9];
        rkM.GetData(afData);
        this.m_kMat = new GMatrixf(3, 3, afData);
        this.m_iSize = 3;
        this.m_afDiag = new float[this.m_iSize];
        this.m_afSubd = new float[this.m_iSize];
        this.m_bIsRotation = false;
    }

    public void dispose() {
        this.m_kMat.dispose();
        this.m_afSubd = null;
        this.m_afDiag = null;
    }

    public float GetEigenvalue(int i) {
        return this.m_afDiag[i];
    }

    public double GetEigenvector(int iRow, int iCol) {
        return this.m_kMat.Get(iRow, iCol);
    }

    public void GetEigenvector(int i, Vector2f rkV) {
        assert (this.m_iSize == 2);
        if (this.m_iSize == 2) {
            rkV.Set(this.m_kMat.Get(0, i), this.m_kMat.Get(1, i));
        } else {
            rkV.Copy(Vector2f.ZERO);
        }
    }

    public void GetEigenvector(int i, Vector3f rkV) {
        assert (this.m_iSize == 3);
        if (this.m_iSize == 3) {
            rkV.Set(this.m_kMat.Get(0, i), this.m_kMat.Get(1, i), this.m_kMat.Get(2, i));
        } else {
            rkV.Copy(Vector3f.ZERO);
        }
    }

    public GVectorf GetEigenvector(int i) {
        return this.m_kMat.GetColumn(i);
    }

    public void IncrSortEigenStuff2() {
        this.Tridiagonal2();
        this.QLAlgorithm();
        this.IncreasingSort();
        this.GuaranteeRotation();
    }

    public void IncrSortEigenStuff3() {
        this.Tridiagonal3();
        this.QLAlgorithm();
        this.IncreasingSort();
        this.GuaranteeRotation();
    }

    public void IncrSortEigenStuffN() {
        this.TridiagonalN();
        this.QLAlgorithm();
        this.IncreasingSort();
        this.GuaranteeRotation();
    }

    public void IncrSortEigenStuff() {
        switch (this.m_iSize) {
            case 2: {
                this.Tridiagonal2();
                break;
            }
            case 3: {
                this.Tridiagonal3();
                break;
            }
            default: {
                this.TridiagonalN();
            }
        }
        this.QLAlgorithm();
        this.IncreasingSort();
        this.GuaranteeRotation();
    }

    public void DecrSortEigenStuff2() {
        this.Tridiagonal2();
        this.QLAlgorithm();
        this.DecreasingSort();
        this.GuaranteeRotation();
    }

    public void DecrSortEigenStuff3() {
        this.Tridiagonal3();
        this.QLAlgorithm();
        this.DecreasingSort();
        this.GuaranteeRotation();
    }

    public void DecrSortEigenStuffN() {
        this.TridiagonalN();
        this.QLAlgorithm();
        this.DecreasingSort();
        this.GuaranteeRotation();
    }

    public void DecrSortEigenStuff() {
        switch (this.m_iSize) {
            case 2: {
                this.Tridiagonal2();
                break;
            }
            case 3: {
                this.Tridiagonal3();
                break;
            }
            default: {
                this.TridiagonalN();
            }
        }
        this.QLAlgorithm();
        this.DecreasingSort();
        this.GuaranteeRotation();
    }

    public void SetData(int iRow, int iCol, float fValue) {
        this.m_kMat.Set(iRow, iCol, fValue);
    }

    public float GetData(int iRow, int iCol) {
        return this.m_kMat.Get(iRow, iCol);
    }

    public void AddToData(int iRow, int iCol, float fValue) {
        this.m_kMat.Set(iRow, iCol, this.m_kMat.Get(iRow, iCol) + fValue);
    }

    private void GuaranteeRotation() {
        if (!this.m_bIsRotation) {
            for (int iRow = 0; iRow < this.m_iSize; ++iRow) {
                this.m_kMat.Set(iRow, 0, -this.m_kMat.Get(iRow, 0));
            }
        }
    }

    private void IncreasingSort() {
        for (int i0 = 0; i0 <= this.m_iSize - 2; ++i0) {
            int i2;
            int i1 = i0;
            float fMin = this.m_afDiag[i1];
            for (i2 = i0 + 1; i2 < this.m_iSize; ++i2) {
                if (!(this.m_afDiag[i2] < fMin)) continue;
                i1 = i2;
                fMin = this.m_afDiag[i1];
            }
            if (i1 == i0) continue;
            this.m_afDiag[i1] = this.m_afDiag[i0];
            this.m_afDiag[i0] = fMin;
            for (i2 = 0; i2 < this.m_iSize; ++i2) {
                float fTmp = this.m_kMat.Get(i2, i0);
                this.m_kMat.Set(i2, i0, this.m_kMat.Get(i2, i1));
                this.m_kMat.Set(i2, i1, fTmp);
                this.m_bIsRotation = !this.m_bIsRotation;
            }
        }
    }

    private void DecreasingSort() {
        for (int i0 = 0; i0 <= this.m_iSize - 2; ++i0) {
            int i2;
            int i1 = i0;
            float fMax = this.m_afDiag[i1];
            for (i2 = i0 + 1; i2 < this.m_iSize; ++i2) {
                if (!(this.m_afDiag[i2] > fMax)) continue;
                i1 = i2;
                fMax = this.m_afDiag[i1];
            }
            if (i1 == i0) continue;
            this.m_afDiag[i1] = this.m_afDiag[i0];
            this.m_afDiag[i0] = fMax;
            for (i2 = 0; i2 < this.m_iSize; ++i2) {
                float fTmp = this.m_kMat.Get(i2, i0);
                this.m_kMat.Set(i2, i0, this.m_kMat.Get(i2, i1));
                this.m_kMat.Set(i2, i1, fTmp);
                this.m_bIsRotation = !this.m_bIsRotation;
            }
        }
    }

    private boolean QLAlgorithm() {
        int iMaxIter = 32;
        for (int i0 = 0; i0 < this.m_iSize; ++i0) {
            int i1;
            for (i1 = 0; i1 < iMaxIter; ++i1) {
                int i2;
                for (i2 = i0; i2 <= this.m_iSize - 2; ++i2) {
                    float fTmp = Math.abs(this.m_afDiag[i2]) + Math.abs(this.m_afDiag[i2 + 1]);
                    if (Math.abs(this.m_afSubd[i2]) + fTmp == fTmp) break;
                }
                if (i2 == i0) break;
                float fG = (this.m_afDiag[i0 + 1] - this.m_afDiag[i0]) / (2.0f * this.m_afSubd[i0]);
                float fR = (float)Math.sqrt((double)(fG * fG) + 1.0);
                fG = fG < 0.0f ? this.m_afDiag[i2] - this.m_afDiag[i0] + this.m_afSubd[i0] / (fG - fR) : this.m_afDiag[i2] - this.m_afDiag[i0] + this.m_afSubd[i0] / (fG + fR);
                float fSin = 1.0f;
                float fCos = 1.0f;
                float fP = 0.0f;
                for (int i3 = i2 - 1; i3 >= i0; --i3) {
                    float fF = fSin * this.m_afSubd[i3];
                    float fB = fCos * this.m_afSubd[i3];
                    if (Math.abs(fF) >= Math.abs(fG)) {
                        fCos = fG / fF;
                        fR = (float)Math.sqrt((double)(fCos * fCos) + 1.0);
                        this.m_afSubd[i3 + 1] = fF * fR;
                        fSin = 1.0f / fR;
                        fCos *= fSin;
                    } else {
                        fSin = fF / fG;
                        fR = (float)Math.sqrt((double)(fSin * fSin) + 1.0);
                        this.m_afSubd[i3 + 1] = fG * fR;
                        fCos = 1.0f / fR;
                        fSin *= fCos;
                    }
                    fG = this.m_afDiag[i3 + 1] - fP;
                    fR = (float)((double)((this.m_afDiag[i3] - fG) * fSin) + 2.0 * (double)fB * (double)fCos);
                    fP = fSin * fR;
                    this.m_afDiag[i3 + 1] = fG + fP;
                    fG = fCos * fR - fB;
                    for (int i4 = 0; i4 < this.m_iSize; ++i4) {
                        fF = this.m_kMat.Get(i4, i3 + 1);
                        this.m_kMat.Set(i4, i3 + 1, fSin * this.m_kMat.Get(i4, i3) + fCos * fF);
                        this.m_kMat.Set(i4, i3, fCos * this.m_kMat.Get(i4, i3) - fSin * fF);
                    }
                }
                int n = i0;
                this.m_afDiag[n] = this.m_afDiag[n] - fP;
                this.m_afSubd[i0] = fG;
                this.m_afSubd[i2] = 0.0f;
            }
            if (i1 != iMaxIter) continue;
            return false;
        }
        return true;
    }

    private void Tridiagonal2() {
        this.m_afDiag[0] = this.m_kMat.Get(0, 0);
        this.m_afDiag[1] = this.m_kMat.Get(1, 1);
        this.m_afSubd[0] = this.m_kMat.Get(0, 1);
        this.m_afSubd[1] = 0.0f;
        this.m_kMat.Set(0, 0, 1.0f);
        this.m_kMat.Set(0, 1, 0.0f);
        this.m_kMat.Set(1, 0, 0.0f);
        this.m_kMat.Set(1, 1, 1.0f);
        this.m_bIsRotation = true;
    }

    private void Tridiagonal3() {
        float fM00 = this.m_kMat.Get(0, 0);
        float fM01 = this.m_kMat.Get(0, 1);
        float fM02 = this.m_kMat.Get(0, 2);
        float fM11 = this.m_kMat.Get(1, 1);
        float fM12 = this.m_kMat.Get(1, 2);
        float fM22 = this.m_kMat.Get(2, 2);
        this.m_afDiag[0] = fM00;
        this.m_afSubd[2] = 0.0f;
        if (Math.abs(fM02) > 1.0E-6f) {
            float fLength = (float)Math.sqrt(fM01 * fM01 + fM02 * fM02);
            float fInvLength = 1.0f / fLength;
            float fQ = 2.0f * (fM01 *= fInvLength) * fM12 + (fM02 *= fInvLength) * (fM22 - fM11);
            this.m_afDiag[1] = fM11 + fM02 * fQ;
            this.m_afDiag[2] = fM22 - fM02 * fQ;
            this.m_afSubd[0] = fLength;
            this.m_afSubd[1] = fM12 - fM01 * fQ;
            this.m_kMat.Set(0, 0, 1.0f);
            this.m_kMat.Set(0, 1, 0.0f);
            this.m_kMat.Set(0, 2, 0.0f);
            this.m_kMat.Set(1, 0, 0.0f);
            this.m_kMat.Set(1, 1, fM01);
            this.m_kMat.Set(1, 2, fM02);
            this.m_kMat.Set(2, 0, 0.0f);
            this.m_kMat.Set(2, 1, fM02);
            this.m_kMat.Set(2, 2, -fM01);
            this.m_bIsRotation = false;
        } else {
            this.m_afDiag[1] = fM11;
            this.m_afDiag[2] = fM22;
            this.m_afSubd[0] = fM01;
            this.m_afSubd[1] = fM12;
            this.m_kMat.Set(0, 0, 1.0f);
            this.m_kMat.Set(0, 1, 0.0f);
            this.m_kMat.Set(0, 2, 0.0f);
            this.m_kMat.Set(1, 0, 0.0f);
            this.m_kMat.Set(1, 1, 1.0f);
            this.m_kMat.Set(1, 2, 0.0f);
            this.m_kMat.Set(2, 0, 0.0f);
            this.m_kMat.Set(2, 1, 0.0f);
            this.m_kMat.Set(2, 2, 1.0f);
            this.m_bIsRotation = true;
        }
    }

    private void TridiagonalN() {
        int i1;
        int i2;
        int i0 = this.m_iSize - 1;
        int i3 = this.m_iSize - 2;
        while (i0 >= 1) {
            float fH = 0.0f;
            float fScale = 0.0f;
            if (i3 > 0) {
                for (i2 = 0; i2 <= i3; ++i2) {
                    fScale += Math.abs(this.m_kMat.Get(i0, i2));
                }
                if ((double)fScale == 0.0) {
                    this.m_afSubd[i0] = this.m_kMat.Get(i0, i3);
                } else {
                    float fInvScale = 1.0f / fScale;
                    for (i2 = 0; i2 <= i3; ++i2) {
                        this.m_kMat.Set(i0, i2, this.m_kMat.Get(i0, i2) * fInvScale);
                        fH += this.m_kMat.Get(i0, i2) * this.m_kMat.Get(i0, i2);
                    }
                    float fF = this.m_kMat.Get(i0, i3);
                    float fG = (float)Math.sqrt(fH);
                    if ((double)fF > 0.0) {
                        fG = -fG;
                    }
                    this.m_afSubd[i0] = fScale * fG;
                    fH -= fF * fG;
                    this.m_kMat.Set(i0, i3, fF - fG);
                    fF = 0.0f;
                    float fInvH = 1.0f / fH;
                    for (i1 = 0; i1 <= i3; ++i1) {
                        this.m_kMat.Set(i1, i0, this.m_kMat.Get(i0, i1) * fInvH);
                        fG = 0.0f;
                        for (i2 = 0; i2 <= i1; ++i2) {
                            fG += this.m_kMat.Get(i1, i2) * this.m_kMat.Get(i0, i2);
                        }
                        for (i2 = i1 + 1; i2 <= i3; ++i2) {
                            fG += this.m_kMat.Get(i2, i1) * this.m_kMat.Get(i0, i2);
                        }
                        this.m_afSubd[i1] = fG * fInvH;
                        fF += this.m_afSubd[i1] * this.m_kMat.Get(i0, i1);
                    }
                    float fHalfFdivH = 0.5f * fF * fInvH;
                    for (i1 = 0; i1 <= i3; ++i1) {
                        fF = this.m_kMat.Get(i0, i1);
                        this.m_afSubd[i1] = fG = this.m_afSubd[i1] - fHalfFdivH * fF;
                        for (i2 = 0; i2 <= i1; ++i2) {
                            this.m_kMat.Set(i1, i2, this.m_kMat.Get(i1, i2) - (fF * this.m_afSubd[i2] + fG * this.m_kMat.Get(i0, i2)));
                        }
                    }
                }
            } else {
                this.m_afSubd[i0] = this.m_kMat.Get(i0, i3);
            }
            this.m_afDiag[i0] = fH;
            --i0;
            --i3;
        }
        this.m_afDiag[0] = 0.0f;
        this.m_afSubd[0] = 0.0f;
        i0 = 0;
        i3 = -1;
        while (i0 <= this.m_iSize - 1) {
            if ((double)this.m_afDiag[i0] != 0.0) {
                for (i1 = 0; i1 <= i3; ++i1) {
                    float fSum = 0.0f;
                    for (i2 = 0; i2 <= i3; ++i2) {
                        fSum += this.m_kMat.Get(i0, i2) * this.m_kMat.Get(i2, i1);
                    }
                    for (i2 = 0; i2 <= i3; ++i2) {
                        this.m_kMat.Set(i2, i1, this.m_kMat.Get(i2, i1) - fSum * this.m_kMat.Get(i2, i0));
                    }
                }
            }
            this.m_afDiag[i0] = this.m_kMat.Get(i0, i0);
            this.m_kMat.Set(i0, i0, 1.0f);
            for (i1 = 0; i1 <= i3; ++i1) {
                this.m_kMat.Set(i1, i0, 0.0f);
                this.m_kMat.Set(i0, i1, 0.0f);
            }
            ++i0;
            ++i3;
        }
        i0 = 1;
        i3 = 0;
        while (i0 < this.m_iSize) {
            this.m_afSubd[i3] = this.m_afSubd[i0];
            ++i0;
            ++i3;
        }
        this.m_afSubd[this.m_iSize - 1] = 0.0f;
        this.m_bIsRotation = this.m_iSize % 2 == 0;
    }
}

