/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.NumericalAnalysis;

import WildMagic.LibFoundation.NumericalAnalysis.IntegrateInterface;
import java.io.Serializable;

public class Integrate1
implements Serializable {
    private static final long serialVersionUID = -3927811828981066195L;

    static float GaussianQuadrature(float fA, float fB, IntegrateInterface pvUserData) {
        int iDegree = 5;
        float[] afRoot = new float[]{-0.90617985f, -0.5384693f, 0.0f, 0.5384693f, 0.90617985f};
        float[] afCoeff = new float[]{0.23692688f, 0.47862867f, 0.5688889f, 0.47862867f, 0.23692688f};
        float fRadius = 0.5f * (fB - fA);
        float fCenter = 0.5f * (fB + fA);
        float fResult = 0.0f;
        for (int i = 0; i < 5; ++i) {
            fResult += afCoeff[i] * pvUserData.Integrate(fRadius * afRoot[i] + fCenter);
        }
        return fResult *= fRadius;
    }

    static float TrapezoidRule(int iNumSamples, float fA, float fB, IntegrateInterface pvUserData) {
        assert (iNumSamples >= 2);
        float fH = (fB - fA) / (float)(iNumSamples - 1);
        float fResult = 0.5f * (pvUserData.Integrate(fA) + pvUserData.Integrate(fB));
        for (int i = 1; i <= iNumSamples - 2; ++i) {
            fResult += pvUserData.Integrate(fA + (float)i * fH);
        }
        return fResult *= fH;
    }

    public static float RombergIntegral(int iOrder, float fA, float fB, IntegrateInterface pvUserData) {
        assert (iOrder > 0);
        float[][] aafRom = new float[2][iOrder];
        float fH = fB - fA;
        aafRom[0][0] = 0.5f * fH * (pvUserData.Integrate(fA) + pvUserData.Integrate(fB));
        int i0 = 2;
        int iP0 = 1;
        while (i0 <= iOrder) {
            int i1;
            float fSum = 0.0f;
            for (i1 = 1; i1 <= iP0; ++i1) {
                fSum += pvUserData.Integrate((float)((double)fA + (double)fH * ((double)i1 - 0.5)));
            }
            aafRom[1][0] = (float)(0.5 * (double)(aafRom[0][0] + fH * fSum));
            int i2 = 1;
            int iP2 = 4;
            while (i2 < i0) {
                aafRom[1][i2] = ((float)iP2 * aafRom[1][i2 - 1] - aafRom[0][i2 - 1]) / (float)(iP2 - 1);
                ++i2;
                iP2 *= 4;
            }
            for (i1 = 0; i1 < i0; ++i1) {
                aafRom[0][i1] = aafRom[1][i1];
            }
            ++i0;
            iP0 *= 2;
            fH = (float)((double)fH * 0.5);
        }
        float fResult = aafRom[0][iOrder - 1];
        aafRom = null;
        return fResult;
    }
}

