/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.NumericalAnalysis;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SparseMatrix
implements Serializable {
    private static final long serialVersionUID = -6532505708244366126L;
    private static final float ms_fTolerance = 1.0E-6f;
    private Index m_kIndexKeyTmp = new Index(-1, -1);
    private HashMap<Index, Float> m_kMap = new HashMap();

    private static float dot(int iSize, float[] afU, float[] afV) {
        float fDot = 0.0f;
        for (int i = 0; i < iSize; ++i) {
            fDot += afU[i] * afV[i];
        }
        return fDot;
    }

    private static void updateP(int iSize, float[] afP, float fBeta, float[] afR) {
        for (int i = 0; i < iSize; ++i) {
            afP[i] = afR[i] + fBeta * afP[i];
        }
    }

    private static void updateR(int iSize, float[] afR, float fAlpha, float[] afW) {
        for (int i = 0; i < iSize; ++i) {
            int n = i;
            afR[n] = afR[n] - fAlpha * afW[i];
        }
    }

    private static void updateX(int iSize, float[] afX, float fAlpha, float[] afP) {
        for (int i = 0; i < iSize; ++i) {
            int n = i;
            afX[n] = afX[n] + fAlpha * afP[i];
        }
    }

    public float getElement(int iRow, int iCol) {
        this.m_kIndexKeyTmp.m_iRow = iRow;
        this.m_kIndexKeyTmp.m_iCol = iCol;
        Float kValue = this.m_kMap.get(this.m_kIndexKeyTmp);
        return null == kValue ? 0.0f : kValue.floatValue();
    }

    public Iterator<Map.Entry<Index, Float>> iterator() {
        return this.m_kMap.entrySet().iterator();
    }

    public void setElement(int iRow, int iCol, float fValue) {
        this.m_kMap.put(new Index(iRow, iCol), new Float(fValue));
    }

    public int size() {
        return this.m_kMap.size();
    }

    public boolean solveSymmetricCG(int iSize, float[] afB, float[] afX) {
        float fNorm;
        float fRoot1;
        float fRoot0;
        int i;
        float[] afR = new float[iSize];
        float[] afP = new float[iSize];
        float[] afW = new float[iSize];
        for (int i2 = 0; i2 < iSize; ++i2) {
            afX[i2] = 0.0f;
            afR[i2] = afB[i2];
            afP[i2] = afR[i2];
        }
        float fRho0 = SparseMatrix.dot(iSize, afR, afR);
        this.multiply(iSize, afP, afW);
        float fAlpha = fRho0 / SparseMatrix.dot(iSize, afP, afW);
        SparseMatrix.updateX(iSize, afX, fAlpha, afP);
        SparseMatrix.updateR(iSize, afR, fAlpha, afW);
        float fRho1 = SparseMatrix.dot(iSize, afR, afR);
        int iMax = 1024;
        for (i = 1; i < 1024 && !((fRoot0 = (float)Math.sqrt(fRho1)) <= 1.0E-6f * (fRoot1 = (float)Math.sqrt(fNorm = SparseMatrix.dot(iSize, afB, afB)))); ++i) {
            float fBeta = fRho1 / fRho0;
            SparseMatrix.updateP(iSize, afP, fBeta, afR);
            this.multiply(iSize, afP, afW);
            fAlpha = fRho1 / SparseMatrix.dot(iSize, afP, afW);
            SparseMatrix.updateX(iSize, afX, fAlpha, afP);
            SparseMatrix.updateR(iSize, afR, fAlpha, afW);
            fRho0 = fRho1;
            fRho1 = SparseMatrix.dot(iSize, afR, afR);
        }
        return i < 1024;
    }

    private void multiply(int iSize, float[] afX, float[] afProd) {
        for (int i = 0; i < iSize; ++i) {
            afProd[i] = 0.0f;
        }
        Iterator<Map.Entry<Index, Float>> kIter = this.iterator();
        while (kIter.hasNext()) {
            Map.Entry<Index, Float> kEntry = kIter.next();
            Index kIndex = kEntry.getKey();
            Float kValue = kEntry.getValue();
            int i = kIndex.m_iRow;
            int j = kIndex.m_iCol;
            float fValue = kValue.floatValue();
            int n = i;
            afProd[n] = afProd[n] + fValue * afX[j];
            if (i == j) continue;
            int n2 = j;
            afProd[n2] = afProd[n2] + fValue * afX[i];
        }
    }

    public static class Index {
        public int m_iCol;
        public int m_iRow;

        public Index(int iRow, int iCol) {
            this.m_iRow = iRow;
            this.m_iCol = iCol;
        }

        public boolean equals(Object kObject) {
            Index kIndex = (Index)kObject;
            return this.m_iRow == kIndex.m_iRow && this.m_iCol == kIndex.m_iCol;
        }

        public int hashCode() {
            return this.m_iRow << 16 | this.m_iCol;
        }
    }
}

