/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.System;

import java.io.Serializable;

public class TSmallUnorderedSet
implements Serializable {
    private static final long serialVersionUID = 6636275216032389929L;
    private Object[] m_atElement;
    private int m_iMaxQuantity;
    private int m_iGrowBy;
    private int m_iQuantity;

    public TSmallUnorderedSet() {
        this.m_iMaxQuantity = 1;
        this.m_iGrowBy = 1;
        this.m_iQuantity = 0;
        this.m_atElement = new Object[1];
    }

    public TSmallUnorderedSet(int iCapacity, int iGrowBy) {
        this.m_iMaxQuantity = iCapacity;
        this.m_iGrowBy = iGrowBy;
        this.m_iQuantity = 0;
        this.m_atElement = new Object[iCapacity];
    }

    public TSmallUnorderedSet(TSmallUnorderedSet kSet) {
        this.m_iMaxQuantity = kSet.m_iMaxQuantity;
        this.m_iGrowBy = kSet.m_iGrowBy;
        this.m_iQuantity = kSet.m_iQuantity;
        this.m_atElement = new Object[this.m_iMaxQuantity];
        System.arraycopy(kSet.m_atElement, 0, this.m_atElement, 0, this.m_iMaxQuantity);
    }

    public void Clear(int iMaxQuantity, int iGrowBy) {
        assert (iMaxQuantity > 0 && iGrowBy > 0);
        this.m_iMaxQuantity = iMaxQuantity;
        this.m_iGrowBy = iGrowBy;
        this.m_iQuantity = 0;
        this.m_atElement = new Object[iMaxQuantity];
    }

    public boolean Exists(Object kElement) {
        for (int i = 0; i < this.m_iQuantity; ++i) {
            if (!kElement.equals(this.m_atElement[i])) continue;
            return true;
        }
        return false;
    }

    public Object GetElement(int i) {
        if (0 <= i && i < this.m_iQuantity) {
            return this.m_atElement[i];
        }
        return null;
    }

    public int GetQuantity() {
        return this.m_iQuantity;
    }

    public boolean Insert(Object kElement) {
        for (int i = 0; i < this.m_iQuantity; ++i) {
            if (!kElement.equals(this.m_atElement[i])) continue;
            return false;
        }
        if (this.m_iQuantity == this.m_iMaxQuantity) {
            int iNewCapacity = this.m_iMaxQuantity + this.m_iGrowBy;
            Object[] atNewElement = new Object[iNewCapacity];
            System.arraycopy(this.m_atElement, 0, atNewElement, 0, this.m_iMaxQuantity);
            this.m_atElement = atNewElement;
            this.m_iMaxQuantity = iNewCapacity;
        }
        this.m_atElement[this.m_iQuantity++] = kElement;
        return true;
    }

    public void InsertNoCheck(Object kElement) {
        if (this.m_iQuantity == this.m_iMaxQuantity) {
            int iNewCapacity = this.m_iMaxQuantity + this.m_iGrowBy;
            Object[] atNewElement = new Object[iNewCapacity];
            System.arraycopy(this.m_atElement, 0, atNewElement, 0, this.m_iMaxQuantity);
            this.m_atElement = atNewElement;
            this.m_iMaxQuantity = iNewCapacity;
        }
        this.m_atElement[this.m_iQuantity++] = kElement;
    }

    public boolean IsEmpty() {
        return this.m_iQuantity == 0;
    }

    public boolean Remove(Object kElement) {
        for (int i = 0; i < this.m_iQuantity; ++i) {
            if (!kElement.equals(this.m_atElement[i])) continue;
            int j = i + 1;
            while (j < this.m_iQuantity) {
                this.m_atElement[i] = this.m_atElement[j];
                ++j;
                ++i;
            }
            --this.m_iQuantity;
            return true;
        }
        return false;
    }
}

