/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibFoundation.System;

import java.io.Serializable;

public class UnorderedSetInt
implements Serializable {
    private static final long serialVersionUID = 2081210684464108814L;
    protected int[] m_aiElement;
    protected int m_iGrow;
    protected int m_iMaxQuantity;
    protected int m_iOldIndex;
    protected int m_iNewIndex;
    protected int m_iQuantity;
    private int DEFAULT_GROW = 8;

    public UnorderedSetInt() {
        this.reset();
    }

    public UnorderedSetInt(int iMaxQuantity, int iGrow) {
        this.reset(iMaxQuantity, iGrow);
    }

    public UnorderedSetInt(UnorderedSetInt kSet) {
        this.copy(kSet);
    }

    public int append(int iElement) {
        if (this.m_iQuantity == this.m_iMaxQuantity) {
            int iNewMaxQuantity = this.m_iMaxQuantity + this.m_iGrow;
            int[] aiNewElement = new int[iNewMaxQuantity];
            System.arraycopy(this.m_aiElement, 0, aiNewElement, 0, this.m_iMaxQuantity);
            this.m_iMaxQuantity = iNewMaxQuantity;
            this.m_aiElement = aiNewElement;
        }
        int iLocation = this.m_iQuantity++;
        this.m_aiElement[iLocation] = iElement;
        return iLocation;
    }

    public void compactify() {
        if (this.m_iQuantity > 0) {
            int[] aiNewElement = new int[this.m_iQuantity];
            System.arraycopy(this.m_aiElement, 0, aiNewElement, 0, this.m_iQuantity);
            this.m_iMaxQuantity = this.m_iQuantity;
            this.m_aiElement = aiNewElement;
        } else {
            this.reset();
        }
    }

    public void copy(UnorderedSetInt kSet) {
        this.m_iQuantity = kSet.m_iQuantity;
        this.m_iMaxQuantity = kSet.m_iMaxQuantity;
        this.m_iGrow = kSet.m_iGrow;
        this.m_aiElement = new int[this.m_iMaxQuantity];
        System.arraycopy(kSet.m_aiElement, 0, this.m_aiElement, 0, this.m_iMaxQuantity);
    }

    public boolean exists(int iElement) {
        for (int i = 0; i < this.m_iQuantity; ++i) {
            if (iElement != this.m_aiElement[i]) continue;
            return true;
        }
        return false;
    }

    public final int get(int i) {
        return this.m_aiElement[i];
    }

    public final int getGrow() {
        return this.m_iGrow;
    }

    public final int getMaxQuantity() {
        return this.m_iMaxQuantity;
    }

    public final int getNewIndex() {
        return this.m_iNewIndex;
    }

    public final int getOldIndex() {
        return this.m_iOldIndex;
    }

    public final int getQuantity() {
        return this.m_iQuantity;
    }

    public boolean insert(int iElement) {
        for (int i = 0; i < this.m_iQuantity; ++i) {
            if (iElement != this.m_aiElement[i]) continue;
            return false;
        }
        if (this.m_iQuantity == this.m_iMaxQuantity) {
            int iNewMaxQuantity = this.m_iMaxQuantity + this.m_iGrow;
            int[] aiNewElement = new int[iNewMaxQuantity];
            System.arraycopy(this.m_aiElement, 0, aiNewElement, 0, this.m_iMaxQuantity);
            this.m_iMaxQuantity = iNewMaxQuantity;
            this.m_aiElement = aiNewElement;
        }
        this.m_aiElement[this.m_iQuantity++] = iElement;
        return true;
    }

    public boolean remove(int iElement) {
        for (int i = 0; i < this.m_iQuantity; ++i) {
            if (iElement != this.m_aiElement[i]) continue;
            --this.m_iQuantity;
            this.m_iOldIndex = this.m_iQuantity;
            if (i != this.m_iQuantity) {
                this.m_aiElement[i] = this.m_aiElement[this.m_iQuantity];
                this.m_iNewIndex = i;
            } else {
                this.m_iNewIndex = -1;
            }
            return true;
        }
        return false;
    }

    public boolean removeAt(int i) {
        if (0 <= i && i < this.m_iQuantity) {
            --this.m_iQuantity;
            this.m_iOldIndex = this.m_iQuantity;
            if (i != this.m_iQuantity) {
                this.m_aiElement[i] = this.m_aiElement[this.m_iQuantity];
                this.m_iNewIndex = i;
            } else {
                this.m_iNewIndex = -1;
            }
            return true;
        }
        return false;
    }

    public void reset() {
        this.reset(0, 0);
    }

    public void reset(int iMaxQuantity, int iGrow) {
        if (iMaxQuantity <= 0) {
            iMaxQuantity = this.DEFAULT_GROW;
        }
        if (iGrow <= 0) {
            iGrow = this.DEFAULT_GROW;
        }
        this.m_iQuantity = 0;
        this.m_iMaxQuantity = iMaxQuantity;
        this.m_iGrow = iGrow;
        this.m_aiElement = new int[this.m_iMaxQuantity];
    }

    public final void set(int i, int iElement) {
        this.m_aiElement[i] = iElement;
    }
}

