/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Collision;

import WildMagic.LibFoundation.Mathematics.Line3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.Collision.BoxBVTree;
import WildMagic.LibGraphics.SceneGraph.BoundingVolume;
import WildMagic.LibGraphics.SceneGraph.BoxBV;
import WildMagic.LibGraphics.SceneGraph.TriMesh;
import WildMagic.LibGraphics.SceneGraph.VertexBuffer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public abstract class BoundingVolumeTree
implements Comparator<ProjectionInfo>,
Serializable {
    private static final long serialVersionUID = -1824797718180128125L;
    protected TriMesh m_pkMesh;
    protected BoundingVolume m_spkModelBound;
    protected BoundingVolume m_spkWorldBound;
    protected BoundingVolumeTree m_pkLChild = null;
    protected BoundingVolumeTree m_pkRChild = null;
    protected int m_iTriangleQuantity;
    protected Vector<Integer> m_kTriangles;

    protected BoundingVolumeTree() {
        this.m_pkMesh = null;
        this.m_pkLChild = null;
        this.m_pkRChild = null;
        this.m_iTriangleQuantity = 0;
        this.m_kTriangles = null;
    }

    protected BoundingVolumeTree(BoundingVolume.BVType eBVType, TriMesh pkMesh) {
        this(eBVType, pkMesh, 1, false);
    }

    protected BoundingVolumeTree(BoundingVolume.BVType eBVType, TriMesh pkMesh, int iMaxTrisPerLeaf, boolean bStoreInteriorTris) {
        int iT;
        this.m_pkMesh = pkMesh;
        int iTQuantity = this.m_pkMesh.IBuffer.GetIndexQuantity() / 3;
        int[] aiIndex = this.m_pkMesh.IBuffer.GetData();
        Vector3f[] akCentroid = new Vector3f[iTQuantity];
        float fOneThird = 0.33333334f;
        int i = 0;
        for (iT = 0; iT < iTQuantity; ++iT) {
            int i0 = aiIndex[i++];
            int i1 = aiIndex[i++];
            int i2 = aiIndex[i++];
            akCentroid[iT] = pkMesh.VBuffer.GetPosition3(i0);
            akCentroid[iT].Add(pkMesh.VBuffer.GetPosition3(i1));
            akCentroid[iT].Add(pkMesh.VBuffer.GetPosition3(i2));
            akCentroid[iT].Scale(fOneThird);
        }
        int[] aiISplit = new int[iTQuantity];
        int[] aiOSplit = new int[iTQuantity];
        for (iT = 0; iT < iTQuantity; ++iT) {
            aiISplit[iT] = iT;
        }
        this.BuildTree(eBVType, iMaxTrisPerLeaf, bStoreInteriorTris, akCentroid, 0, iTQuantity - 1, aiISplit, aiOSplit);
        akCentroid = null;
        aiISplit = null;
        aiOSplit = null;
    }

    protected BoundingVolumeTree(TriMesh pkMesh) {
        this.m_pkMesh = pkMesh;
        this.m_pkLChild = null;
        this.m_pkRChild = null;
        this.m_iTriangleQuantity = 0;
        this.m_kTriangles = null;
    }

    protected static void SplitTriangles(Vector3f[] akCentroid, int i0, int i1, int[] aiISplit, int[] rj01, int[] aiOSplit, Line3f rkLine) {
        BoxBVTree kTree = new BoxBVTree();
        int iQuantity = i1 - i0 + 1;
        ProjectionInfo[] akInfo = new ProjectionInfo[iQuantity];
        int i = i0;
        int j = 0;
        while (i <= i1) {
            int iTriangle = aiISplit[i];
            Vector3f kDiff = new Vector3f();
            kDiff.Sub(akCentroid[iTriangle], rkLine.Origin);
            akInfo[j] = kTree.new ProjectionInfo();
            akInfo[j].m_iTriangle = iTriangle;
            akInfo[j].m_fProjection = rkLine.Direction.Dot(kDiff);
            ++i;
            ++j;
        }
        try {
            Arrays.sort(akInfo, kTree);
        }
        catch (OutOfMemoryError x) {
            System.err.println("out of memory sort");
        }
        int iMedian = (iQuantity - 1) / 2;
        rj01[0] = i0 - 1;
        for (j = 0; j <= iMedian; ++j) {
            rj01[0] = rj01[0] + 1;
            aiOSplit[rj01[0]] = akInfo[j].m_iTriangle;
        }
        rj01[1] = i1 + 1;
        while (j < iQuantity) {
            rj01[1] = rj01[1] - 1;
            aiOSplit[rj01[1]] = akInfo[j].m_iTriangle;
            ++j;
        }
        akInfo = null;
    }

    @Override
    public int compare(ProjectionInfo pInfo0, ProjectionInfo pInfo1) {
        if (pInfo0.m_fProjection < pInfo1.m_fProjection) {
            return -1;
        }
        if (pInfo0.m_fProjection > pInfo1.m_fProjection) {
            return 1;
        }
        return 0;
    }

    public void disposeLocal() {
        this.m_kTriangles = null;
        this.m_pkLChild = null;
        this.m_pkRChild = null;
    }

    public BoundingVolumeTree GetLChild() {
        return this.m_pkLChild;
    }

    public final TriMesh GetMesh() {
        return this.m_pkMesh;
    }

    public final BoundingVolume GetModelBound() {
        return this.m_spkModelBound;
    }

    public BoundingVolumeTree GetRChild() {
        return this.m_pkRChild;
    }

    public int GetTriangle(int i) {
        return this.m_kTriangles.get(i);
    }

    public int GetTriangleQuantity() {
        return this.m_iTriangleQuantity;
    }

    public final Vector<Integer> GetTriangles() {
        return this.m_kTriangles;
    }

    public final BoundingVolume GetWorldBound() {
        return this.m_spkWorldBound;
    }

    public boolean IsInteriorNode() {
        return this.m_pkLChild != null || this.m_pkRChild != null;
    }

    public boolean IsLeafNode() {
        return this.m_pkLChild == null && this.m_pkRChild == null;
    }

    public void UpdateWorldBound() {
        this.m_spkModelBound.TransformBy(this.m_pkMesh.World, this.m_spkWorldBound);
    }

    protected void BuildTree(BoundingVolume.BVType eBVType, int iMaxTrisPerLeaf, boolean bStoreInteriorTris, Vector3f[] akCentroid, int i0, int i1, int[] aiISplit, int[] aiOSplit) {
        assert (i0 <= i1);
        Line3f kLine = new Line3f();
        try {
            if (eBVType == BoundingVolume.BVType.BV_SPHERE) {
                return;
            }
            if (eBVType == BoundingVolume.BVType.BV_BOX) {
                this.m_spkModelBound = BoxBVTree.CreateModelBound(this.m_pkMesh, i0, i1, aiISplit, kLine);
                this.m_spkWorldBound = new BoxBV();
            }
        }
        catch (OutOfMemoryError x) {
            System.err.println("out of memory CreateModelBound");
        }
        if (i1 - i0 < iMaxTrisPerLeaf) {
            try {
                this.m_iTriangleQuantity = i1 - i0 + 1;
                this.m_kTriangles = new Vector();
                for (int i = 0; i < this.m_iTriangleQuantity; ++i) {
                    this.m_kTriangles.add(i, aiISplit[i0 + i]);
                }
                this.m_pkLChild = null;
                this.m_pkRChild = null;
            }
            catch (OutOfMemoryError x) {
                System.err.println("out of memory iMaxTrisPerLeaf");
            }
        } else {
            int[] j01 = new int[2];
            try {
                if (bStoreInteriorTris) {
                    this.m_iTriangleQuantity = i1 - i0 + 1;
                    this.m_kTriangles = new Vector();
                    for (int i = 0; i < this.m_iTriangleQuantity; ++i) {
                        this.m_kTriangles.add(i, aiISplit[i0 + i]);
                    }
                } else {
                    this.m_iTriangleQuantity = 0;
                    this.m_kTriangles = null;
                }
                BoundingVolumeTree.SplitTriangles(akCentroid, i0, i1, aiISplit, j01, aiOSplit, kLine);
                if (eBVType == BoundingVolume.BVType.BV_BOX) {
                    this.m_pkLChild = new BoxBVTree(this.m_pkMesh);
                    this.m_pkLChild.BuildTree(eBVType, iMaxTrisPerLeaf, bStoreInteriorTris, akCentroid, i0, j01[0], aiOSplit, aiISplit);
                    this.m_pkRChild = new BoxBVTree(this.m_pkMesh);
                    this.m_pkRChild.BuildTree(eBVType, iMaxTrisPerLeaf, bStoreInteriorTris, akCentroid, j01[1], i1, aiOSplit, aiISplit);
                }
            }
            catch (OutOfMemoryError x) {
                System.err.println("out of memory else " + i0 + " " + j01[0] + " " + j01[1] + " " + i1);
            }
        }
    }

    protected boolean ContainsLeafData(VertexBuffer pkVBuffer, int[] aiIndex, float fEpsilon) {
        if (this.m_pkLChild != null && !this.m_pkLChild.ContainsLeafData(pkVBuffer, aiIndex, fEpsilon)) {
            return false;
        }
        if (this.m_pkRChild != null && !this.m_pkRChild.ContainsLeafData(pkVBuffer, aiIndex, fEpsilon)) {
            return false;
        }
        for (int iT = 0; iT < this.m_iTriangleQuantity; ++iT) {
            int j = 3 * this.m_kTriangles.get(iT);
            for (int i = 0; i < 3; ++i) {
                Vector3f kPoint;
                if (this.m_spkModelBound.Contains(kPoint = pkVBuffer.GetPosition3(aiIndex[j++]))) continue;
                return false;
            }
        }
        return true;
    }

    public class ProjectionInfo {
        public int m_iTriangle;
        public float m_fProjection;
    }
}

