/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Detail;

import WildMagic.LibGraphics.Detail.CollapseRecord;
import WildMagic.LibGraphics.Detail.CollapseRecordArray;
import WildMagic.LibGraphics.SceneGraph.Culler;
import WildMagic.LibGraphics.SceneGraph.IndexBuffer;
import WildMagic.LibGraphics.SceneGraph.TriMesh;
import WildMagic.LibGraphics.SceneGraph.VertexBuffer;
import java.io.Serializable;

public class ClodMesh
extends TriMesh
implements Serializable {
    private static final long serialVersionUID = 3197693404031346814L;
    protected int m_iCurrentRecord;
    protected int m_iTargetRecord;
    protected CollapseRecordArray m_spkRecordArray;

    public ClodMesh(VertexBuffer pkVBuffer, IndexBuffer pkIBuffer, CollapseRecordArray pkRecordArray) {
        super(pkVBuffer, null);
        assert (pkRecordArray != null);
        this.m_iTargetRecord = 0;
        this.m_iCurrentRecord = 0;
        this.m_spkRecordArray = pkRecordArray;
        this.IBuffer = new IndexBuffer(pkIBuffer);
    }

    protected ClodMesh() {
        this.m_iTargetRecord = 0;
        this.m_iCurrentRecord = 0;
    }

    public int GetAutomatedTargetRecord() {
        return this.m_iTargetRecord;
    }

    public int GetMaximumLOD() {
        return this.m_spkRecordArray.GetQuantity() - 1;
    }

    public CollapseRecord GetRecord(int i) {
        return this.m_spkRecordArray.GetData()[i];
    }

    public int GetRecordQuantity() {
        return this.m_spkRecordArray.GetQuantity();
    }

    public void SelectLevelOfDetail() {
        int iC;
        int i;
        CollapseRecord rkRecord;
        CollapseRecord[] akRecord = this.m_spkRecordArray.GetData();
        int iTargetRecord = this.GetAutomatedTargetRecord();
        int[] aiIndex = this.IBuffer.GetData();
        while (this.m_iCurrentRecord < iTargetRecord) {
            ++this.m_iCurrentRecord;
            rkRecord = akRecord[this.m_iCurrentRecord];
            for (i = 0; i < rkRecord.IQuantity; ++i) {
                iC = rkRecord.Index[i];
                assert (aiIndex[iC] == rkRecord.VThrow);
                aiIndex[iC] = rkRecord.VKeep;
            }
            this.VBuffer.SetVertexQuantity(rkRecord.VQuantity);
            this.IBuffer.SetIndexQuantity(3 * rkRecord.TQuantity);
            this.IBuffer.Release();
        }
        while (this.m_iCurrentRecord > iTargetRecord) {
            rkRecord = akRecord[this.m_iCurrentRecord];
            for (i = 0; i < rkRecord.IQuantity; ++i) {
                iC = rkRecord.Index[i];
                assert (aiIndex[iC] == rkRecord.VKeep);
                aiIndex[iC] = rkRecord.VThrow;
            }
            --this.m_iCurrentRecord;
            CollapseRecord rkPrevRecord = akRecord[this.m_iCurrentRecord];
            this.VBuffer.SetVertexQuantity(rkPrevRecord.VQuantity);
            this.IBuffer.SetIndexQuantity(3 * rkPrevRecord.TQuantity);
            this.IBuffer.Release();
        }
    }

    public int TargetRecord() {
        return this.m_iTargetRecord;
    }

    public void TargetRecord(int iTarget) {
        this.m_iTargetRecord = iTarget;
    }

    @Override
    protected void GetVisibleSet(Culler rkCuller, boolean bNoCull) {
        this.SelectLevelOfDetail();
        super.GetVisibleSet(rkCuller, bNoCull);
    }
}

