/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Effects;

import WildMagic.LibGraphics.Effects.ShaderEffect;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.Texture;
import WildMagic.LibGraphics.Shaders.PixelShader;
import WildMagic.LibGraphics.Shaders.Program;
import WildMagic.LibGraphics.Shaders.VertexShader;
import java.io.Serializable;

public class IridescenceEffect
extends ShaderEffect
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = -2458255546164018939L;
    protected float[] m_afInterpolate = new float[4];

    public IridescenceEffect() {
    }

    public IridescenceEffect(String acBaseName, String acGradName) {
        super(1);
        this.m_kVShader.set(0, new VertexShader("IridescenceV"));
        this.m_kPShader.set(0, new PixelShader("IridescenceP"));
        ((PixelShader)this.m_kPShader.get(0)).SetTextureQuantity(2);
        ((PixelShader)this.m_kPShader.get(0)).SetImageName(0, acBaseName);
        ((PixelShader)this.m_kPShader.get(0)).SetImageName(1, acGradName);
        Texture pkBase = ((PixelShader)this.m_kPShader.get(0)).GetTexture(0);
        pkBase.SetFilterType(Texture.FilterType.LINEAR);
        pkBase.SetWrapType(0, Texture.WrapType.REPEAT);
        pkBase.SetWrapType(1, Texture.WrapType.REPEAT);
        Texture pkGrad = ((PixelShader)this.m_kPShader.get(0)).GetTexture(1);
        pkGrad.SetFilterType(Texture.FilterType.LINEAR);
    }

    @Override
    public void dispose() {
        this.m_afInterpolate = null;
        super.dispose();
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_FLOAT;
    }

    public float GetInterpolateFactor() {
        return this.m_afInterpolate[0];
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        this.m_afInterpolate[0] = rkStream.ReadFloat();
    }

    @Override
    public void OnLoadPrograms(int iPass, Program pkVProgram, Program pkPProgram, Program pkCProgram) {
        pkVProgram.GetUC("InterpolateFactor").SetDataSource(this.m_afInterpolate);
        pkCProgram.GetUC("InterpolateFactor").SetDataSource(this.m_afInterpolate);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_afInterpolate[0]);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("IridescenceEffect", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("interpolation factor =", this.m_afInterpolate[0]));
        return pkTree;
    }

    public void SetInterpolateFactor(float fInterpolateFactor) {
        this.m_afInterpolate[0] = fInterpolateFactor;
    }
}

