/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Effects;

import WildMagic.LibFoundation.Mathematics.Vector2f;
import WildMagic.LibGraphics.Effects.ShaderEffect;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.Texture;
import WildMagic.LibGraphics.Shaders.PixelShader;
import WildMagic.LibGraphics.Shaders.Program;
import WildMagic.LibGraphics.Shaders.VertexShader;
import java.io.Serializable;

public class LatticeEffect
extends ShaderEffect
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 2773925129011817494L;
    protected float[] m_afScale = new float[4];
    protected float[] m_afThreshold = new float[4];

    public LatticeEffect() {
    }

    public LatticeEffect(String acBaseName, String acGradName) {
        super(1);
        this.m_kVShader.set(0, new VertexShader("LatticeV.glsl"));
        this.m_kPShader.set(0, new PixelShader("LatticeP.glsl"));
        ((PixelShader)this.m_kPShader.get(0)).SetTextureQuantity(1);
        Texture pkBase = ((PixelShader)this.m_kPShader.get(0)).GetTexture(0);
        pkBase.SetFilterType(Texture.FilterType.LINEAR);
        pkBase.SetWrapType(0, Texture.WrapType.REPEAT);
        pkBase.SetWrapType(1, Texture.WrapType.REPEAT);
        this.m_afScale[0] = 10.0f;
        this.m_afScale[1] = 10.0f;
        this.m_afThreshold[0] = 0.6f;
        this.m_afThreshold[1] = 0.3f;
    }

    @Override
    public void dispose() {
        this.m_afScale = null;
        this.m_afThreshold = null;
        super.dispose();
    }

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_FLOAT * 4;
    }

    public Vector2f GetScale() {
        return new Vector2f(this.m_afScale[0], this.m_afScale[1]);
    }

    public Vector2f GetThreshold() {
        return new Vector2f(this.m_afThreshold[0], this.m_afThreshold[1]);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        this.m_afScale[0] = rkStream.ReadFloat();
        this.m_afScale[1] = rkStream.ReadFloat();
        this.m_afThreshold[0] = rkStream.ReadFloat();
        this.m_afThreshold[1] = rkStream.ReadFloat();
    }

    @Override
    public void OnLoadPrograms(int iPass, Program pkVProgram, Program pkPProgram, Program pkCProgram) {
        if (pkPProgram.GetUC("Scale") != null) {
            pkPProgram.GetUC("Scale").SetDataSource(this.m_afScale);
            pkCProgram.GetUC("Scale").SetDataSource(this.m_afScale);
        }
        if (pkPProgram.GetUC("Threshold") != null) {
            pkPProgram.GetUC("Threshold").SetDataSource(this.m_afThreshold);
            pkCProgram.GetUC("Scale").SetDataSource(this.m_afScale);
        }
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.m_afScale[0]);
        rkStream.Write(this.m_afScale[1]);
        rkStream.Write(this.m_afThreshold[0]);
        rkStream.Write(this.m_afThreshold[1]);
    }

    @Override
    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("LatticeEffect", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        Vector2f kScale = new Vector2f(this.m_afScale[0], this.m_afScale[1]);
        Vector2f kThreshold = new Vector2f(this.m_afThreshold[0], this.m_afThreshold[1]);
        pkTree.Append(StringTree.Format("scale =", kScale));
        pkTree.Append(StringTree.Format("threshold =", kThreshold));
        return pkTree;
    }

    public void SetScale(Vector2f rkScale) {
        this.m_afScale[0] = rkScale.X;
        this.m_afScale[1] = rkScale.Y;
    }

    public void SetThreshold(Vector2f rkThreshold) {
        this.m_afThreshold[0] = rkThreshold.X;
        this.m_afThreshold[1] = rkThreshold.Y;
    }
}

