/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.ObjectSystem;

import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import java.io.Serializable;
import java.util.Vector;

public abstract class GraphicsObject
implements Serializable {
    private static final long serialVersionUID = 7273516765247196854L;
    private String m_kName = new String();
    private int m_uiID = ms_uiNextID++;
    private static int ms_uiNextID = 0;

    public static int GetNextID() {
        return ms_uiNextID;
    }

    public void dispose() {
        this.m_kName = null;
    }

    public void GetAllObjectsByName(String rkName, Vector<GraphicsObject> rkObjects) {
        if (rkName.equals(this.m_kName)) {
            rkObjects.add(this);
        }
    }

    public int GetDiskUsed(StreamVersion rkVersion) {
        Class<?> kClass = this.getClass();
        int iUsed = Stream.SIZEOF_INT + kClass.getName().length();
        iUsed += Stream.SIZEOF_INT;
        return iUsed += Stream.SIZEOF_INT + this.m_kName.length();
    }

    public int GetID() {
        return this.m_uiID;
    }

    public String GetName() {
        return this.m_kName;
    }

    public GraphicsObject GetObjectByID(int uiID) {
        if (uiID == this.m_uiID) {
            return this;
        }
        return null;
    }

    public GraphicsObject GetObjectByIDBase(int uiID) {
        if (uiID == this.m_uiID) {
            return this;
        }
        return null;
    }

    public GraphicsObject GetObjectByName(String rkName) {
        if (rkName.equals(this.m_kName)) {
            return this;
        }
        return null;
    }

    public GraphicsObject GetObjectByNameBase(String rkName) {
        if (rkName.equals(this.m_kName)) {
            return this;
        }
        return null;
    }

    public void Link(Stream rkStream, Stream.Link pkLink) {
    }

    public void Load(Stream rkStream, Stream.Link pkLink) {
        int iLinkID = rkStream.ReadInt();
        rkStream.InsertInMap(iLinkID, pkLink);
        this.m_kName = rkStream.ReadString();
    }

    public boolean Register(Stream rkStream) {
        int iID = this.m_uiID;
        if (rkStream.InsertInMap(iID, new Stream.Link(rkStream))) {
            rkStream.InsertInOrdered(this);
            return true;
        }
        return false;
    }

    public void Save(Stream rkStream) {
        Class<?> kClass = this.getClass();
        rkStream.Write(kClass.getName());
        rkStream.Write(this.m_uiID);
        rkStream.Write(this.m_kName);
    }

    public StringTree SaveStrings(String acTitle) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("GraphicsObject", this.GetName()));
        pkTree.Append(StringTree.Format("ID   =", this.m_uiID));
        return pkTree;
    }

    public void SetName(String rkName) {
        this.m_kName = rkName;
    }
}

