/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.ObjectSystem;

import WildMagic.LibFoundation.Mathematics.ColorRGB;
import WildMagic.LibFoundation.Mathematics.ColorRGBA;
import WildMagic.LibFoundation.Mathematics.Matrix3f;
import WildMagic.LibFoundation.Mathematics.Plane3f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.SceneGraph.Transformation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Stream {
    public static int SIZEOF_INT = 4;
    public static int SIZEOF_FLOAT = 4;
    public static int SIZEOF_BOOLEAN = 1;
    public static int SIZEOF_BYTE = 1;
    protected StreamVersion m_kVersion;
    protected Vector<GraphicsObject> m_apkTopLevel;
    protected Hashtable<Integer, Link> m_kMap = new Hashtable(1024);
    protected Vector<GraphicsObject> m_kOrdered;
    protected int m_iBufferSize = 0;
    protected int m_iBufferNext = 0;
    protected ByteArrayInputStream m_acBuffer = null;
    protected ByteArrayOutputStream m_acBufferOut;
    protected DataOutputStream m_acDataOut;
    protected DataInputStream m_acDataIn;
    protected static final String ms_acTopLevel = new String("Top Level");

    public Stream() {
        this.m_apkTopLevel = new Vector();
        this.m_kOrdered = new Vector();
    }

    public static ByteArrayInputStream LoadFile(String acFilename) {
        File kFile = new File(acFilename);
        if (!kFile.exists() || !kFile.canRead()) {
            return null;
        }
        int iLength = (int)kFile.length();
        if (iLength <= 0) {
            return null;
        }
        try {
            FileInputStream kFileReader = new FileInputStream(kFile);
            byte[] racBuffer = new byte[iLength];
            kFileReader.read(racBuffer, 0, iLength);
            kFileReader.close();
            ByteArrayInputStream kByteStream = new ByteArrayInputStream(racBuffer);
            return kByteStream;
        }
        catch (FileNotFoundException e1) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void dispose() {
        this.m_kMap.clear();
        this.m_kOrdered.clear();
        this.RemoveAll();
    }

    public int GetBufferNext() {
        return this.m_iBufferNext;
    }

    public int GetBufferSize() {
        return this.m_iBufferSize;
    }

    public int GetDiskUsed() {
        int i;
        for (i = 0; i < this.m_apkTopLevel.size(); ++i) {
            this.m_apkTopLevel.get(i).Register(this);
        }
        int iSize = 0;
        for (i = 0; i < this.m_kOrdered.size(); ++i) {
            iSize += this.m_kOrdered.get(i).GetDiskUsed(StreamVersion.CURRENT);
        }
        this.m_kMap.clear();
        this.m_kOrdered.clear();
        return iSize;
    }

    public GraphicsObject GetFromMap(Integer iID) {
        Link ppkLink = this.m_kMap.get(iID);
        return ppkLink != null ? ppkLink.GetObject() : null;
    }

    public GraphicsObject GetObjectAt(int i) {
        if (0 <= i && i < this.m_apkTopLevel.size()) {
            return this.m_apkTopLevel.get(i);
        }
        return null;
    }

    public int GetObjectCount() {
        return this.m_apkTopLevel.size();
    }

    public GraphicsObject GetOrderedObject(int i) {
        assert (0 <= i && i < this.m_kOrdered.size());
        if (i < 0 || i >= this.m_kOrdered.size()) {
            return null;
        }
        return this.m_kOrdered.get(i);
    }

    public int GetOrderedQuantity() {
        return this.m_kOrdered.size();
    }

    public StreamVersion GetVersion() {
        return this.m_kVersion;
    }

    public boolean Insert(GraphicsObject pkObject) {
        if (pkObject != null) {
            for (int i = 0; i < this.m_apkTopLevel.size(); ++i) {
                if (pkObject != this.m_apkTopLevel.get(i)) continue;
                return false;
            }
            this.m_apkTopLevel.add(pkObject);
            return true;
        }
        return false;
    }

    public boolean IsTopLevel(GraphicsObject pkObject) {
        for (int i = 0; i < this.m_apkTopLevel.size(); ++i) {
            if (pkObject != this.m_apkTopLevel.get(i)) continue;
            return true;
        }
        return false;
    }

    public boolean Load(ByteArrayInputStream acBuffer, int iSize) {
        this.m_kMap.clear();
        this.m_kOrdered.clear();
        this.RemoveAll();
        this.m_iBufferSize = iSize;
        this.m_acBuffer = acBuffer;
        this.m_acDataIn = new DataInputStream(this.m_acBuffer);
        String kTopLevel = new String(ms_acTopLevel);
        GraphicsObject pkObject = null;
        while (this.m_iBufferNext < this.m_iBufferSize) {
            Class<?> kClass;
            String kString = new String();
            kString = this.ReadString();
            boolean bTopLevel = kString.equals(kTopLevel);
            if (bTopLevel) {
                kString = this.ReadString();
            }
            try {
                kClass = Class.forName(kString);
            }
            catch (ClassNotFoundException e) {
                assert (false);
                return false;
            }
            Constructor<?> kConstructor = null;
            try {
                kConstructor = kClass.getConstructor(null);
            }
            catch (SecurityException e) {
                e.printStackTrace();
                assert (false);
                return false;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                assert (false);
                return false;
            }
            try {
                pkObject = (GraphicsObject)kConstructor.newInstance(null);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                assert (false);
                return false;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                assert (false);
                return false;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                assert (false);
                return false;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                assert (false);
                return false;
            }
            Link pkLink = new Link(pkObject);
            pkObject.Load(this, pkLink);
            if (!bTopLevel) continue;
            this.Insert(pkObject);
        }
        Enumeration<Link> kE = this.m_kMap.elements();
        while (kE.hasMoreElements()) {
            Link ppkLink = kE.nextElement();
            pkObject = ppkLink.GetObject();
            pkObject.Link(this, ppkLink);
            this.m_kOrdered.add(pkObject);
        }
        this.m_acBuffer = null;
        this.m_iBufferSize = 0;
        this.m_iBufferNext = 0;
        return true;
    }

    public boolean Load(String acFilename) {
        ByteArrayInputStream acBuffer = Stream.LoadFile(acFilename);
        if (acBuffer == null) {
            return false;
        }
        int iSize = acBuffer.available();
        if (iSize < StreamVersion.LENGTH) {
            acBuffer = null;
            return false;
        }
        byte[] abHeader = new byte[StreamVersion.LENGTH];
        acBuffer.read(abHeader, 0, StreamVersion.LENGTH);
        String kHeader = new String(abHeader);
        this.m_kVersion = new StreamVersion(kHeader);
        if (!this.m_kVersion.IsValid()) {
            acBuffer = null;
            return false;
        }
        if (!this.Load(acBuffer, iSize -= StreamVersion.LENGTH)) {
            acBuffer = null;
            return false;
        }
        acBuffer = null;
        return true;
    }

    public void Read(boolean[] rbValue) {
        try {
            rbValue[0] = this.m_acDataIn.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += SIZEOF_BOOLEAN;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Read(ColorRGB rkValue) {
        try {
            rkValue.R = this.m_acDataIn.readFloat();
            rkValue.G = this.m_acDataIn.readFloat();
            rkValue.B = this.m_acDataIn.readFloat();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += 3 * SIZEOF_FLOAT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Read(ColorRGBA rkValue) {
        try {
            rkValue.R = this.m_acDataIn.readFloat();
            rkValue.G = this.m_acDataIn.readFloat();
            rkValue.B = this.m_acDataIn.readFloat();
            rkValue.A = this.m_acDataIn.readFloat();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += 4 * SIZEOF_FLOAT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Read(float[] rfValue) {
        try {
            rfValue[0] = this.m_acDataIn.readFloat();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += SIZEOF_FLOAT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Read(int iQuantity, byte[] aucValue) {
        try {
            this.m_acDataIn.read(aucValue, 0, iQuantity);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void Read(int iQuantity, ColorRGB[] rkValue) {
        try {
            for (int i = 0; i < iQuantity; ++i) {
                rkValue[i].R = this.m_acDataIn.readFloat();
                rkValue[i].G = this.m_acDataIn.readFloat();
                rkValue[i].B = this.m_acDataIn.readFloat();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += iQuantity * 3 * SIZEOF_FLOAT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Read(int iQuantity, ColorRGBA[] rkValue) {
        try {
            for (int i = 0; i < iQuantity; ++i) {
                rkValue[i].R = this.m_acDataIn.readFloat();
                rkValue[i].G = this.m_acDataIn.readFloat();
                rkValue[i].B = this.m_acDataIn.readFloat();
                rkValue[i].A = this.m_acDataIn.readFloat();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += iQuantity * 4 * SIZEOF_FLOAT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Read(int iQuantity, float[] afValue) {
        try {
            for (int i = 0; i < iQuantity; ++i) {
                afValue[i] = this.m_acDataIn.readFloat();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += iQuantity * SIZEOF_FLOAT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Read(int iQuantity, int[] aiValue) {
        try {
            for (int i = 0; i < iQuantity; ++i) {
                aiValue[i] = this.m_acDataIn.readInt();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += iQuantity * SIZEOF_INT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Read(int[] riValue) {
        try {
            riValue[0] = this.m_acDataIn.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += SIZEOF_INT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Read(Matrix3f rkValue) {
        try {
            for (int i = 0; i < 9; ++i) {
                rkValue.Set(i, this.m_acDataIn.readFloat());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += 9 * SIZEOF_FLOAT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Read(Plane3f rkValue) {
        this.Read(rkValue.Normal);
        rkValue.Constant = this.ReadFloat();
    }

    public void Read(Transformation rkValue) {
        Matrix3f kMatrix = new Matrix3f();
        this.Read(kMatrix);
        rkValue.SetMatrix(kMatrix);
        Vector3f kVector = new Vector3f();
        this.Read(kVector);
        rkValue.SetTranslate(kVector);
        this.Read(kVector);
        rkValue.SetScale(kVector);
        boolean bValue = this.ReadBoolean();
        rkValue.SetIsIdentity(bValue);
        bValue = this.ReadBoolean();
        rkValue.SetIsRSMatrix(bValue);
        bValue = this.ReadBoolean();
        rkValue.SetIsUniformScale(bValue);
    }

    public void Read(Vector3f rkValue) {
        try {
            rkValue.X = this.m_acDataIn.readFloat();
            rkValue.Y = this.m_acDataIn.readFloat();
            rkValue.Z = this.m_acDataIn.readFloat();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += 3 * SIZEOF_FLOAT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public boolean ReadBoolean() {
        boolean bReturn = false;
        try {
            bReturn = this.m_acDataIn.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += SIZEOF_BOOLEAN;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
        return bReturn;
    }

    public float ReadFloat() {
        float fReturn = 0.0f;
        try {
            fReturn = this.m_acDataIn.readFloat();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += SIZEOF_FLOAT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
        return fReturn;
    }

    public int ReadInt() {
        int iReturn = 0;
        try {
            iReturn = this.m_acDataIn.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += SIZEOF_INT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
        return iReturn;
    }

    public String ReadString() {
        int iLength = this.ReadInt();
        String sReturn = null;
        if (iLength > 0) {
            byte[] abHeader = new byte[iLength];
            try {
                this.m_acDataIn.read(abHeader, 0, iLength);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            sReturn = new String(abHeader);
            this.m_iBufferNext += iLength;
            assert (this.m_iBufferNext <= this.m_iBufferSize);
        }
        return sReturn;
    }

    public boolean Remove(GraphicsObject pkObject) {
        if (pkObject != null) {
            for (int i = 0; i < this.m_apkTopLevel.size(); ++i) {
                if (pkObject != this.m_apkTopLevel.get(i)) continue;
                this.m_apkTopLevel.remove(i);
                return true;
            }
        }
        return false;
    }

    public void RemoveAll() {
        this.m_apkTopLevel.clear();
    }

    public byte[] Save(int[] riSize) {
        int i;
        this.m_kMap.clear();
        this.m_kOrdered.clear();
        for (i = 0; i < this.m_apkTopLevel.size(); ++i) {
            this.m_apkTopLevel.get(i).Register(this);
        }
        String kTopLevel = new String(ms_acTopLevel);
        int iTLGetDiskUsed = SIZEOF_INT + kTopLevel.length();
        this.m_iBufferSize = this.m_apkTopLevel.size() * iTLGetDiskUsed;
        for (i = 0; i < this.m_kOrdered.size(); ++i) {
            int iUsed = this.m_kOrdered.get(i).GetDiskUsed(StreamVersion.CURRENT);
            this.m_iBufferSize += iUsed;
        }
        this.m_acBufferOut = new ByteArrayOutputStream(this.m_iBufferSize);
        this.m_acDataOut = new DataOutputStream(this.m_acBufferOut);
        this.m_iBufferNext = 0;
        for (i = 0; i < this.m_kOrdered.size(); ++i) {
            GraphicsObject pkObject = this.m_kOrdered.get(i);
            if (this.IsTopLevel(pkObject)) {
                this.Write(kTopLevel);
            }
            pkObject.Save(this);
        }
        assert (this.m_iBufferNext == this.m_iBufferSize);
        if (this.m_iBufferNext != this.m_iBufferSize) {
            assert (false);
            this.m_acBufferOut = null;
            riSize[0] = 0;
            return null;
        }
        byte[] racBuffer = this.m_acBufferOut.toByteArray();
        riSize[0] = this.m_iBufferSize;
        this.m_acBufferOut = null;
        this.m_iBufferSize = 0;
        this.m_iBufferNext = 0;
        return racBuffer;
    }

    public boolean Save(String acFilename) {
        File kFile = new File(acFilename);
        FileOutputStream kFileWriter = null;
        try {
            kFileWriter = new FileOutputStream(kFile);
        }
        catch (FileNotFoundException e1) {
            return false;
        }
        try {
            kFileWriter.write(StreamVersion.LABEL.getBytes(), 0, StreamVersion.LENGTH);
        }
        catch (IOException e2) {
            return false;
        }
        int[] iSize = new int[1];
        byte[] acBuffer = this.Save(iSize);
        if (acBuffer == null) {
            return false;
        }
        try {
            kFileWriter.write(acBuffer, 0, iSize[0]);
            kFileWriter.close();
        }
        catch (IOException e2) {
            acBuffer = null;
            return false;
        }
        acBuffer = null;
        return true;
    }

    public boolean SaveText(String acFilename, int iTabSize) {
        StringTree kRoot = new StringTree();
        kRoot.Append(StringTree.Format(acFilename));
        int iCQuantity = this.GetObjectCount();
        for (int i = 0; i < iCQuantity; ++i) {
            GraphicsObject pkObject = this.m_apkTopLevel.get(i);
            assert (pkObject != null);
            kRoot.Append(pkObject.SaveStrings(null));
        }
        return kRoot.Save(acFilename, iTabSize);
    }

    public void Write(boolean bValue) {
        try {
            this.m_acDataOut.writeBoolean(bValue);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += SIZEOF_BOOLEAN;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Write(ColorRGB rkValue) {
        try {
            this.m_acDataOut.writeFloat(rkValue.R);
            this.m_acDataOut.writeFloat(rkValue.G);
            this.m_acDataOut.writeFloat(rkValue.B);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += 3 * SIZEOF_FLOAT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Write(ColorRGBA rkValue) {
        try {
            this.m_acDataOut.writeFloat(rkValue.R);
            this.m_acDataOut.writeFloat(rkValue.G);
            this.m_acDataOut.writeFloat(rkValue.B);
            this.m_acDataOut.writeFloat(rkValue.A);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += 4 * SIZEOF_FLOAT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Write(float fValue) {
        try {
            this.m_acDataOut.writeFloat(fValue);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += SIZEOF_FLOAT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Write(int iValue) {
        try {
            this.m_acDataOut.writeInt(iValue);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += SIZEOF_INT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Write(int iQuantity, byte[] aucValue) {
        try {
            this.m_acDataOut.write(aucValue, 0, iQuantity);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += iQuantity;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Write(int iQuantity, ColorRGB[] rkValue) {
        try {
            for (int i = 0; i < iQuantity; ++i) {
                this.m_acDataOut.writeFloat(rkValue[i].R);
                this.m_acDataOut.writeFloat(rkValue[i].G);
                this.m_acDataOut.writeFloat(rkValue[i].B);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += iQuantity * 3 * SIZEOF_FLOAT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Write(int iQuantity, ColorRGBA[] rkValue) {
        try {
            for (int i = 0; i < iQuantity; ++i) {
                this.m_acDataOut.writeFloat(rkValue[i].R);
                this.m_acDataOut.writeFloat(rkValue[i].G);
                this.m_acDataOut.writeFloat(rkValue[i].B);
                this.m_acDataOut.writeFloat(rkValue[i].A);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += iQuantity * 4 * SIZEOF_FLOAT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Write(int iQuantity, float[] afValue) {
        try {
            for (int i = 0; i < iQuantity; ++i) {
                this.m_acDataOut.writeFloat(afValue[i]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += iQuantity * SIZEOF_FLOAT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Write(int iQuantity, int[] aiValue) {
        try {
            for (int i = 0; i < iQuantity; ++i) {
                this.m_acDataOut.writeInt(aiValue[i]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += iQuantity * SIZEOF_INT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Write(Matrix3f rkValue) {
        try {
            for (int i = 0; i < 9; ++i) {
                this.m_acDataOut.writeFloat(rkValue.Get(i));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += 9 * SIZEOF_FLOAT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    public void Write(Plane3f rkValue) {
        this.Write(rkValue.Normal);
        this.Write(rkValue.Constant);
    }

    public void Write(String rkValue) {
        this.Write(rkValue.length());
        try {
            this.m_acDataOut.writeBytes(rkValue);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += rkValue.length();
    }

    public void Write(Transformation rkValue) {
        this.Write(rkValue.GetMatrix());
        this.Write(rkValue.GetTranslate());
        this.Write(rkValue.GetScale());
        this.Write(rkValue.IsIdentity());
        this.Write(rkValue.IsRSMatrix());
        this.Write(rkValue.IsUniformScale());
    }

    public void Write(Vector3f rkValue) {
        try {
            this.m_acDataOut.writeFloat(rkValue.X);
            this.m_acDataOut.writeFloat(rkValue.Y);
            this.m_acDataOut.writeFloat(rkValue.Z);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.m_iBufferNext += 3 * SIZEOF_FLOAT;
        assert (this.m_iBufferNext <= this.m_iBufferSize);
    }

    protected boolean InsertInMap(Integer iID, Link pkLink) {
        if (this.m_kMap.containsKey(iID)) {
            return false;
        }
        this.m_kMap.put(iID, pkLink);
        return true;
    }

    protected void InsertInOrdered(GraphicsObject pkObject) {
        this.m_kOrdered.add(pkObject);
    }

    public class Link {
        protected GraphicsObject m_pkObject = null;
        protected int m_iCurrent = 0;
        protected Vector<Integer> m_kLinkID = new Vector();

        public Link() {
        }

        public Link(GraphicsObject pkObject) {
            this.m_pkObject = pkObject;
            this.m_iCurrent = 0;
        }

        public void Add(Integer iLinkID) {
            this.m_kLinkID.add(iLinkID);
        }

        public Integer GetLinkID() {
            assert (this.m_iCurrent < this.m_kLinkID.size());
            return this.m_kLinkID.get(this.m_iCurrent++);
        }

        public GraphicsObject GetObject() {
            return this.m_pkObject;
        }

        public int GetQuantity() {
            return this.m_kLinkID.size();
        }

        public void SetObject(GraphicsObject pkObject) {
            this.m_pkObject = pkObject;
        }
    }
}

