/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.ObjectSystem;

import java.io.Serializable;

public class StreamVersion
implements Serializable {
    private static final long serialVersionUID = -3938193262157421045L;
    public static final int MAJOR = 4;
    public static final int MINOR = 0;
    public static final String LABEL = new String("Wild Magic Object File 4.02");
    public static final int LENGTH = LABEL.length();
    public static final StreamVersion CURRENT = new StreamVersion(4, 0);
    protected int m_iMajor;
    protected int m_iMinor;

    public StreamVersion() {
        this.m_iMajor = 4;
        this.m_iMinor = 0;
    }

    public StreamVersion(int iMajor, int iMinor) {
        this.m_iMajor = iMajor;
        this.m_iMinor = iMinor;
    }

    public StreamVersion(String acString) {
        this.m_iMajor = -1;
        this.m_iMinor = -1;
        if (acString != null && acString.length() >= LENGTH - 1 && acString.regionMatches(0, LABEL, 0, LENGTH - 5)) {
            String acVersion = acString.substring(LENGTH - 5).trim();
            String acMajor = acVersion.substring(0, 1);
            this.m_iMajor = new Integer(acMajor);
            String acMinor = acVersion.substring(2);
            this.m_iMinor = new Integer(acMinor);
        }
    }

    public int GetMajor() {
        return this.m_iMajor;
    }

    public int GetMinor() {
        return this.m_iMinor;
    }

    public boolean GreaterEqual(StreamVersion rkVersion) {
        return this.GetCombined() >= rkVersion.GetCombined();
    }

    public boolean IsValid() {
        return this.m_iMajor == 4 && 0 <= this.m_iMinor && this.m_iMinor < 100;
    }

    protected int GetCombined() {
        return 100 * this.m_iMajor + this.m_iMinor;
    }
}

