/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.ObjectSystem;

import WildMagic.LibFoundation.Mathematics.ColorRGB;
import WildMagic.LibFoundation.Mathematics.ColorRGBA;
import WildMagic.LibFoundation.Mathematics.Line3f;
import WildMagic.LibFoundation.Mathematics.Matrix3f;
import WildMagic.LibFoundation.Mathematics.Plane3f;
import WildMagic.LibFoundation.Mathematics.Vector2f;
import WildMagic.LibFoundation.Mathematics.Vector3f;
import WildMagic.LibGraphics.SceneGraph.BoundingVolume;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class StringTree {
    private Vector<String> m_kStrings = new Vector();
    private Vector<StringTree> m_kChildren = new Vector();

    public static String Format(Class<?> pkRTTI, String acName) {
        assert (pkRTTI != null);
        String acRTTIName = pkRTTI.getName();
        if (acName != null) {
            return new String(acRTTIName + " <" + acName + ">");
        }
        return new String(acRTTIName);
    }

    public static String Format(String acString) {
        if (acString != null) {
            return new String(acString);
        }
        return new String("<no title>");
    }

    public static String Format(String acPrefix, boolean bValue) {
        assert (acPrefix != null);
        if (bValue) {
            return new String(acPrefix + " true");
        }
        return new String(acPrefix + " false");
    }

    public static String Format(String acPrefix, BoundingVolume pkValue) {
        assert (acPrefix != null);
        String acX = StringTree.FormatFloat(pkValue.GetCenter().X);
        String acY = StringTree.FormatFloat(pkValue.GetCenter().Y);
        String acZ = StringTree.FormatFloat(pkValue.GetCenter().Z);
        String acR = StringTree.FormatFloat(pkValue.GetRadius());
        return new String(acPrefix + " " + "(x: " + acX + ", y: " + acY + ", z: " + acZ + ", r: " + acR + ")");
    }

    public static String Format(String acPrefix, byte ucValue) {
        assert (acPrefix != null);
        return new String(acPrefix + " " + ucValue);
    }

    public static String Format(String acPrefix, char cValue) {
        assert (acPrefix != null);
        return new String(acPrefix + " " + cValue);
    }

    public static String Format(String acPrefix, ColorRGB rkValue) {
        assert (acPrefix != null);
        return new String(acPrefix + " " + "(r: " + rkValue.R + ", g: " + rkValue.G + ", b: " + rkValue.B + ")");
    }

    public static String Format(String acPrefix, ColorRGBA rkValue) {
        assert (acPrefix != null);
        return new String(acPrefix + " " + "(r: " + rkValue.R + ", g: " + rkValue.G + ", b: " + rkValue.B + ", a: " + rkValue.A + ")");
    }

    public static String Format(String acPrefix, double dValue) {
        assert (acPrefix != null);
        return new String(acPrefix + " " + dValue);
    }

    public static String Format(String acPrefix, float fValue) {
        assert (acPrefix != null);
        return new String(acPrefix + " " + fValue);
    }

    public static String Format(String acPrefix, int iValue) {
        assert (acPrefix != null);
        return new String(acPrefix + " " + iValue);
    }

    public static StringTree Format(String acTitle, int iQuantity, float[] afValue) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format(acTitle));
        pkTree.Append(StringTree.Format("quantity =", iQuantity));
        for (int i = 0; i < iQuantity; ++i) {
            String kPrefix = new String(i + ": ");
            pkTree.Append(StringTree.Format(kPrefix, afValue[i]));
        }
        return pkTree;
    }

    public static StringTree Format(String acTitle, int iQuantity, int[] aiValue) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format(acTitle));
        pkTree.Append(StringTree.Format("quantity =", iQuantity));
        for (int i = 0; i < iQuantity; ++i) {
            String kPrefix = new String(i + ": ");
            pkTree.Append(StringTree.Format(kPrefix, aiValue[i]));
        }
        return pkTree;
    }

    public static String Format(String acPrefix, Line3f rkValue) {
        assert (acPrefix != null);
        return new String(acPrefix + " " + "(px: " + rkValue.Origin.X + ", py: " + rkValue.Origin.Y + ", pz: " + rkValue.Origin.Z + ", dx: " + rkValue.Direction.X + ", dy: " + rkValue.Direction.Y + ", dz: " + rkValue.Direction.Z + ")");
    }

    public static String Format(String acPrefix, long lValue) {
        assert (acPrefix != null);
        return new String(acPrefix + " " + lValue);
    }

    public static String Format(String acPrefix, Matrix3f rkValue) {
        assert (acPrefix != null);
        return new String(acPrefix + " " + "[c0:(" + rkValue.M00 + "," + rkValue.M10 + "," + rkValue.M20 + "),c1:(" + rkValue.M01 + "," + rkValue.M11 + "," + rkValue.M21 + "),c2:(" + rkValue.M02 + "," + rkValue.M12 + "," + rkValue.M22 + ")]");
    }

    public static String Format(String acPrefix, Plane3f rkValue) {
        assert (acPrefix != null);
        return new String(acPrefix + " " + "(nx: " + rkValue.Normal.X + ", ny: " + rkValue.Normal.Y + ", nz: " + rkValue.Normal.Z + ", c: " + rkValue.Constant + ")");
    }

    public static String Format(String acPrefix, short sValue) {
        assert (acPrefix != null);
        return new String(acPrefix + " " + sValue);
    }

    public static String Format(String acPrefix, String sValue) {
        assert (acPrefix != null);
        if (sValue != null) {
            return new String(acPrefix + " " + sValue);
        }
        return new String(acPrefix);
    }

    public static String Format(String acPrefix, Vector2f rkValue) {
        assert (acPrefix != null);
        String acX = StringTree.FormatFloat(rkValue.X);
        String acY = StringTree.FormatFloat(rkValue.Y);
        return new String(acPrefix + " " + "(x: " + acX + ", y: " + acY + ")");
    }

    public static String Format(String acPrefix, Vector3f rkValue) {
        assert (acPrefix != null);
        String acX = StringTree.FormatFloat(rkValue.X);
        String acY = StringTree.FormatFloat(rkValue.Y);
        String acZ = StringTree.FormatFloat(rkValue.Z);
        return new String(acPrefix + " " + "(x: " + acX + ", y: " + acY + ", z: " + acZ + ")");
    }

    public static String FormatDouble(double dValue) {
        if (dValue > -1.7976931348623157E308) {
            if (dValue < Double.MAX_VALUE) {
                return new Double(dValue).toString();
            }
            return new String("INFINITY");
        }
        return new String("-INFINITY");
    }

    public static String FormatFloat(float fValue) {
        if (fValue > -3.4028235E38f) {
            if (fValue < Float.MAX_VALUE) {
                return new Float(fValue).toString();
            }
            return new String("INFINITY");
        }
        return new String("-INFINITY");
    }

    public void Append(String acString) {
        this.m_kStrings.add(acString);
    }

    public void Append(StringTree pkChild) {
        this.m_kChildren.add(pkChild);
    }

    public void CreateNodes(DefaultMutableTreeNode kTop) {
        int i;
        String kHeader = new String("<no header>\n");
        if (this.m_kStrings.size() > 0) {
            kHeader = new String(this.m_kStrings.get(0) + "\n");
        }
        DefaultMutableTreeNode kNode = new DefaultMutableTreeNode(kHeader);
        kTop.add(kNode);
        if (this.m_kChildren.size() > 0) {
            this.m_kChildren.get(0).CreateNodes(kNode);
        }
        for (i = 1; i < this.m_kStrings.size(); ++i) {
            String kS = new String(this.m_kStrings.get(i));
            kNode.add(new DefaultMutableTreeNode(kS));
        }
        for (i = 1; i < this.m_kChildren.size(); ++i) {
            this.m_kChildren.get(i).CreateNodes(kNode);
        }
    }

    public void dispose() {
        this.m_kStrings.clear();
        this.m_kStrings = null;
        this.m_kChildren.clear();
        this.m_kChildren = null;
    }

    public StringTree GetChild(int i) {
        assert (0 <= i && i < this.m_kChildren.size());
        return this.m_kChildren.get(i);
    }

    public int GetChildQuantity() {
        return this.m_kChildren.size();
    }

    public String GetString(int i) {
        assert (0 <= i && i < this.m_kStrings.size());
        return this.m_kStrings.get(i);
    }

    public int GetStringQuantity() {
        return this.m_kStrings.size();
    }

    public boolean Save(String acFilename, int iTabSize) {
        File kFile = new File(acFilename);
        if (!kFile.exists()) {
            try {
                kFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!kFile.canWrite()) {
            return false;
        }
        FileOutputStream kFileWriter = null;
        try {
            kFileWriter = new FileOutputStream(kFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            this.Save(kFileWriter, 0, iTabSize);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            kFileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void SetChild(int i, StringTree pkChild) {
        assert (0 <= i && i < this.m_kStrings.size());
        this.m_kChildren.set(i, pkChild);
    }

    public void SetString(int i, String acString) {
        assert (0 <= i && i < this.m_kStrings.size());
        this.m_kStrings.set(i, acString);
    }

    private void Save(FileOutputStream pkOFile, int iLevel, int iTabSize) throws IOException {
        int j;
        String kS;
        int i;
        int iIndent = iLevel * iTabSize;
        String b = new String(" ");
        byte[] bSpace = b.getBytes();
        if (iIndent > 0) {
            for (i = 0; i < iIndent; ++i) {
                pkOFile.write(bSpace);
            }
        }
        if (iLevel < 10) {
            kS = new String(iLevel + ":  ");
            pkOFile.write(kS.getBytes());
        } else {
            kS = new String(iLevel + ": ");
            pkOFile.write(kS.getBytes());
        }
        if (this.m_kStrings.size() > 0) {
            kS = new String(this.m_kStrings.get(0) + "\n");
            pkOFile.write(kS.getBytes());
        } else {
            kS = new String("<no header>\n");
            pkOFile.write(kS.getBytes());
        }
        iIndent += 4;
        for (j = 1; j < this.m_kStrings.size(); ++j) {
            for (i = 0; i < iIndent; ++i) {
                pkOFile.write(bSpace);
            }
            String kS2 = new String(this.m_kStrings.get(j) + "\n");
            pkOFile.write(kS2.getBytes());
        }
        ++iLevel;
        for (j = 0; j < this.m_kChildren.size(); ++j) {
            this.m_kChildren.get(j).Save(pkOFile, iLevel, iTabSize);
        }
    }
}

