/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Rendering;

import WildMagic.LibFoundation.Mathematics.ColorRGBA;
import WildMagic.LibGraphics.ObjectSystem.Stream;
import WildMagic.LibGraphics.ObjectSystem.StreamInterface;
import WildMagic.LibGraphics.ObjectSystem.StreamVersion;
import WildMagic.LibGraphics.ObjectSystem.StringTree;
import WildMagic.LibGraphics.Rendering.GlobalState;
import java.io.Serializable;
import java.util.HashMap;

public class AlphaState
extends GlobalState
implements StreamInterface,
Serializable {
    private static final long serialVersionUID = 1474514343828822324L;
    public static HashMap<Integer, SrcBlendMode> SrcBlendModeMap = new HashMap();
    public static HashMap<Integer, DstBlendMode> DstBlendModeMap = new HashMap();
    public static HashMap<Integer, TestMode> TestModeMap = new HashMap();
    public static HashMap<Integer, BlendEquationMode> BlendEquationMap = new HashMap();
    private static SrcBlendMode ms_eSrcBlendModeStatic;
    private static DstBlendMode ms_eDstBlendModeStatic;
    private static TestMode ms_eTestModeStatic;
    private static BlendEquationMode ms_eBlendEquationStatic;
    public boolean BlendEnabled = false;
    public SrcBlendMode SrcBlend = SrcBlendMode.SBF_SRC_ALPHA;
    public DstBlendMode DstBlend = DstBlendMode.DBF_ONE_MINUS_SRC_ALPHA;
    public BlendEquationMode BlendEquation = BlendEquationMode.BE_ADD;
    public boolean TestEnabled = false;
    public TestMode Test = TestMode.TF_ALWAYS;
    public float Reference = 0.0f;
    public ColorRGBA ConstantColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);

    @Override
    public int GetDiskUsed(StreamVersion rkVersion) {
        return super.GetDiskUsed(rkVersion) + Stream.SIZEOF_BOOLEAN + Stream.SIZEOF_INT + Stream.SIZEOF_INT + Stream.SIZEOF_BOOLEAN + Stream.SIZEOF_INT + Stream.SIZEOF_FLOAT;
    }

    @Override
    public final GlobalState.StateType GetStateType() {
        return GlobalState.StateType.ALPHA;
    }

    @Override
    public void Link(Stream rkStream, Stream.Link pkLink) {
        super.Link(rkStream, pkLink);
    }

    @Override
    public void Load(Stream rkStream, Stream.Link pkLink) {
        super.Load(rkStream, pkLink);
        this.BlendEnabled = rkStream.ReadBoolean();
        int iSrcBlend = rkStream.ReadInt();
        this.SrcBlend = SrcBlendModeMap.get(iSrcBlend);
        int iDstBlend = rkStream.ReadInt();
        this.DstBlend = DstBlendModeMap.get(iDstBlend);
        this.TestEnabled = rkStream.ReadBoolean();
        int iTest = rkStream.ReadInt();
        this.Test = TestModeMap.get(iTest);
        this.Reference = rkStream.ReadFloat();
    }

    @Override
    public boolean Register(Stream rkStream) {
        return super.Register(rkStream);
    }

    @Override
    public void Save(Stream rkStream) {
        super.Save(rkStream);
        rkStream.Write(this.BlendEnabled);
        rkStream.Write(this.SrcBlend.Value());
        rkStream.Write(this.DstBlend.Value());
        rkStream.Write(this.TestEnabled);
        rkStream.Write(this.Test.Value());
        rkStream.Write(this.Reference);
    }

    @Override
    public StringTree SaveStrings(String kString) {
        StringTree pkTree = new StringTree();
        pkTree.Append(StringTree.Format("AlphaState", this.GetName()));
        pkTree.Append(super.SaveStrings(null));
        pkTree.Append(StringTree.Format("blend =", this.BlendEnabled));
        pkTree.Append(StringTree.Format("src = ", this.SrcBlend.Name()));
        pkTree.Append(StringTree.Format("dst = ", this.DstBlend.Name()));
        pkTree.Append(StringTree.Format("test =", this.TestEnabled));
        pkTree.Append(StringTree.Format("test func = ", this.Test.Name()));
        pkTree.Append(StringTree.Format("test ref =", this.Reference));
        return pkTree;
    }

    static {
        if (!DefaultInitialized[GlobalState.StateType.ALPHA.Value()]) {
            AlphaState.DefaultInitialized[GlobalState.StateType.ALPHA.Value()] = true;
            AlphaState.Default[GlobalState.StateType.ALPHA.Value()] = new AlphaState();
        }
        ms_eSrcBlendModeStatic = SrcBlendMode.SBF_QUANTITY;
        ms_eDstBlendModeStatic = DstBlendMode.DBF_QUANTITY;
        ms_eTestModeStatic = TestMode.TF_QUANTITY;
        ms_eBlendEquationStatic = BlendEquationMode.BE_QUANTITY;
    }

    public static enum TestMode {
        TF_NEVER("TF_NEVER"),
        TF_LESS("TF_LESS"),
        TF_EQUAL("TF_EQUAL"),
        TF_LEQUAL("TF_LEQUAL"),
        TF_GREATER("TF_GREATER"),
        TF_NOTEQUAL("TF_NOTEQUAL"),
        TF_GEQUAL("TF_GEQUAL"),
        TF_ALWAYS("TF_ALWAYS"),
        TF_QUANTITY("TF_QUANTITY");

        private int m_iValue;
        private String m_kName;
        private static int m_iInitValue;

        private TestMode(String kName) {
            this.m_kName = kName;
            this.m_iValue = this.Init();
            TestModeMap.put(this.m_iValue, this);
        }

        public String Name() {
            return this.m_kName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }

    public static enum SrcBlendMode {
        SBF_ZERO("SBF_ZERO"),
        SBF_ONE("SBF_ONE"),
        SBF_DST_COLOR("SBF_DST_COLOR"),
        SBF_ONE_MINUS_DST_COLOR("SBF_ONE_MINUS_DST_COLOR"),
        SBF_SRC_ALPHA("SBF_SRC_ALPHA"),
        SBF_ONE_MINUS_SRC_ALPHA("SBF_ONE_MINUS_SRC_ALPHA"),
        SBF_DST_ALPHA("SBF_DST_ALPHA"),
        SBF_ONE_MINUS_DST_ALPHA("SBF_ONE_MINUS_DST_ALPHA"),
        SBF_SRC_ALPHA_SATURATE("SBF_SRC_ALPHA_SATURATE"),
        SBF_CONSTANT_COLOR("SBF_CONSTANT_COLOR"),
        SBF_ONE_MINUS_CONSTANT_COLOR("SBF_ONE_MINUS_CONSTANT_COLOR"),
        SBF_CONSTANT_ALPHA("SBF_CONSTANT_ALPHA"),
        SBF_ONE_MINUS_CONSTANT_ALPHA("SBF_ONE_MINUS_CONSTANT_ALPHA"),
        SBF_QUANTITY("SBF_QUANTITY");

        private int m_iValue;
        private String m_kName;
        private static int m_iInitValue;

        private SrcBlendMode(String kName) {
            this.m_kName = kName;
            this.m_iValue = this.Init();
            SrcBlendModeMap.put(this.m_iValue, this);
        }

        public String Name() {
            return this.m_kName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }

    public static enum DstBlendMode {
        DBF_ZERO("DBF_ZERO"),
        DBF_ONE("DBF_ONE"),
        DBF_SRC_COLOR("DBF_SRC_COLOR"),
        DBF_ONE_MINUS_SRC_COLOR("DBF_ONE_MINUS_SRC_COLOR"),
        DBF_SRC_ALPHA("DBF_SRC_ALPHA"),
        DBF_ONE_MINUS_SRC_ALPHA("DBF_ONE_MINUS_SRC_ALPHA"),
        DBF_DST_ALPHA("DBF_DST_ALPHA"),
        DBF_ONE_MINUS_DST_ALPHA("DBF_ONE_MINUS_DST_ALPHA"),
        DBF_CONSTANT_COLOR("DBF_CONSTANT_COLOR"),
        DBF_ONE_MINUS_CONSTANT_COLOR("DBF_ONE_MINUS_CONSTANT_COLOR"),
        DBF_CONSTANT_ALPHA("DBF_CONSTANT_ALPHA"),
        DBF_ONE_MINUS_CONSTANT_ALPHA("DBF_ONE_MINUS_CONSTANT_ALPHA"),
        DBF_QUANTITY("DBF_QUANTITY");

        private int m_iValue;
        private String m_kName;
        private static int m_iInitValue;

        private DstBlendMode(String kName) {
            this.m_kName = kName;
            this.m_iValue = this.Init();
            DstBlendModeMap.put(this.m_iValue, this);
        }

        public String Name() {
            return this.m_kName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }

    public static enum BlendEquationMode {
        BE_ADD("BE_ADD"),
        BE_SUBTRACT("BE_SUBTRACT"),
        BE_REVERSE_SUBTRACT("BE_REVERSE_SUBTRACT"),
        BE_MIN("BE_MIN"),
        BE_MAX("BE_MAX"),
        BE_LOGIC_OP("BE_LOGIC_OP"),
        BE_QUANTITY("BE_QUANTITY");

        private int m_iValue;
        private String m_kName;
        private static int m_iInitValue;

        private BlendEquationMode(String kName) {
            this.m_kName = kName;
            this.m_iValue = this.Init();
            BlendEquationMap.put(this.m_iValue, this);
        }

        public String Name() {
            return this.m_kName;
        }

        public int Value() {
            return this.m_iValue;
        }

        private int Init() {
            return m_iInitValue++;
        }

        static {
            m_iInitValue = 0;
        }
    }
}

