/*
 * Decompiled with CFR 0.152.
 */
package WildMagic.LibGraphics.Rendering;

import WildMagic.LibGraphics.ObjectSystem.GraphicsObject;
import WildMagic.LibGraphics.Rendering.ReleaseFunction;
import WildMagic.LibGraphics.Rendering.Renderer;
import WildMagic.LibGraphics.Rendering.ResourceIdentifier;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class Bindable
extends GraphicsObject
implements Serializable {
    private static final long serialVersionUID = -1099675466736621779L;
    protected Vector<Info> m_kInfoArray = new Vector();
    private boolean m_bShared = true;

    public ResourceIdentifier GetIdentifier(int i, Renderer pkUser) {
        if (0 <= i && i < this.m_kInfoArray.size()) {
            Info rkInfo = this.m_kInfoArray.get(i);
            if (this.m_bShared) {
                return rkInfo.ID;
            }
            if (rkInfo.User == pkUser) {
                return rkInfo.ID;
            }
        }
        return null;
    }

    public ResourceIdentifier GetIdentifier(Renderer pkUser) {
        for (int i = 0; i < this.m_kInfoArray.size(); ++i) {
            Info rkInfo = this.m_kInfoArray.get(i);
            if (this.m_bShared) {
                return rkInfo.ID;
            }
            if (rkInfo.User != pkUser) continue;
            return rkInfo.ID;
        }
        return null;
    }

    public int GetInfoQuantity() {
        return this.m_kInfoArray.size();
    }

    public boolean GetShared() {
        return this.m_bShared;
    }

    public void OnLoad(Renderer pkUser, ReleaseFunction oRelease, ResourceIdentifier pkID) {
        Info kInfo = new Info();
        kInfo.User = pkUser;
        kInfo.Release = oRelease;
        kInfo.ID = pkID;
        this.m_kInfoArray.add(kInfo);
    }

    public void Release() {
        while (this.m_kInfoArray.size() > 0) {
            Info rkInfo = this.m_kInfoArray.get(0);
            rkInfo.Release.Release(this);
        }
    }

    public void Release(Renderer pkUser) {
        int iQuantity = this.m_kInfoArray.size();
        for (int i = 0; i < iQuantity; ++i) {
            Info rkInfo = this.m_kInfoArray.get(i);
            if (rkInfo.User != pkUser) continue;
            rkInfo.Release.Release(this);
        }
    }

    public void Remove() {
        if (this.m_kInfoArray != null) {
            this.m_kInfoArray.clear();
        }
    }

    public void SetShared(boolean bShared) {
        this.m_bShared = bShared;
    }

    protected void OnRelease(Renderer pkUser, ResourceIdentifier pkID) {
        int iQuantity = this.m_kInfoArray.size();
        for (int i = 0; i < iQuantity; ++i) {
            Info rkInfo = this.m_kInfoArray.get(i);
            if (!this.m_bShared && rkInfo.User != pkUser || rkInfo.ID != pkID) continue;
            if (i < --iQuantity) {
                this.m_kInfoArray.set(i, this.m_kInfoArray.get(iQuantity));
            }
            this.m_kInfoArray.remove(iQuantity);
            return;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_kInfoArray = new Vector();
    }

    protected class Info {
        Renderer User;
        ReleaseFunction Release;
        ResourceIdentifier ID;

        protected Info() {
        }
    }
}

